/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.table;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.ModelChangeEvent;
import fiji.plugin.trackmate.ModelChangeListener;
import fiji.plugin.trackmate.SelectionChangeEvent;
import fiji.plugin.trackmate.SelectionChangeListener;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.FileChooser;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.TrackMateModelView;
import fiji.plugin.trackmate.visualization.table.TablePanel;
import fiji.plugin.trackmate.visualization.trackscheme.utils.SearchBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TrackTableView
extends JFrame
implements TrackMateModelView,
ModelChangeListener,
SelectionChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String KEY = "TRACK_TABLES";
    private final Model model;
    private final TablePanel<Spot> spotTable;
    private final TablePanel<DefaultWeightedEdge> edgeTable;
    private final TablePanel<Integer> trackTable;
    private final AtomicBoolean ignoreSelectionChange = new AtomicBoolean(false);
    private final SelectionModel selectionModel;
    private String imagePath;

    public TrackTableView(final Model model, final SelectionModel selectionModel, final DisplaySettings ds, String imagePath) {
        super("Track tables");
        this.imagePath = imagePath;
        this.setIconImage(Icons.TRACKMATE_ICON.getImage());
        this.model = model;
        this.selectionModel = selectionModel;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.spotTable = TrackTableView.createSpotTable(model, ds);
        this.edgeTable = TrackTableView.createEdgeTable(model, ds);
        this.trackTable = TrackTableView.createTrackTable(model, ds);
        this.spotTable.getTable().getSelectionModel().addListSelectionListener(new SpotTableSelectionListener());
        this.edgeTable.getTable().getSelectionModel().addListSelectionListener(new EdgeTableSelectionListener());
        this.trackTable.getTable().getSelectionModel().addListSelectionListener(new TrackTableSelectionListener());
        JTabbedPane tabbedPane = new JTabbedPane(2);
        tabbedPane.add("Spots", this.spotTable.getPanel());
        tabbedPane.add("Edges", this.edgeTable.getPanel());
        tabbedPane.add("Tracks", this.trackTable.getPanel());
        tabbedPane.setSelectedComponent(this.spotTable.getPanel());
        mainPanel.add((Component)tabbedPane, "Center");
        JPanel toolbar = new JPanel();
        BoxLayout layout = new BoxLayout(toolbar, 2);
        toolbar.setLayout(layout);
        JButton exportBtn = new JButton("Export to CSV", Icons.CSV_ICON);
        exportBtn.addActionListener(e -> this.exportToCsv(tabbedPane.getSelectedIndex()));
        toolbar.add(exportBtn);
        toolbar.add(Box.createHorizontalGlue());
        SearchBar searchBar = new SearchBar(model, this);
        searchBar.setMaximumSize(new java.awt.Dimension(160, 30));
        toolbar.add(searchBar);
        JToggleButton tglColoring = new JToggleButton("coloring");
        tglColoring.addActionListener(e -> {
            this.spotTable.setUseColoring(tglColoring.isSelected());
            this.edgeTable.setUseColoring(tglColoring.isSelected());
            this.trackTable.setUseColoring(tglColoring.isSelected());
            this.refresh();
        });
        toolbar.add(tglColoring);
        mainPanel.add((Component)toolbar, "North");
        this.getContentPane().add(mainPanel);
        this.pack();
        final DisplaySettings.UpdateListener refresher = () -> this.refresh();
        ds.listeners().add((Object)refresher);
        selectionModel.addSelectionChangeListener(this);
        model.addModelChangeListener(this);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ TrackTableView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                selectionModel.removeSelectionChangeListener(this.this$0);
                model.removeModelChangeListener(this.this$0);
                ds.listeners().remove((Object)refresher);
            }
        });
    }

    private void exportToCsv(int index) {
        Object selectedFile;
        int lastIndexOf = this.imagePath.lastIndexOf(95);
        if (lastIndexOf > 0) {
            this.imagePath = this.imagePath.substring(0, lastIndexOf);
        }
        TablePanel<Comparable<Spot>> table = switch (index) {
            case 0 -> {
                selectedFile = this.imagePath + "_spots.csv";
                yield this.spotTable;
            }
            case 1 -> {
                selectedFile = this.imagePath + "_edges.csv";
                yield this.edgeTable;
            }
            case 2 -> {
                selectedFile = this.imagePath + "_tracks.csv";
                yield this.trackTable;
            }
            default -> throw new IllegalArgumentException("Unknown table with index " + index);
        };
        File file = FileChooser.chooseFile(this, (String)selectedFile, new FileNameExtensionFilter("CSV files", "csv"), "Export table to CSV", FileChooser.DialogType.SAVE, FileChooser.SelectionMode.FILES_ONLY);
        if (null == file) {
            return;
        }
        selectedFile = file.getAbsolutePath();
        try {
            table.exportToCsv(file);
        }
        catch (IOException e) {
            this.model.getLogger().error("Problem exporting to file " + String.valueOf(file) + "\n" + e.getMessage());
        }
        this.imagePath = selectedFile;
    }

    public static final TablePanel<Integer> createTrackTable(Model model, DisplaySettings ds) {
        ArrayList<Integer> objects = new ArrayList<Integer>(model.getTrackModel().trackIDs(true));
        ArrayList<String> features = new ArrayList<String>(model.getFeatureModel().getTrackFeatures());
        BiFunction<Integer, String, Double> featureFun = (trackID, feature) -> model.getFeatureModel().getTrackFeature((Integer)trackID, (String)feature);
        Map<String, String> featureNames = model.getFeatureModel().getTrackFeatureNames();
        Map<String, String> featureShortNames = model.getFeatureModel().getTrackFeatureShortNames();
        HashMap<String, String> featureUnits = new HashMap<String, String>();
        for (String feature2 : features) {
            Dimension dimension = model.getFeatureModel().getTrackFeatureDimensions().get(feature2);
            String units = TMUtils.getUnitsFor(dimension, model.getSpaceUnits(), model.getTimeUnits());
            featureUnits.put(feature2, units);
        }
        Map<String, Boolean> isInts = model.getFeatureModel().getTrackFeatureIsInt();
        HashMap<String, String> infoTexts = new HashMap<String, String>();
        Function<Integer, String> labelGenerator = id -> model.getTrackModel().name((Integer)id);
        BiConsumer<Integer, String> labelSetter = (id, label) -> model.getTrackModel().setName((Integer)id, (String)label);
        Supplier coloring = () -> FeatureUtils.createWholeTrackColorGenerator(model, ds);
        TablePanel<Integer> table = new TablePanel<Integer>(objects, features, featureFun, featureNames, featureShortNames, featureUnits, isInts, infoTexts, coloring, labelGenerator, labelSetter);
        return table;
    }

    public static final TablePanel<DefaultWeightedEdge> createEdgeTable(Model model, DisplaySettings ds) {
        ArrayList<DefaultWeightedEdge> objects = new ArrayList<DefaultWeightedEdge>();
        for (Integer trackID : model.getTrackModel().unsortedTrackIDs(true)) {
            objects.addAll(model.getTrackModel().trackEdges(trackID));
        }
        ArrayList<String> features = new ArrayList<String>(model.getFeatureModel().getEdgeFeatures());
        Map<String, String> featureNames = model.getFeatureModel().getEdgeFeatureNames();
        Map<String, String> featureShortNames = model.getFeatureModel().getEdgeFeatureShortNames();
        HashMap<String, String> featureUnits = new HashMap<String, String>();
        for (String feature2 : features) {
            Dimension dimension = model.getFeatureModel().getEdgeFeatureDimensions().get(feature2);
            String units = TMUtils.getUnitsFor(dimension, model.getSpaceUnits(), model.getTimeUnits());
            featureUnits.put(feature2, units);
        }
        Map<String, Boolean> isInts = model.getFeatureModel().getEdgeFeatureIsInt();
        HashMap<String, String> infoTexts = new HashMap<String, String>();
        Function<DefaultWeightedEdge, String> labelGenerator = edge -> String.format("%s \u2192 %s", model.getTrackModel().getEdgeSource((DefaultWeightedEdge)edge).getName(), model.getTrackModel().getEdgeTarget((DefaultWeightedEdge)edge).getName());
        BiConsumer labelSetter = null;
        String TRACK_ID = "TRACK_ID";
        features.add(0, "TRACK_ID");
        featureNames.put("TRACK_ID", "Track ID");
        featureShortNames.put("TRACK_ID", "Track ID");
        featureUnits.put("TRACK_ID", "");
        isInts.put("TRACK_ID", Boolean.TRUE);
        infoTexts.put("TRACK_ID", "The id of the track this spot belongs to.");
        BiFunction<DefaultWeightedEdge, String, Double> featureFun = (edge, feature) -> {
            if (feature.equals("TRACK_ID")) {
                Integer trackID = model.getTrackModel().trackIDOf((DefaultWeightedEdge)edge);
                return trackID == null ? null : Double.valueOf(trackID.doubleValue());
            }
            return model.getFeatureModel().getEdgeFeature((DefaultWeightedEdge)edge, (String)feature);
        };
        BiConsumer<DefaultWeightedEdge, Color> colorSetter = (edge, color) -> model.getFeatureModel().putEdgeFeature((DefaultWeightedEdge)edge, "MANUAL_EDGE_COLOR", Double.valueOf(color.getRGB()));
        Supplier coloring = () -> FeatureUtils.createTrackColorGenerator(model, ds);
        TablePanel<DefaultWeightedEdge> table = new TablePanel<DefaultWeightedEdge>(objects, features, featureFun, featureNames, featureShortNames, featureUnits, isInts, infoTexts, coloring, labelGenerator, labelSetter, "MANUAL_EDGE_COLOR", colorSetter);
        return table;
    }

    public static final TablePanel<Spot> createSpotTable(Model model, DisplaySettings ds) {
        ArrayList<Spot> objects = new ArrayList<Spot>();
        for (Integer trackID : model.getTrackModel().unsortedTrackIDs(true)) {
            objects.addAll(model.getTrackModel().trackSpots(trackID));
        }
        ArrayList<String> features = new ArrayList<String>(model.getFeatureModel().getSpotFeatures());
        Map<String, String> featureNames = model.getFeatureModel().getSpotFeatureNames();
        Map<String, String> featureShortNames = model.getFeatureModel().getSpotFeatureShortNames();
        HashMap<String, String> featureUnits = new HashMap<String, String>();
        for (String feature2 : features) {
            Dimension dimension = model.getFeatureModel().getSpotFeatureDimensions().get(feature2);
            String units = TMUtils.getUnitsFor(dimension, model.getSpaceUnits(), model.getTimeUnits());
            featureUnits.put(feature2, units);
        }
        Map<String, Boolean> isInts = model.getFeatureModel().getSpotFeatureIsInt();
        HashMap<String, String> infoTexts = new HashMap<String, String>();
        Function<Spot, String> labelGenerator = spot -> spot.getName();
        BiConsumer<Spot, String> labelSetter = (spot, label) -> spot.setName((String)label);
        String SPOT_ID = "ID";
        features.add(0, "ID");
        featureNames.put("ID", "Spot ID");
        featureShortNames.put("ID", "Spot ID");
        featureUnits.put("ID", "");
        isInts.put("ID", Boolean.TRUE);
        infoTexts.put("ID", "The id of the spot.");
        String TRACK_ID = "TRACK_ID";
        features.add(1, "TRACK_ID");
        featureNames.put("TRACK_ID", "Track ID");
        featureShortNames.put("TRACK_ID", "Track ID");
        featureUnits.put("TRACK_ID", "");
        isInts.put("TRACK_ID", Boolean.TRUE);
        infoTexts.put("TRACK_ID", "The id of the track this spot belongs to.");
        BiFunction<Spot, String, Double> featureFun = (spot, feature) -> {
            if (feature.equals("TRACK_ID")) {
                Integer trackID = model.getTrackModel().trackIDOf((Spot)spot);
                return trackID == null ? null : Double.valueOf(trackID.doubleValue());
            }
            if (feature.equals("ID")) {
                return spot.ID();
            }
            return spot.getFeature((String)feature);
        };
        BiConsumer<Spot, Color> colorSetter = (spot, color) -> spot.putFeature("MANUAL_SPOT_COLOR", Double.valueOf(color.getRGB()));
        Supplier coloring = () -> FeatureUtils.createSpotColorGenerator(model, ds);
        TablePanel<Spot> table = new TablePanel<Spot>(objects, features, featureFun, featureNames, featureShortNames, featureUnits, isInts, infoTexts, coloring, labelGenerator, labelSetter, "MANUAL_SPOT_COLOR", colorSetter);
        return table;
    }

    @Override
    public void render() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public void modelChanged(ModelChangeEvent event) {
        if (event.getEventID() == 9) {
            this.refresh();
            return;
        }
        ArrayList<Spot> spots = new ArrayList<Spot>();
        for (Integer n : this.model.getTrackModel().unsortedTrackIDs(true)) {
            spots.addAll(this.model.getTrackModel().trackSpots(n));
        }
        this.spotTable.setObjects(spots);
        ArrayList<DefaultWeightedEdge> edges = new ArrayList<DefaultWeightedEdge>();
        for (Integer trackID : this.model.getTrackModel().unsortedTrackIDs(true)) {
            edges.addAll(this.model.getTrackModel().trackEdges(trackID));
        }
        this.edgeTable.setObjects(edges);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.model.getTrackModel().trackIDs(true));
        this.trackTable.setObjects(arrayList);
        this.refresh();
    }

    @Override
    public void selectionChanged(SelectionChangeEvent event) {
        boolean added;
        boolean added2;
        if (this.ignoreSelectionChange.get()) {
            return;
        }
        this.ignoreSelectionChange.set(true);
        Set<Spot> selectedVertices = this.selectionModel.getSpotSelection();
        JTable vt = this.spotTable.getTable();
        vt.getSelectionModel().clearSelection();
        for (Spot spot : selectedVertices) {
            int row = this.spotTable.getViewRowForObject(spot);
            vt.getSelectionModel().addSelectionInterval(row, row);
        }
        Map<Spot, Boolean> spotsAdded = event.getSpots();
        if (spotsAdded != null && spotsAdded.size() == 1 && (added2 = spotsAdded.values().iterator().next().booleanValue())) {
            Spot spot = spotsAdded.keySet().iterator().next();
            this.centerViewOn(spot);
        }
        Set<DefaultWeightedEdge> selectedEdges = this.selectionModel.getEdgeSelection();
        JTable et = this.edgeTable.getTable();
        et.getSelectionModel().clearSelection();
        for (DefaultWeightedEdge e : selectedEdges) {
            int row = this.edgeTable.getViewRowForObject(e);
            et.getSelectionModel().addSelectionInterval(row, row);
        }
        Map<DefaultWeightedEdge, Boolean> edgesAdded = event.getEdges();
        if (edgesAdded != null && edgesAdded.size() == 1 && (added = edgesAdded.values().iterator().next().booleanValue())) {
            DefaultWeightedEdge edge = edgesAdded.keySet().iterator().next();
            this.centerViewOn(edge);
        }
        this.refresh();
        this.ignoreSelectionChange.set(false);
    }

    public void centerViewOn(DefaultWeightedEdge edge) {
        this.edgeTable.scrollToObject(edge);
    }

    @Override
    public void centerViewOn(Spot spot) {
        this.spotTable.scrollToObject(spot);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void clear() {
    }

    public TablePanel<Spot> getSpotTable() {
        return this.spotTable;
    }

    public TablePanel<DefaultWeightedEdge> getEdgeTable() {
        return this.edgeTable;
    }

    public TablePanel<Integer> getTrackTable() {
        return this.trackTable;
    }

    private final class SpotTableSelectionListener
    implements ListSelectionListener {
        private SpotTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting() || TrackTableView.this.ignoreSelectionChange.get()) {
                return;
            }
            TrackTableView.this.ignoreSelectionChange.set(true);
            int[] selectedRows = TrackTableView.this.spotTable.getTable().getSelectedRows();
            ArrayList<Spot> toSelect = new ArrayList<Spot>(selectedRows.length);
            for (int row : selectedRows) {
                toSelect.add(TrackTableView.this.spotTable.getObjectForViewRow(row));
            }
            TrackTableView.this.selectionModel.clearSelection();
            TrackTableView.this.selectionModel.addSpotToSelection(toSelect);
            TrackTableView.this.refresh();
            TrackTableView.this.ignoreSelectionChange.set(false);
        }
    }

    private final class EdgeTableSelectionListener
    implements ListSelectionListener {
        private EdgeTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting() || TrackTableView.this.ignoreSelectionChange.get()) {
                return;
            }
            TrackTableView.this.ignoreSelectionChange.set(true);
            int[] selectedRows = TrackTableView.this.edgeTable.getTable().getSelectedRows();
            ArrayList<DefaultWeightedEdge> toSelect = new ArrayList<DefaultWeightedEdge>(selectedRows.length);
            for (int row : selectedRows) {
                toSelect.add(TrackTableView.this.edgeTable.getObjectForViewRow(row));
            }
            TrackTableView.this.selectionModel.clearSelection();
            TrackTableView.this.selectionModel.addEdgeToSelection(toSelect);
            TrackTableView.this.refresh();
            TrackTableView.this.ignoreSelectionChange.set(false);
        }
    }

    private class TrackTableSelectionListener
    implements ListSelectionListener {
        private TrackTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            int[] selectedRows;
            if (event.getValueIsAdjusting() || TrackTableView.this.ignoreSelectionChange.get()) {
                return;
            }
            TrackTableView.this.ignoreSelectionChange.set(true);
            HashSet<Spot> spots = new HashSet<Spot>();
            HashSet<DefaultWeightedEdge> edges = new HashSet<DefaultWeightedEdge>();
            for (int row : selectedRows = TrackTableView.this.trackTable.getTable().getSelectedRows()) {
                Integer trackID = TrackTableView.this.trackTable.getObjectForViewRow(row);
                spots.addAll(TrackTableView.this.model.getTrackModel().trackSpots(trackID));
                edges.addAll(TrackTableView.this.model.getTrackModel().trackEdges(trackID));
            }
            TrackTableView.this.selectionModel.clearSelection();
            TrackTableView.this.selectionModel.addSpotToSelection(spots);
            TrackTableView.this.selectionModel.addEdgeToSelection(edges);
            TrackTableView.this.refresh();
            TrackTableView.this.ignoreSelectionChange.set(false);
        }
    }
}

