/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.AbstractDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.type.context.NumberContext;

abstract class RawDecomposition
extends AbstractDecomposition<Double> {
    private int myColDim;
    private double[][] myRawInPlaceData;
    private RawStore myRawInPlaceStore;
    private int myRowDim;

    protected RawDecomposition() {
    }

    protected PrimitiveDenseStore allocate(long numberOfRows, long numberOfColumns) {
        return (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(numberOfRows, numberOfColumns);
    }

    protected boolean checkSymmetry() {
        boolean retVal = this.myRowDim == this.myColDim;
        for (int i = 0; retVal && i < this.myRowDim; ++i) {
            for (int j = 0; retVal && j < i; retVal &= NumberContext.compare(this.myRawInPlaceData[i][j], this.myRawInPlaceData[j][i]) == 0, ++j) {
            }
        }
        return retVal;
    }

    protected final MatrixStore<Double> collect(Access2D.Collectable<Double, ? super DecompositionStore<Double>> source) {
        if (source instanceof MatrixStore) {
            return (MatrixStore)source;
        }
        if (source instanceof Access2D) {
            return PrimitiveDenseStore.FACTORY.builder().makeWrapper((Access2D)((Object)source)).get();
        }
        return (MatrixStore)source.collect(PrimitiveDenseStore.FACTORY);
    }

    protected int getColDim() {
        return this.myColDim;
    }

    @Override
    protected double getDimensionalEpsilon() {
        return (double)this.getMaxDim() * PrimitiveMath.MACHINE_EPSILON;
    }

    protected int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    protected int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    protected double[][] getRawInPlaceData() {
        return this.myRawInPlaceData;
    }

    protected RawStore getRawInPlaceStore() {
        return this.myRawInPlaceStore;
    }

    protected int getRowDim() {
        return this.myRowDim;
    }

    double[][] reset(Structure2D matrix, boolean transpose) {
        int tmpInPlaceColDim;
        this.reset();
        int tmpInputRowDim = (int)matrix.countRows();
        int tmpInputColDim = (int)matrix.countColumns();
        int tmpInPlaceRowDim = transpose ? tmpInputColDim : tmpInputRowDim;
        int n = tmpInPlaceColDim = transpose ? tmpInputRowDim : tmpInputColDim;
        if (this.myRawInPlaceData == null || this.myRowDim != tmpInputRowDim || this.myColDim != tmpInputColDim) {
            this.myRawInPlaceStore = (RawStore)RawStore.FACTORY.makeZero(tmpInPlaceRowDim, tmpInPlaceColDim);
            this.myRawInPlaceData = this.myRawInPlaceStore.data;
            this.myRowDim = tmpInputRowDim;
            this.myColDim = tmpInputColDim;
        }
        this.aspectRatioNormal(tmpInputRowDim >= tmpInputColDim);
        return this.myRawInPlaceData;
    }
}

