/*
 * Decompiled with CFR 0.152.
 */
package adt;

import java.util.Random;

public class ByteProbability {
    public static final double[] BYTE_TO_DOUBLE;
    public static final byte[] INTEGER_TO_BYTE;
    public static final byte[][] MULTIPLY;
    public static final byte[][] DIVIDE;

    public static byte toByte(double v) {
        byte nearest = 0;
        double nearestValue = Double.MAX_VALUE;
        for (int i = 0; i < 256; ++i) {
            double val = BYTE_TO_DOUBLE[i];
            double diff = Math.abs(v - val);
            if (!(diff < nearestValue)) continue;
            nearestValue = diff;
            nearest = INTEGER_TO_BYTE[i];
        }
        return nearest;
    }

    public static final byte multiply(byte a, byte b) {
        return MULTIPLY[a & 0xFF][b & 0xFF];
    }

    public static final byte divide(byte a, byte b) {
        return DIVIDE[a & 0xFF][b & 0xFF];
    }

    public static void main(String[] args) {
        double check;
        double multiply;
        double bd;
        double ad;
        byte b;
        byte a;
        int index2;
        int index1;
        int i;
        for (int i2 = 0; i2 < 256; ++i2) {
            System.out.println("i = " + i2);
            byte tstByte = INTEGER_TO_BYTE[i2];
            System.out.println("tstByte = " + tstByte);
            System.out.println("tstByte&0xFF = " + (tstByte & 0xFF));
            System.out.println("INTEGER_TO_BYTE[tstByte & 0xFF] = " + INTEGER_TO_BYTE[tstByte & 0xFF]);
            System.out.println("BYTE_TO_DOUBLE[tstByte&0xFF] = " + BYTE_TO_DOUBLE[tstByte & 0xFF]);
            tstByte = (byte)(tstByte + 1);
        }
        Random rnd = new Random();
        for (i = 0; i < 20; ++i) {
            index1 = rnd.nextInt(256);
            index2 = rnd.nextInt(256);
            a = INTEGER_TO_BYTE[index1];
            b = INTEGER_TO_BYTE[index2];
            ad = BYTE_TO_DOUBLE[a & 0xFF];
            bd = BYTE_TO_DOUBLE[b & 0xFF];
            multiply = BYTE_TO_DOUBLE[MULTIPLY[a & 0xFF][b & 0xFF] & 0xFF];
            check = ad * bd;
            System.out.println("multiply via byte = " + multiply);
            System.out.println("check via double = " + check);
        }
        for (i = 0; i < 20; ++i) {
            index1 = rnd.nextInt(256);
            index2 = rnd.nextInt(256);
            a = INTEGER_TO_BYTE[index1];
            b = INTEGER_TO_BYTE[index2];
            ad = BYTE_TO_DOUBLE[a & 0xFF];
            bd = BYTE_TO_DOUBLE[b & 0xFF];
            multiply = BYTE_TO_DOUBLE[DIVIDE[a & 0xFF][b & 0xFF] & 0xFF];
            check = ad / bd;
            System.out.println("divide via byte = " + multiply);
            System.out.println("check via double = " + check);
        }
    }

    static {
        int j;
        int i;
        BYTE_TO_DOUBLE = new double[256];
        INTEGER_TO_BYTE = new byte[256];
        MULTIPLY = new byte[256][256];
        DIVIDE = new byte[256][256];
        for (i = 0; i < 256; ++i) {
            ByteProbability.BYTE_TO_DOUBLE[i] = (double)i / 255.0;
        }
        for (i = -128; i <= 127; ++i) {
            byte val = (byte)i;
            int intVal = val & 0xFF;
            ByteProbability.INTEGER_TO_BYTE[intVal] = val;
        }
        for (i = 0; i < 256; ++i) {
            for (j = 0; j < 256; ++j) {
                ByteProbability.MULTIPLY[i][j] = ByteProbability.toByte(BYTE_TO_DOUBLE[i] * BYTE_TO_DOUBLE[j]);
            }
        }
        for (i = 0; i < 256; ++i) {
            for (j = 0; j < 256; ++j) {
                ByteProbability.DIVIDE[i][j] = ByteProbability.toByte(BYTE_TO_DOUBLE[i] / BYTE_TO_DOUBLE[j]);
            }
        }
    }
}

