/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;

public class MaxEntHistogram {
    private static final boolean debug = false;
    private long[] values = new long[256];
    private long total;
    int[] boundaries;

    public MaxEntHistogram(ImagePlus image) {
        ImageStack stack = image.getStack();
        for (int i = 1; i <= stack.getSize(); ++i) {
            this.initHistogram((ByteProcessor)stack.getProcessor(i));
        }
        this.total = stack.getWidth() * stack.getHeight() * stack.getSize();
    }

    public MaxEntHistogram(int[][] histograms) {
        this.total = 0L;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < histograms.length; ++j) {
                int n = i;
                this.values[n] = this.values[n] + (long)histograms[j][i];
                this.total += this.values[i];
            }
        }
    }

    private void initHistogram(ByteProcessor image) {
        byte[] pixels = (byte[])image.getPixels();
        int w = image.getWidth();
        int h = image.getHeight();
        for (int i = 0; i < w * h; ++i) {
            int value = pixels[i];
            if (value < 0) {
                value += 256;
            }
            int n = value;
            this.values[n] = this.values[n] + 1L;
        }
    }

    private int getMean(int start, int end) {
        long count = 0L;
        long count2 = 0L;
        for (int i = start; i < end; ++i) {
            count += (long)i * this.values[i];
            count2 += this.values[i];
        }
        if (count2 == 0L) {
            return (end - start) / 2;
        }
        return (int)(count / count2);
    }

    private double getPartialEntropy(int start, int end) {
        long count = 0L;
        for (int i = start; i < end; ++i) {
            count += this.values[i];
        }
        if (count == 0L) {
            return 0.0;
        }
        return -Math.log((double)count / (double)this.total) * (double)count / (double)this.total;
    }

    public double quantize(int K) {
        int[][][] boundaries = new int[K][256][K];
        double[][] entropies = new double[K][256];
        for (int k = 1; k <= K; ++k) {
            int startX = k < K ? k : 256;
            int endX = 256 - K + k;
            for (int x = startX; x <= endX; ++x) {
                if (k == 1) {
                    entropies[0][x - 1] = this.getPartialEntropy(0, x);
                    boundaries[0][x - 1][0] = x;
                } else {
                    int bestIndex = -1;
                    double bestEntropy = -1.7976931348623157E308;
                    for (int xLeft = k - 1; xLeft < x; ++xLeft) {
                        double entropy = entropies[k - 2][xLeft - 1] + this.getPartialEntropy(xLeft, x);
                        if (!(entropy > bestEntropy)) continue;
                        bestIndex = xLeft;
                        bestEntropy = entropy;
                    }
                    entropies[k - 1][x - 1] = bestEntropy;
                    System.arraycopy(boundaries[k - 2][bestIndex - 1], 0, boundaries[k - 1][x - 1], 0, k - 1);
                    boundaries[k - 1][x - 1][k - 1] = x;
                }
                IJ.showProgress((double)((double)k / (double)K));
            }
        }
        this.boundaries = boundaries[K - 1][255];
        return entropies[K - 1][255];
    }

    public void quantizeNaive(int K) {
        this.boundaries = new int[K];
        long total = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            total += this.values[i];
        }
        long cumul = 0L;
        int index = 0;
        for (int i = 0; i < K - 1; ++i) {
            while (index < this.values.length - (K - 1 - i) && cumul < total * (long)(i + 1) / (long)K) {
                cumul += this.values[index];
                ++index;
            }
            this.boundaries[i] = index;
            System.err.println(i + ": " + index);
        }
        this.boundaries[K - 1] = this.values.length;
        System.err.println(K - 1 + ": " + this.boundaries[K - 1]);
    }

    public byte[] getMapping(boolean showIndex) {
        byte[] result = new byte[256];
        int oldX = 0;
        for (int i = 0; i < this.boundaries.length; ++i) {
            int value = showIndex ? i : this.getMean(oldX, this.boundaries[i]);
            for (int j = oldX; j < this.boundaries[i]; ++j) {
                result[j] = (byte)value;
            }
            oldX = this.boundaries[i];
        }
        return result;
    }

    public int[][] get(int[][] histos) {
        int[][] result = new int[histos.length][this.boundaries.length];
        for (int j = 0; j < this.boundaries.length; ++j) {
            for (int i = 0; i < this.boundaries[j]; ++i) {
                for (int k = 0; k < histos.length; ++k) {
                    int[] nArray = result[k];
                    int n = j;
                    nArray[n] = nArray[n] + histos[k][i];
                }
            }
        }
        return result;
    }
}

