/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.color.ColorSpace;
import org.jhotdraw.color.NamedColorSpace;

public class HSLPhysiologicColorSpace
extends ColorSpace
implements NamedColorSpace {
    private static HSLPhysiologicColorSpace instance;

    public static HSLPhysiologicColorSpace getInstance() {
        if (instance == null) {
            instance = new HSLPhysiologicColorSpace();
        }
        return instance;
    }

    public HSLPhysiologicColorSpace() {
        super(7, 3);
    }

    @Override
    public float[] toRGB(float[] components) {
        float hue = components[0];
        float saturation = components[1];
        float lightness = components[2];
        if ((hue -= (float)Math.floor(hue)) < 0.0f) {
            hue = 1.0f + hue;
        }
        if (saturation > 1.0f) {
            saturation = 1.0f;
        } else if (saturation < 0.0f) {
            saturation = 0.0f;
        }
        if (lightness > 1.0f) {
            lightness = 1.0f;
        } else if (lightness < 0.0f) {
            lightness = 0.0f;
        }
        float hueDeg = hue * 360.0f;
        if (hueDeg < 0.0f) {
            hueDeg += 360.0f;
        }
        float hk = hue - (float)Math.floor(hue);
        hk = hueDeg < 120.0f ? (hk /= 2.0f) : (hueDeg < 160.0f ? (hk - 0.33333334f) * 3.0f / 2.0f + 0.16666667f : (hueDeg < 220.0f ? hk - 0.44444445f + 0.33333334f : (hueDeg < 280.0f ? hk - 0.6111111f + 0.5f : (hueDeg < 340.0f ? hk - 0.7777778f + 0.6666667f : (hk - 0.9444444f) * 3.0f + 0.8333333f))));
        float q = lightness < 0.5f ? lightness * (1.0f + saturation) : lightness + saturation - lightness * saturation;
        float p = 2.0f * lightness - q;
        float red = hk + 0.33333334f;
        float green = hk;
        float blue = hk - 0.33333334f;
        if (red < 0.0f) {
            red += 1.0f;
        }
        if (green < 0.0f) {
            green += 1.0f;
        }
        if (blue < 0.0f) {
            blue += 1.0f;
        }
        if (red > 1.0f) {
            red -= 1.0f;
        }
        if (green > 1.0f) {
            green -= 1.0f;
        }
        if (blue > 1.0f) {
            blue -= 1.0f;
        }
        red = red < 0.16666667f ? p + (q - p) * 6.0f * red : (red < 0.5f ? q : (red < 0.6666667f ? p + (q - p) * 6.0f * (0.6666667f - red) : p));
        green = green < 0.16666667f ? p + (q - p) * 6.0f * green : (green < 0.5f ? q : (green < 0.6666667f ? p + (q - p) * 6.0f * (0.6666667f - green) : p));
        blue = blue < 0.16666667f ? p + (q - p) * 6.0f * blue : (blue < 0.5f ? q : (blue < 0.6666667f ? p + (q - p) * 6.0f * (0.6666667f - blue) : p));
        return new float[]{red, green, blue};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float min;
        float r = rgbvalue[0];
        float g = rgbvalue[1];
        float b = rgbvalue[2];
        float max = Math.max(Math.max(r, g), b);
        float hue = max == (min = Math.min(Math.min(r, g), b)) ? 0.0f : (max == r && g >= b ? 120.0f * (g - b) / (max - min) : (max == r ? 20.0f * (g - b) / (max - min) + 360.0f : (max == g && r >= b ? 40.0f * (b - r) / (max - min) + 120.0f + 40.0f : (max == g ? 60.0f * (b - r) / (max - min) + 120.0f + 40.0f : (g >= r ? 60.0f * (r - g) / (max - min) + 240.0f + 40.0f : 60.0f * (r - g) / (max - min) + 240.0f + 40.0f)))));
        float luminance = (max + min) / 2.0f;
        float saturation = max == min ? 0.0f : (luminance <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - (max + min)));
        return new float[]{hue / 360.0f, saturation, luminance};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] rgb = this.toRGB(colorvalue);
        return ColorSpace.getInstance(1000).toCIEXYZ(rgb);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] sRGB = ColorSpace.getInstance(1000).fromCIEXYZ(colorvalue);
        return this.fromRGB(sRGB);
    }

    @Override
    public String getName(int idx) {
        switch (idx) {
            case 0: {
                return "Hue";
            }
            case 1: {
                return "Saturation";
            }
            case 2: {
                return "Lightness";
            }
        }
        throw new IllegalArgumentException("index must be between 0 and 2:" + idx);
    }

    @Override
    public float getMaxValue(int component) {
        return 1.0f;
    }

    @Override
    public float getMinValue(int component) {
        return 0.0f;
    }

    public boolean equals(Object o) {
        return o instanceof HSLPhysiologicColorSpace;
    }

    public int hashCode() {
        return this.getClass().getSimpleName().hashCode();
    }

    @Override
    public String getName() {
        return "physiologic HSL";
    }
}

