/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display.paint;

import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

final class USHORTPaintContext
implements PaintContext {
    private final ComponentColorModel ccm;
    private WritableRaster raster;
    private final short[] value;

    USHORTPaintContext(ComponentColorModel ccm, short[] value) {
        this.value = value;
        this.ccm = ccm;
    }

    @Override
    public final Raster getRaster(int x, int y, int w, int h) {
        if (null == this.raster || this.raster.getWidth() != w || this.raster.getHeight() != h) {
            this.raster = this.ccm.createCompatibleWritableRaster(w, h);
        }
        int lenY = y + h;
        int lenX = x + w;
        for (int j = y; j < lenY; ++j) {
            for (int i = x; i < lenX; ++i) {
                this.raster.setDataElements(i - x, j - y, this.value);
            }
        }
        return this.raster;
    }

    @Override
    public final ColorModel getColorModel() {
        return this.ccm;
    }

    @Override
    public final void dispose() {
        this.raster = null;
    }
}

