/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.thread.chunker;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.imagej.ops.Ops;
import net.imagej.ops.thread.chunker.AbstractChunker;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Thread.Chunker.class)
public class DefaultChunker
extends AbstractChunker {
    private final int STEP_SIZE = 1;
    @Parameter
    public LogService logService;

    public void run() {
        final long numSteps = Math.max(1L, this.numberOfElements / (long)this.ops().getMaxThreads());
        final int numChunks = (int)(this.numberOfElements / numSteps);
        ArrayList<Future> futures = new ArrayList<Future>(numChunks);
        for (int i = 0; i < numChunks - 1; ++i) {
            final long j = i;
            futures.add(this.threadService.run(new Runnable(){

                @Override
                public void run() {
                    DefaultChunker.this.chunkable.execute(j * numSteps, 1L, numSteps);
                }
            }));
        }
        futures.add(this.threadService.run(new Runnable(){

            @Override
            public void run() {
                DefaultChunker.this.chunkable.execute((long)(numChunks - 1) * numSteps, 1L, (int)(numSteps + DefaultChunker.this.numberOfElements % numSteps));
            }
        }));
        for (Future future : futures) {
            try {
                if (this.isCanceled()) break;
                future.get();
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
            catch (ExecutionException exc) {
                throw new RuntimeException(exc);
            }
        }
    }
}

