/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.compat;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.StringJoiner;
import org.scijava.launcher.Config;

class MemoryJaunch {
    public static final String FIJI_HEAP_KEY = "max-heap";
    public static final long FIJI_MIN_MB = 100L;

    MemoryJaunch() {
    }

    public static void run(String appDir) {
        long memory = MemoryJaunch.maxMemory() >> 20;
        int threads = Prefs.getThreads();
        File fijiCfg = new File(new StringJoiner(File.separator).add(appDir).add("config").add("jaunch").add("fiji.cfg").toString());
        if (fijiCfg.exists()) {
            try {
                Map config = Config.load((File)fijiCfg);
                if (config.containsKey(FIJI_HEAP_KEY)) {
                    String memSetting = (String)config.get(FIJI_HEAP_KEY);
                    char suffix = memSetting.toLowerCase().charAt(memSetting.length() - 1);
                    memSetting = memSetting.substring(0, memSetting.length() - 1);
                    long memConfig = Long.parseLong(memSetting);
                    switch (suffix) {
                        case 'g': {
                            memConfig *= 1024L;
                        }
                        case 'm': {
                            memory = memConfig;
                            break;
                        }
                        default: {
                            IJ.error((String)("Ignoring unrecognized memory setting: " + memSetting));
                        }
                    }
                }
            }
            catch (IOException e) {
                IJ.error((String)("Could not read existing config file: " + fijiCfg.getAbsolutePath()));
                return;
            }
        }
        long lastMemory = memory;
        GenericDialog gd = new GenericDialog("Memory " + (IJ.is64Bit() ? "(64-bit)" : "(32-bit)"));
        gd.addNumericField("Maximum Memory:", (double)memory, 0, 5, "MB");
        gd.addNumericField("Parallel Threads for Stacks:", (double)threads, 0, 5, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (gd.invalidNumber()) {
            IJ.showMessage((String)"Memory", (String)"The number entered was invalid.");
            return;
        }
        memory = (long)gd.getNextNumber();
        threads = (int)gd.getNextNumber();
        if (memory < 100L) {
            IJ.showMessage((String)"Memory", (String)"Invalid memory setting. Must be above 100MB.");
            return;
        }
        Prefs.setThreads((int)threads);
        try {
            Config.update((File)fijiCfg, (String)FIJI_HEAP_KEY, (String)(String.valueOf(memory) + "m"));
        }
        catch (IOException e) {
            IJ.error((String)("Could not write to existing config file: " + fijiCfg.getAbsolutePath()));
            return;
        }
        if (lastMemory != memory) {
            IJ.showMessage((String)"Memory", (String)("The new " + memory + "MB setting will take effect after restarting."));
        }
        int limit = 1700;
        if (!IJ.is64Bit() && memory > 1700L && !IJ.showMessageWithCancel((String)"Memory", (String)"Note: setting the memory limit to a value\ngreater than 1700MB on a 32-bit system\nmay cause ImageJ to fail to start.")) {
            return;
        }
    }

    private static long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }
}

