/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PointSoundRetained;
import org.jogamp.java3d.Sound;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Point3f;

public class PointSound
extends Sound {
    public static final int ALLOW_POSITION_READ = 32;
    public static final int ALLOW_POSITION_WRITE = 33;
    public static final int ALLOW_DISTANCE_GAIN_READ = 34;
    public static final int ALLOW_DISTANCE_GAIN_WRITE = 35;
    private static final int[] readCapabilities = new int[]{32, 34};

    public PointSound() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public PointSound(MediaContainer soundData, float initialGain, Point3f position) {
        super(soundData, initialGain);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(position);
    }

    public PointSound(MediaContainer soundData, float initialGain, float posX, float posY, float posZ) {
        super(soundData, initialGain);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(posX, posY, posZ);
    }

    public PointSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, Point3f position, Point2f[] distanceGain) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(position);
        ((PointSoundRetained)this.retained).setDistanceGain(distanceGain);
    }

    public PointSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, float posX, float posY, float posZ, Point2f[] distanceGain) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(posX, posY, posZ);
        ((PointSoundRetained)this.retained).setDistanceGain(distanceGain);
    }

    public PointSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, Point3f position, float[] attenuationDistance, float[] attenuationGain) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(position);
        ((PointSoundRetained)this.retained).setDistanceGain(attenuationDistance, attenuationGain);
    }

    public PointSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, float posX, float posY, float posZ, float[] attenuationDistance, float[] attenuationGain) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(posX, posY, posZ);
        ((PointSoundRetained)this.retained).setDistanceGain(attenuationDistance, attenuationGain);
    }

    @Override
    void createRetained() {
        this.retained = new PointSoundRetained();
        this.retained.setSource(this);
    }

    public void setPosition(Point3f position) {
        if (this.isLiveOrCompiled() && !this.getCapability(33)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound0"));
        }
        ((PointSoundRetained)this.retained).setPosition(position);
    }

    public void setPosition(float x, float y, float z) {
        if (this.isLiveOrCompiled() && !this.getCapability(33)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound0"));
        }
        ((PointSoundRetained)this.retained).setPosition(x, y, z);
    }

    public void getPosition(Point3f position) {
        if (this.isLiveOrCompiled() && !this.getCapability(32)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound2"));
        }
        ((PointSoundRetained)this.retained).getPosition(position);
    }

    public void setDistanceGain(Point2f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound3"));
        }
        ((PointSoundRetained)this.retained).setDistanceGain(attenuation);
    }

    public void setDistanceGain(float[] distance, float[] gain) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound3"));
        }
        ((PointSoundRetained)this.retained).setDistanceGain(distance, gain);
    }

    public int getDistanceGainLength() {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound4"));
        }
        return ((PointSoundRetained)this.retained).getDistanceGainLength();
    }

    public void getDistanceGain(Point2f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound4"));
        }
        ((PointSoundRetained)this.retained).getDistanceGain(attenuation);
    }

    public void getDistanceGain(float[] distance, float[] gain) {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound4"));
        }
        ((PointSoundRetained)this.retained).getDistanceGain(distance, gain);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        PointSound p = new PointSound();
        p.duplicateNode(this, forceDuplicate);
        return p;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.checkDuplicateNode(originalNode, forceDuplicate);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        PointSoundRetained orgRetained = (PointSoundRetained)originalNode.retained;
        PointSoundRetained thisRetained = (PointSoundRetained)this.retained;
        Point3f p = new Point3f();
        orgRetained.getPosition(p);
        thisRetained.setPosition(p);
        int len = orgRetained.getDistanceGainLength();
        float[] distance = new float[len];
        float[] gain = new float[len];
        orgRetained.getDistanceGain(distance, gain);
        thisRetained.setDistanceGain(distance, gain);
    }
}

