/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import sc.fiji.i5d.Image5D;

public class Image5D_to_Stack
implements PlugIn {
    public void run(String arg) {
        ImagePlus currentImage = WindowManager.getCurrentImage();
        if (currentImage == null) {
            IJ.noImage();
            return;
        }
        if (!(currentImage instanceof Image5D)) {
            IJ.error((String)"Image is not an Image5D.");
            return;
        }
        ImageStack currentImageStack = currentImage.getImageStack();
        ImagePlus newImage = new ImagePlus(currentImage.getTitle(), currentImageStack.getProcessor(1));
        ImageStack newStack = newImage.getStack();
        newStack.setSliceLabel(currentImageStack.getSliceLabel(1), 1);
        for (int i = 2; i <= currentImage.getImageStackSize(); ++i) {
            newStack.addSlice(currentImageStack.getSliceLabel(i), currentImageStack.getPixels(i));
        }
        newImage.setStack(null, newStack);
        newImage.setDimensions(currentImage.getNChannels(), currentImage.getNSlices(), currentImage.getNFrames());
        newImage.setCalibration(currentImage.getCalibration().copy());
        newImage.getProcessor().resetMinAndMax();
        newImage.show();
        currentImage.getWindow().close();
        if (newImage.getWindow() != null) {
            WindowManager.setCurrentWindow((ImageWindow)newImage.getWindow());
        }
    }
}

