/*
 * Decompiled with CFR 0.152.
 */
package video2;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Insert_Stack
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 16;
    }

    public void run(ImageProcessor ip) {
        int current = this.image.getCurrentSlice();
        String[] images = this.openImages();
        if (images.length == 0) {
            IJ.error((String)"No other images open");
            return;
        }
        GenericDialog gd = new GenericDialog("Insert stack");
        gd.addChoice("Stack", images, images[0]);
        gd.addNumericField("Slice number", (double)current, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int slice = (int)gd.getNextNumber();
        ImagePlus src = WindowManager.getImage((String)gd.getNextChoice());
        Insert_Stack.insertStack(this.image, slice, src);
    }

    private String[] openImages() {
        int[] ids = WindowManager.getIDList();
        String[] titles = new String[ids.length - 1];
        int c = 0;
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            ImagePlus im = WindowManager.getImage((int)id);
            if (im == this.image) continue;
            titles[c++] = im.getTitle();
        }
        return titles;
    }

    public static void insertStack(ImagePlus tgt, int slice, ImagePlus src) {
        int w = tgt.getWidth();
        int h = tgt.getHeight();
        ImageStack source = src.getStack();
        ImageStack target = tgt.getStack();
        if (source.getWidth() != w || source.getHeight() != h) {
            throw new IllegalArgumentException("Stack to insert has wrong dimensions");
        }
        int d = src.getStackSize();
        for (int n = 0; n < d; ++n) {
            ImageProcessor frame = source.getProcessor(n + 1);
            target.addSlice("", frame, slice + n);
        }
        tgt.setStack(null, target);
    }
}

