/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.imaris;

import io.scif.formats.imaris.ResolutionLevel;
import java.util.LinkedList;

public class ResolutionLevelMaker {
    private static final int BYTES_PER_MB = 0x100000;

    public static ResolutionLevel[] calcLevels(int imageSizeX, int imageSizeY, int imageSizeZ, int numTimePoints, int byteDepth) {
        LinkedList<ResolutionLevel> resLevels = new LinkedList<ResolutionLevel>();
        ResolutionLevelMaker.addResLevels(resLevels, imageSizeX, imageSizeY, imageSizeZ, imageSizeX, imageSizeY, imageSizeZ, numTimePoints, byteDepth);
        ResolutionLevel[] array = new ResolutionLevel[resLevels.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = resLevels.get(i);
        }
        return array;
    }

    private static void addResLevels(LinkedList<ResolutionLevel> resLevels, int baseSizeX, int baseSizeY, int baseSizeZ, int imageSizeX, int imageSizeY, int imageSizeZ, int numTimePoints, int byteDepth) {
        resLevels.add(new ResolutionLevel(resLevels.size(), baseSizeX, baseSizeY, baseSizeZ, imageSizeX, imageSizeY, imageSizeZ, numTimePoints, byteDepth));
        if (resLevels.getLast().getImageNumBytes() > 0x400000) {
            boolean reduceX;
            int newX = imageSizeX;
            int newY = imageSizeY;
            int newZ = imageSizeZ;
            boolean reduceZ = 10 * imageSizeZ * (10 * imageSizeZ) > imageSizeX * imageSizeY;
            boolean reduceY = 10 * imageSizeY * (10 * imageSizeY) > imageSizeX * imageSizeZ;
            boolean bl = reduceX = 10 * imageSizeX * (10 * imageSizeX) > imageSizeY * imageSizeZ;
            if (reduceZ) {
                newZ = (int)Math.ceil((double)imageSizeZ / 2.0);
            }
            if (reduceX) {
                newX = (int)Math.ceil((double)imageSizeX / 2.0);
            }
            if (reduceY) {
                newY = (int)Math.ceil((double)imageSizeY / 2.0);
            }
            ResolutionLevelMaker.addResLevels(resLevels, baseSizeX, baseSizeY, baseSizeZ, newX, newY, newZ, numTimePoints, byteDepth);
        }
    }
}

