/*
 * Decompiled with CFR 0.152.
 */
package com.petebevin.markdown.test;

import com.petebevin.markdown.MarkdownProcessor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MarkdownTestTester
extends TestCase {
    String test;
    String dir;

    public MarkdownTestTester(String dir, String test) {
        super(test);
        this.test = test;
        this.dir = dir;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("MarkdownTest");
        suite.addTest(MarkdownTestTester.newSuite("tests/MarkdownTest"));
        return suite;
    }

    public static Test newSuite(String dirName) {
        TestSuite suite = new TestSuite("MarkdownProcessor file " + dirName);
        File dir = new File(dirName);
        File[] dirEntries = dir.listFiles();
        int i = 0;
        while (i < dirEntries.length) {
            File dirEntry = dirEntries[i];
            String fileName = dirEntry.getName();
            if (fileName.endsWith(".text")) {
                String testName = fileName.substring(0, fileName.lastIndexOf(46));
                suite.addTest((Test)new MarkdownTestTester(dirName, testName));
            }
            ++i;
        }
        return suite;
    }

    public void runTest() throws IOException {
        String testText = this.slurp(new File(this.dir, String.valueOf(this.test) + ".text"));
        String htmlText = this.slurp(new File(this.dir, String.valueOf(this.test) + ".html"));
        MarkdownProcessor markup = new MarkdownProcessor();
        String markdownText = markup.markdown(testText);
        MarkdownTestTester.assertEquals((String)this.test, (String)htmlText.trim(), (String)markdownText.trim());
    }

    private String slurp(File file) throws IOException {
        int ch;
        FileReader in = new FileReader(file);
        StringBuffer sb = new StringBuffer();
        while ((ch = in.read()) != -1) {
            sb.append((char)ch);
        }
        return sb.toString();
    }
}

