/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.matcher;

public class Quaternion {
    float w;
    float x;
    float y;
    float z;

    public Quaternion(float w, float x, float y, float z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Quaternion(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float qWV;
        float qWW;
        float qWU;
        float qVW;
        float qVV;
        float qVU;
        float qUW;
        float qUU;
        float qUV;
        float max = Math.max(Math.max(m00, m11), m22);
        if (max == m00) {
            qUV = m01;
            qUU = m00;
            qUW = m02;
            qVU = m10;
            qVV = m11;
            qVW = m12;
            qWU = m20;
            qWW = m22;
            qWV = m21;
        } else if (max == m11) {
            qUV = m12;
            qUU = m11;
            qUW = m10;
            qVU = m21;
            qVV = m22;
            qVW = m20;
            qWU = m01;
            qWV = m02;
            qWW = m00;
        } else {
            qUU = m22;
            qUV = m20;
            qUW = m21;
            qVU = m02;
            qVV = m00;
            qVW = m01;
            qWU = m12;
            qWV = m10;
            qWW = m11;
        }
        float r = (float)Math.sqrt(1.0f + qUU - qVV - qWW);
        this.w = (qWV - qVW) / (2.0f * r);
        this.x = r / 2.0f;
        this.y = (qUV + qVU) / (2.0f * r);
        this.z = (qWU + qUW) / (2.0f * r);
    }

    public float getW() {
        return this.w;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public String toString() {
        return this.w + " + " + this.x + "i + " + this.y + "j + " + this.z + "k";
    }
}

