/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import fiji.util.gui.GenericDialogPlus;
import ij.gui.GenericDialog;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import spim.fiji.datasetmanager.MultiViewDatasetDefinition;
import spim.fiji.datasetmanager.SlideBook6MetaData;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.ViewSetupUtils;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.imgloaders.SlideBook6ImgLoader;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class SlideBook6
implements MultiViewDatasetDefinition {
    public static String[] rotAxes = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    public static String defaultFilePath = "";
    public static boolean defaultModifyCal = false;
    public static int defaultCapture = -1;
    public static double[] defaultAngles = new double[]{0.0, 90.0};
    public static float[] defaultCalibrations = new float[]{1.0f, 1.0f, 1.0f};

    @Override
    public String getTitle() {
        return "Slidebook6 Dataset";
    }

    @Override
    public String getExtendedDescription() {
        return "This datset definition supports files saved by SlideBook6";
    }

    @Override
    public SpimData2 createDataset() {
        File sldFile = this.querySLDFile();
        if (sldFile == null) {
            return null;
        }
        SlideBook6MetaData meta = new SlideBook6MetaData();
        if (!meta.loadMetaData(sldFile)) {
            IOFunctions.println("Failed to analyze file.");
            return null;
        }
        if (!this.showDialogs(meta)) {
            return null;
        }
        String directory = sldFile.getParent();
        ImgFactory<? extends NativeType<?>> imgFactory = this.selectImgFactory(meta);
        TimePoints timepoints = this.createTimePoints(meta);
        ArrayList<ViewSetup> setups = this.createViewSetups(meta);
        MissingViews missingViews = null;
        SequenceDescription sequenceDescription = new SequenceDescription(timepoints, setups, null, missingViews);
        SlideBook6ImgLoader imgLoader = new SlideBook6ImgLoader(sldFile, imgFactory, (AbstractSequenceDescription<?, ?, ?>)sequenceDescription);
        sequenceDescription.setImgLoader((BasicImgLoader)imgLoader);
        float zSpacing = defaultCalibrations[2];
        double minResolution = Math.min(defaultCalibrations[0], zSpacing);
        IOFunctions.println("Minimal resolution in all dimensions is: " + minResolution);
        IOFunctions.println("(The smallest resolution in any dimension; the distance between two pixels in the output image will be that wide)");
        ViewRegistrations viewRegistrations = StackList.createViewRegistrations(sequenceDescription.getViewDescriptions(), minResolution);
        ViewInterestPoints viewInterestPoints = new ViewInterestPoints();
        viewInterestPoints.createViewInterestPoints(sequenceDescription.getViewDescriptions());
        SpimData2 spimData = new SpimData2(new File(directory), sequenceDescription, viewRegistrations, viewInterestPoints, new BoundingBoxes());
        SlideBook6.applyAxis(spimData, minResolution);
        return spimData;
    }

    public static void applyAxis(SpimData data, double minResolution) {
        ViewRegistrations viewRegistrations = data.getViewRegistrations();
        for (ViewDescription vd : ((SequenceDescription)data.getSequenceDescription()).getViewDescriptions().values()) {
            String d;
            Angle a;
            if (!vd.isPresent() || !(a = ((ViewSetup)vd.getViewSetup()).getAngle()).hasRotation()) continue;
            ViewRegistration vr = viewRegistrations.getViewRegistration((ViewId)vd);
            Dimensions dim = ((ViewSetup)vd.getViewSetup()).getSize();
            VoxelDimensions voxelSize = ViewSetupUtils.getVoxelSizeOrLoad(vd.getViewSetup(), vd.getTimePoint(), (ImgLoader)((SequenceDescription)data.getSequenceDescription()).getImgLoader());
            double calX = voxelSize.dimension(0) / minResolution;
            double calY = voxelSize.dimension(1) / minResolution;
            double calZ = voxelSize.dimension(2) / minResolution;
            AffineTransform3D calModel = new AffineTransform3D();
            calModel.set(1.0, 0.0, 0.0, (double)(-dim.dimension(0) / 2L) * calX, 0.0, 1.0, 0.0, (double)(-dim.dimension(1) / 2L) * calY, 0.0, 0.0, 1.0, (double)(-dim.dimension(2) / 2L) * calZ);
            ViewTransformAffine vt = new ViewTransformAffine("Center view", calModel);
            vr.preconcatenateTransform((ViewTransform)vt);
            double[] tmp = new double[16];
            double[] axis = a.getRotationAxis();
            double degrees = a.getRotationAngleDegrees();
            AffineTransform3D rotModel = new AffineTransform3D();
            if (axis[0] == 1.0 && axis[1] == 0.0 && axis[2] == 0.0) {
                rotModel.rotate(0, Math.toRadians(degrees));
                d = "Rotation around x-axis by " + degrees + " degrees";
            } else if (axis[0] == 0.0 && axis[1] == 1.0 && axis[2] == 0.0) {
                rotModel.rotate(1, Math.toRadians(degrees));
                d = "Rotation around y-axis by " + degrees + " degrees";
            } else if (axis[0] == 0.0 && axis[0] == 0.0 && axis[2] == 1.0) {
                rotModel.rotate(2, Math.toRadians(degrees));
                d = "Rotation around z-axis by " + degrees + " degrees";
            } else {
                IOFunctions.println("Arbitrary rotation axis not supported yet.");
                continue;
            }
            vt = new ViewTransformAffine(d, rotModel);
            vr.preconcatenateTransform((ViewTransform)vt);
            vr.updateModel();
        }
    }

    protected ArrayList<ViewSetup> createViewSetups(SlideBook6MetaData meta) {
        double[] yaxis = new double[]{0.0, 1.0, 0.0};
        ArrayList<Angle> angles = new ArrayList<Angle>();
        Angle angleA = new Angle(0, "Path_A");
        angleA.setRotation(yaxis, defaultAngles[0]);
        angles.add(angleA);
        Angle angleB = new Angle(1, "Path_B");
        angleB.setRotation(yaxis, defaultAngles[1]);
        angles.add(angleB);
        ArrayList<ViewSetup> viewSetups = new ArrayList<ViewSetup>();
        int firstCapture = defaultCapture;
        int numCaptures = 1;
        if (defaultCapture == -1) {
            firstCapture = 0;
            numCaptures = meta.numCaptures();
        }
        for (int capture = firstCapture; capture < firstCapture + numCaptures; ++capture) {
            int channels = meta.numChannels(capture);
            if (channels <= 1 || channels % 2 != 0) continue;
            String imageName = meta.imageName(capture);
            imageName = imageName.replaceAll("[^a-zA-Z0-9_-]", "_");
            imageName = imageName.toLowerCase();
            Illumination i = new Illumination(capture * 8, imageName);
            for (int ch = 0; ch < channels / 2; ++ch) {
                String channelName = meta.channels(capture)[ch * 2];
                channelName = channelName.replaceAll("[^a-zA-Z0-9_-]", "_");
                channelName = channelName.toLowerCase();
                Channel channel = new Channel(ch, channelName);
                for (Angle a : angles) {
                    float voxelSizeUm = defaultCalibrations[0];
                    float zSpacing = defaultCalibrations[2];
                    FinalVoxelDimensions voxelSize = new FinalVoxelDimensions("um", new double[]{voxelSizeUm, voxelSizeUm, zSpacing});
                    FinalDimensions dim = new FinalDimensions(new long[]{meta.imageSize(capture)[0], meta.imageSize(capture)[1], meta.imageSize(capture)[2]});
                    viewSetups.add(new ViewSetup(viewSetups.size(), a.getName(), (Dimensions)dim, (VoxelDimensions)voxelSize, channel, a, i));
                }
            }
        }
        return viewSetups;
    }

    protected TimePoints createTimePoints(SlideBook6MetaData meta) {
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>();
        int firstCapture = defaultCapture;
        int numCaptures = 1;
        if (defaultCapture == -1) {
            firstCapture = 0;
            numCaptures = meta.numCaptures();
        }
        for (int t = 0; t < meta.numTimepoints(firstCapture); ++t) {
            timepoints.add(new TimePoint(t));
        }
        return new TimePoints(timepoints);
    }

    protected ImgFactory<? extends NativeType<?>> selectImgFactory(SlideBook6MetaData meta) {
        int[] dims = meta.imageSize(0);
        long maxNumPixels = dims[0];
        maxNumPixels *= (long)dims[1];
        String s = "Maximum number of pixels in any view: n=" + Long.toString(maxNumPixels *= (long)dims[2]) + " px ";
        if (maxNumPixels < Integer.MAX_VALUE) {
            IOFunctions.println(s + "< " + Integer.MAX_VALUE + ", using ArrayImg.");
            return new ArrayImgFactory();
        }
        IOFunctions.println(s + ">= " + Integer.MAX_VALUE + ", using CellImg.");
        return new CellImgFactory(new int[]{256});
    }

    protected boolean showDialogs(SlideBook6MetaData meta) {
        int ch;
        int numChannels;
        GenericDialog gd = new GenericDialog("Select SlideBook6 diSPIM Capture");
        String[] imageNames = new String[meta.numCaptures() + 1];
        imageNames[0] = new String("< All Captures >");
        for (int c = 0; c < meta.numCaptures(); ++c) {
            imageNames[c + 1] = meta.imageName(c);
        }
        gd.addChoice("Capture Name", imageNames, imageNames[0]);
        GUIHelper.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int firstCapture = defaultCapture = gd.getNextChoiceIndex() - 1;
        if (defaultCapture == -1) {
            firstCapture = 0;
        }
        if ((numChannels = meta.numChannels(firstCapture)) < 2 || numChannels % 2 != 0) {
            IOFunctions.println("ERROR: " + numChannels + " angles detected.  No alignment possible.");
            return false;
        }
        GenericDialog gd2 = new GenericDialog("SlideBook6 diSPIM Properties");
        gd2.addMessage("Angles (" + numChannels + " present)", new Font("SansSerif", 1, 13));
        gd2.addMessage("");
        for (ch = 0; ch < numChannels; ++ch) {
            gd2.addNumericField("Angle of '" + meta.channels(firstCapture)[ch] + "':", (double)(ch % 2 * 90), 1, 5, "degrees");
        }
        gd2.addMessage("Channels (" + meta.numChannels(firstCapture) / 2 + " present)", new Font("SansSerif", 1, 13));
        gd2.addMessage("");
        for (ch = 0; ch < meta.numChannels(firstCapture) / 2; ++ch) {
            gd2.addMessage("Channel_" + (ch + 1) + ": " + meta.channels(firstCapture)[ch * 2]);
        }
        gd2.addMessage("Timepoints (" + meta.numTimepoints(firstCapture) + " present)", new Font("SansSerif", 1, 13));
        SlideBook6.defaultCalibrations[0] = (float)meta.calX(firstCapture);
        SlideBook6.defaultCalibrations[1] = (float)meta.calY(firstCapture);
        SlideBook6.defaultCalibrations[2] = (float)meta.calZ(firstCapture);
        gd2.addMessage("Calibration", new Font("SansSerif", 1, 13));
        gd2.addCheckbox("Modify_calibration", defaultModifyCal);
        gd2.addMessage("Pixel Distance X: " + defaultCalibrations[0] + " um\nPixel Distance Y: " + defaultCalibrations[1] + " um\nPixel Distance Z: " + defaultCalibrations[2] + " um\n");
        gd2.addMessage("Rotation axis: Y axis\nPixel type: UInt16", new Font("SansSerif", 2, 11));
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return false;
        }
        for (int a = 0; a < meta.numChannels(firstCapture); ++a) {
            SlideBook6.defaultAngles[a % 2] = gd2.getNextNumber();
        }
        defaultModifyCal = gd2.getNextBoolean();
        if (defaultModifyCal) {
            gd2 = new GenericDialog("Modify Meta Data");
            gd2.addNumericField("Pixel_distance_x", (double)defaultCalibrations[0], 5, 5, "um");
            gd2.addNumericField("Pixel_distance_y", (double)defaultCalibrations[1], 5, 5, "um");
            gd2.addNumericField("Pixel_distance_z", (double)defaultCalibrations[2], 5, 5, "um");
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return false;
            }
            SlideBook6.defaultCalibrations[0] = (float)gd2.getNextNumber();
            SlideBook6.defaultCalibrations[1] = (float)gd2.getNextNumber();
            SlideBook6.defaultCalibrations[2] = (float)gd2.getNextNumber();
        }
        return true;
    }

    protected File querySLDFile() {
        GenericDialogPlus gd = new GenericDialogPlus("Define SlideBook6 diSPIM Dataset");
        gd.addFileField("SlideBook6 SLD file", defaultFilePath, 50);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        defaultFilePath = gd.getNextString();
        File firstFile = new File(defaultFilePath);
        if (!firstFile.exists()) {
            IOFunctions.println("File '" + firstFile.getAbsolutePath() + "' does not exist. Stopping");
            return null;
        }
        IOFunctions.println("Investigating file '" + firstFile.getAbsolutePath() + "'.");
        return firstFile;
    }

    @Override
    public SlideBook6 newInstance() {
        return new SlideBook6();
    }

    public static void main(String[] args) {
        new SlideBook6().createDataset();
    }
}

