/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.interestpointdetection;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.wrapper.ImgLib2;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.segmentation.InteractiveDoG;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.realtransform.AffineTransform3D;
import spim.fiji.plugin.interestpointdetection.DifferenceOf;
import spim.fiji.plugin.util.GenericDialogAppender;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.cuda.CUDADevice;
import spim.process.cuda.CUDASeparableConvolution;
import spim.process.cuda.CUDATools;
import spim.process.cuda.NativeLibraryTools;
import spim.process.interestpointdetection.ProcessDOG;

public class DifferenceOfGaussian
extends DifferenceOf
implements GenericDialogAppender {
    public static double defaultUseGPUMem = 75.0;
    public static double defaultS = 1.8;
    public static double defaultT = 0.008;
    public static double[] defaultSigma;
    public static double[] defaultThreshold;
    public static boolean[] defaultFindMin;
    public static boolean[] defaultFindMax;
    public static String[] computationOnChoice;
    public static int defaultComputationChoiceIndex;
    double[] sigma;
    double[] threshold;
    boolean[] findMin;
    boolean[] findMax;
    double percentGPUMem = defaultUseGPUMem;
    ArrayList<CUDADevice> deviceList = null;
    CUDASeparableConvolution cuda = null;
    boolean accurateCUDA = false;

    public DifferenceOfGaussian(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
    }

    @Override
    public String getDescription() {
        return "Difference-of-Gaussian";
    }

    @Override
    public DifferenceOfGaussian newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new DifferenceOfGaussian(spimData, viewIdsToProcess);
    }

    @Override
    public HashMap<ViewId, List<InterestPoint>> findInterestPoints(TimePoint t) {
        HashMap<ViewId, List<InterestPoint>> interestPoints = new HashMap<ViewId, List<InterestPoint>>();
        for (ViewDescription vd : SpimData2.getAllViewIdsForTimePointSorted(this.spimData, this.viewIdsToProcess, t)) {
            try {
                long time1 = System.currentTimeMillis();
                if (!vd.isPresent()) continue;
                Channel c = ((ViewSetup)vd.getViewSetup()).getChannel();
                AffineTransform3D correctCoordinates = new AffineTransform3D();
                RandomAccessibleInterval<net.imglib2.type.numeric.real.FloatType> input = this.openAndDownsample(this.spimData, vd, correctCoordinates);
                long time2 = System.currentTimeMillis();
                this.benchmark.openFiles += time2 - time1;
                this.preSmooth(input);
                Image img = ImgLib2.wrapFloatToImgLib1((Img)((Img)input));
                List<InterestPoint> ips = ProcessDOG.compute(this.cuda, this.deviceList, this.accurateCUDA, this.percentGPUMem, (Image<FloatType>)img, (Img<net.imglib2.type.numeric.real.FloatType>)((Img)input), (float)this.sigma[c.getId()], (float)this.threshold[c.getId()], this.localization, Math.min(this.imageSigmaX, (double)((float)this.sigma[c.getId()])), Math.min(this.imageSigmaY, (double)((float)this.sigma[c.getId()])), Math.min(this.imageSigmaZ, (double)((float)this.sigma[c.getId()])), this.findMin[c.getId()], this.findMax[c.getId()], this.minIntensity, this.maxIntensity, this.limitDetections);
                img.close();
                this.correctForDownsampling(ips, correctCoordinates);
                if (this.limitDetections) {
                    ips = DifferenceOfGaussian.limitList(this.maxDetections, this.maxDetectionsTypeIndex, ips);
                }
                interestPoints.put((ViewId)vd, ips);
                this.benchmark.computation += System.currentTimeMillis() - time2;
            }
            catch (Exception e) {
                IOFunctions.println("An error occured (DOG): " + e);
                IOFunctions.println("Failed to segment angleId: " + ((ViewSetup)vd.getViewSetup()).getAngle().getId() + " channelId: " + ((ViewSetup)vd.getViewSetup()).getChannel().getId() + " illumId: " + ((ViewSetup)vd.getViewSetup()).getIllumination().getId() + ". Continuing with next one.");
                e.printStackTrace();
            }
        }
        return interestPoints;
    }

    @Override
    protected boolean setDefaultValues(Channel channel, int brightness) {
        int channelId = channel.getId();
        this.sigma[channelId] = defaultS;
        this.findMin[channelId] = false;
        this.findMax[channelId] = true;
        if (brightness == 0) {
            this.threshold[channelId] = 0.001;
        } else if (brightness == 1) {
            this.threshold[channelId] = 0.008;
        } else if (brightness == 2) {
            this.threshold[channelId] = 0.03;
        } else if (brightness == 3) {
            this.threshold[channelId] = 0.1;
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean setAdvancedValues(Channel channel) {
        int channelId = channel.getId();
        GenericDialog gd = new GenericDialog("Advanced values for channel " + channel.getName());
        String ch = this.channelsToProcess.size() > 1 ? "_" + channel.getName().replace(' ', '_') : "";
        gd.addMessage("Advanced values for channel " + channel.getName());
        gd.addNumericField("Sigma" + ch, defaultSigma[channelId], 5);
        gd.addNumericField("Threshold" + ch, defaultThreshold[channelId], 4);
        gd.addCheckbox("Find_minima" + ch, defaultFindMin[channelId]);
        gd.addCheckbox("Find_maxima" + ch, defaultFindMax[channelId]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.sigma[channelId] = DifferenceOfGaussian.defaultSigma[channelId] = gd.getNextNumber();
        this.threshold[channelId] = DifferenceOfGaussian.defaultThreshold[channelId] = gd.getNextNumber();
        this.findMin[channelId] = DifferenceOfGaussian.defaultFindMin[channelId] = gd.getNextBoolean();
        this.findMax[channelId] = DifferenceOfGaussian.defaultFindMax[channelId] = gd.getNextBoolean();
        return true;
    }

    @Override
    protected boolean setInteractiveValues(Channel channel) {
        ViewId view = this.getViewSelection("Interactive Difference-of-Gaussian", "Please select view to use for channel " + channel.getName(), channel);
        if (view == null) {
            return false;
        }
        ViewDescription viewDescription = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(view.getTimePointId(), view.getViewSetupId());
        if (!viewDescription.isPresent()) {
            IOFunctions.println("You defined the view you selected as not present at this timepoint.");
            IOFunctions.println("timepoint: " + viewDescription.getTimePoint().getName() + " angle: " + ((ViewSetup)viewDescription.getViewSetup()).getAngle().getName() + " channel: " + ((ViewSetup)viewDescription.getViewSetup()).getChannel().getName() + " illum: " + ((ViewSetup)viewDescription.getViewSetup()).getIllumination().getName());
            return false;
        }
        RandomAccessibleInterval<net.imglib2.type.numeric.real.FloatType> img = this.openAndDownsample(this.spimData, viewDescription, new AffineTransform3D());
        if (img == null) {
            IOFunctions.println("View not found: " + viewDescription);
            return false;
        }
        this.preSmooth(img);
        ImagePlus imp = ImageJFunctions.wrapFloat(img, (String)"").duplicate();
        img = null;
        imp.setDimensions(1, imp.getStackSize(), 1);
        imp.setTitle("tp: " + viewDescription.getTimePoint().getName() + " viewSetup: " + viewDescription.getViewSetupId());
        imp.show();
        imp.setSlice(imp.getStackSize() / 2);
        imp.resetDisplayRange();
        imp.setRoi(0, 0, imp.getWidth() / 3, imp.getHeight() / 3);
        InteractiveDoG idog = new InteractiveDoG(imp);
        int channelId = channel.getId();
        idog.setSigma2isAdjustable(false);
        idog.setInitialSigma((float)defaultSigma[channelId]);
        idog.setThreshold((float)defaultThreshold[channelId]);
        idog.setLookForMinima(defaultFindMin[channelId]);
        idog.setLookForMaxima(defaultFindMax[channelId]);
        idog.setMinIntensityImage(this.minIntensity);
        idog.setMaxIntensityImage(this.maxIntensity);
        idog.run(null);
        while (!idog.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        imp.close();
        if (idog.wasCanceled()) {
            return false;
        }
        this.sigma[channelId] = DifferenceOfGaussian.defaultSigma[channelId] = idog.getInitialSigma();
        this.threshold[channelId] = DifferenceOfGaussian.defaultThreshold[channelId] = idog.getThreshold();
        this.findMin[channelId] = DifferenceOfGaussian.defaultFindMin[channelId] = idog.getLookForMinima();
        this.findMax[channelId] = DifferenceOfGaussian.defaultFindMax[channelId] = idog.getLookForMaxima();
        return true;
    }

    @Override
    protected void init(int numChannels) {
        this.sigma = new double[numChannels];
        this.threshold = new double[numChannels];
        this.findMin = new boolean[numChannels];
        this.findMax = new boolean[numChannels];
        if (defaultSigma == null || defaultSigma.length != numChannels) {
            defaultSigma = new double[numChannels];
            defaultThreshold = new double[numChannels];
            defaultFindMin = new boolean[numChannels];
            defaultFindMax = new boolean[numChannels];
            for (int c = 0; c < numChannels; ++c) {
                DifferenceOfGaussian.defaultSigma[c] = defaultS;
                DifferenceOfGaussian.defaultThreshold[c] = defaultT;
                DifferenceOfGaussian.defaultFindMin[c] = false;
                DifferenceOfGaussian.defaultFindMax[c] = true;
            }
        }
    }

    @Override
    public String getParameters(int channelId) {
        return "DOG s=" + this.sigma[channelId] + " t=" + this.threshold[channelId] + " min=" + this.findMin[channelId] + " max=" + this.findMax[channelId] + " imageSigmaX=" + this.imageSigmaX + " imageSigmaY=" + this.imageSigmaY + " imageSigmaZ=" + this.imageSigmaZ + " downsampleXY=" + this.downsampleXY + " downsampleZ=" + this.downsampleZ + " additionalSigmaX=" + this.additionalSigmaX + " additionalSigmaY=" + this.additionalSigmaY + " additionalSigmaZ=" + this.additionalSigmaZ + " minIntensity=" + this.minIntensity + " maxIntensity=" + this.maxIntensity;
    }

    @Override
    protected void addAddtionalParameters(GenericDialog gd) {
        gd.addChoice("Compute_on", computationOnChoice, computationOnChoice[defaultComputationChoiceIndex]);
    }

    @Override
    protected boolean queryAdditionalParameters(GenericDialog gd) {
        defaultComputationChoiceIndex = gd.getNextChoiceIndex();
        int computationTypeIndex = defaultComputationChoiceIndex;
        this.accurateCUDA = computationTypeIndex != 1;
        if (computationTypeIndex >= 1) {
            ArrayList<String> potentialNames = new ArrayList<String>();
            potentialNames.add("separable");
            this.cuda = NativeLibraryTools.loadNativeLibrary(potentialNames, CUDASeparableConvolution.class);
            if (this.cuda == null) {
                IOFunctions.println("Cannot load CUDA JNA library.");
                this.deviceList = null;
                return false;
            }
            this.deviceList = new ArrayList();
            ArrayList<CUDADevice> selectedDevices = CUDATools.queryCUDADetails(this.cuda, false, this);
            if (selectedDevices == null || selectedDevices.size() == 0) {
                return false;
            }
            this.deviceList.addAll(selectedDevices);
            if (this.deviceList.get(0).getDeviceName().startsWith("CPU emulation")) {
                for (int i = 0; i < this.deviceList.size(); ++i) {
                    this.deviceList.set(i, new CUDADevice(-1 - i, this.deviceList.get(i).getDeviceName(), this.deviceList.get(i).getTotalDeviceMemory(), this.deviceList.get(i).getFreeDeviceMemory(), this.deviceList.get(i).getMajorComputeVersion(), this.deviceList.get(i).getMinorComputeVersion()));
                    IOFunctions.println("Running on cpu emulation, added " + (-1 - i) + " as device");
                }
            }
        } else {
            this.deviceList = null;
        }
        return true;
    }

    @Override
    public void addQuery(GenericDialog gd) {
        gd.addMessage("");
        gd.addSlider("Percent_of_GPU_Memory_to_use", 1.0, 100.0, defaultUseGPUMem);
    }

    @Override
    public boolean parseDialog(GenericDialog gd) {
        this.percentGPUMem = defaultUseGPUMem = gd.getNextNumber();
        return true;
    }

    static {
        computationOnChoice = new String[]{"CPU (Java)", "GPU approximate (Nvidia CUDA via JNA)", "GPU accurate (Nvidia CUDA via JNA)"};
        defaultComputationChoiceIndex = 0;
    }
}

