/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import bdv.AbstractSpimSource;
import bdv.tools.transformation.TransformedSource;
import bdv.viewer.state.SourceState;
import bdv.viewer.state.ViewerState;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.realtransform.AffineTransform3D;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;

public class BakeManualTransformationPopup
extends JMenuItem
implements ViewExplorerSetable {
    private static final long serialVersionUID = 4627408819269954486L;
    ViewSetupExplorerPanel<?, ?> panel;

    public BakeManualTransformationPopup() {
        super("Bake BDV manual transform");
        this.addActionListener(this::actionPerformed);
    }

    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<?, ?> panel) {
        this.panel = panel;
        return this;
    }

    private void actionPerformed(ActionEvent e) {
        if (this.panel == null) {
            IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
            return;
        }
        List<ViewId> viewIds = this.panel.selectedRowsViewId();
        ViewRegistrations vr = this.panel.getSpimData().getViewRegistrations();
        ViewerState state = ViewSetupExplorerPanel.bdvPopup().bdv.getViewer().getState();
        for (SourceState s : state.getSources()) {
            if (!(s.getSpimSource() instanceof TransformedSource)) continue;
            TransformedSource transformedSource = (TransformedSource)s.getSpimSource();
            if (transformedSource.getWrappedSource() instanceof AbstractSpimSource) {
                int setupId = ((AbstractSpimSource)transformedSource.getWrappedSource()).getSetupId();
                AffineTransform3D manual = new AffineTransform3D();
                transformedSource.getFixedTransform(manual);
                for (ViewId viewId : viewIds) {
                    if (viewId.getViewSetupId() != setupId) continue;
                    ViewRegistration v = (ViewRegistration)vr.getViewRegistrations().get(viewId);
                    ViewTransformAffine vt = new ViewTransformAffine("baked bdv manual transform", manual);
                    v.preconcatenateTransform((ViewTransform)vt);
                }
            }
            transformedSource.setFixedTransform(new AffineTransform3D());
        }
        this.panel.updateContent();
        ViewSetupExplorerPanel.bdvPopup().updateBDV();
    }
}

