/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weights;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;

public class NormalizingRandomAccess<T extends RealType<T>>
extends AbstractLocalizableInt
implements RandomAccess<T> {
    final RandomAccessibleInterval<T> interval;
    final RandomAccessibleInterval<T> normalizeInterval;
    final RandomAccess<T> intervalRandomAccess;
    final RandomAccess<T> normalizeIntervalRandomAccess;
    final T type;
    final double osemspeedup;

    public NormalizingRandomAccess(RandomAccessibleInterval<T> interval, RandomAccessibleInterval<T> normalizeInterval, double osemspeedup, T type) {
        super(interval.numDimensions());
        this.interval = interval;
        this.normalizeInterval = normalizeInterval;
        this.type = (RealType)type.createVariable();
        this.osemspeedup = osemspeedup;
        this.intervalRandomAccess = interval.randomAccess();
        this.normalizeIntervalRandomAccess = normalizeInterval.randomAccess();
    }

    public T get() {
        this.intervalRandomAccess.setPosition(this.position);
        this.normalizeIntervalRandomAccess.setPosition(this.position);
        double v = ((RealType)this.intervalRandomAccess.get()).getRealDouble() / ((RealType)this.normalizeIntervalRandomAccess.get()).getRealDouble();
        this.type.setReal(Math.min(1.0, v * this.osemspeedup));
        return this.type;
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (int)distance;
    }

    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getIntPosition(d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (int)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getIntPosition(d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = (int)position[d];
        }
    }

    public void setPosition(int position, int d) {
        this.position[d] = position;
    }

    public void setPosition(long position, int d) {
        this.position[d] = (int)position;
    }

    public NormalizingRandomAccess<T> copy() {
        return new NormalizingRandomAccess<T>(this.interval, this.normalizeInterval, this.osemspeedup, this.type);
    }

    public NormalizingRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

