/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.python;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apposed.appose.Appose;
import org.apposed.appose.builder.BaseBuilder;
import org.apposed.appose.builder.MambaBuilder;
import org.scijava.command.Command;
import org.scijava.launcher.Splash;
import org.scijava.log.Logger;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, label="Rebuild Python environment")
public class RebuildEnvironment
implements Command {
    private static final int _PROGRESS_LENGTH = 75;
    @Parameter
    private Logger log;
    @Parameter(label="environment definition file")
    private File environmentYaml;
    @Parameter(label="Target directory")
    private File targetDir;
    @Parameter(required=false)
    private UIService uiService;
    private int progressPrinted = 0;

    @Override
    public void run() {
        File backupDir = new File(this.targetDir.getPath() + ".old");
        if (this.targetDir.exists()) {
            String cfgPath;
            String targetPath;
            String cfgPythonDir = System.getProperty("scijava.python.dir", "");
            if (cfgPythonDir != null && !cfgPythonDir.isEmpty() && (targetPath = this.targetDir.getAbsolutePath().replace("\\", "/")).endsWith(cfgPath = cfgPythonDir.replace("\\", "/"))) {
                String msg2 = "You cannot rebuild the environment currently being used by pyimagej (" + cfgPythonDir + ").\nPlease select a different target directory, or restart in Java mode.";
                if (this.uiService != null) {
                    this.uiService.showDialog(msg2, "Cannot Rebuild Active Environment", DialogPrompt.MessageType.ERROR_MESSAGE);
                } else {
                    this.log.error(msg2);
                }
                return;
            }
            boolean confirmed = true;
            if (this.uiService != null) {
                String msg3 = "The environment directory already exists. If you continue, it will be renamed to '" + backupDir.getName() + "' (and any previous backup will be deleted). Continue?";
                DialogPrompt.Result result = this.uiService.showDialog(msg3, "Confirm Environment Rebuild", DialogPrompt.MessageType.QUESTION_MESSAGE, DialogPrompt.OptionType.YES_NO_OPTION);
                boolean bl = confirmed = result == DialogPrompt.Result.YES_OPTION;
            }
            if (!confirmed) {
                return;
            }
        }
        if (backupDir.exists()) {
            try (Stream<Path> x = Files.walk(backupDir.toPath(), new FileVisitOption[0]);){
                x.sorted(Comparator.reverseOrder()).forEach(p -> {
                    try {
                        Files.delete(p);
                    }
                    catch (IOException exc) {
                        this.log.error(exc);
                    }
                });
            }
            catch (IOException exc) {
                this.log.error(exc);
            }
        }
        if (this.targetDir.exists()) {
            this.targetDir.renameTo(backupDir);
        }
        try {
            BaseBuilder builder = ((MambaBuilder)((MambaBuilder)((MambaBuilder)((MambaBuilder)((MambaBuilder)Appose.mamba().file(this.environmentYaml.getAbsolutePath())).scheme("environment.yml")).base(this.targetDir)).subscribeOutput(this::reportMsg)).subscribeError(this::reportErr)).subscribeProgress((msg, cur, max) -> Splash.update(msg, (double)cur / (double)max));
            System.err.println();
            this.log.info("Building Python environment");
            Splash.show();
            builder.build();
            if (this.uiService != null) {
                this.uiService.showDialog("Python environment setup was successful and is ready to use!", "Environment Ready", DialogPrompt.MessageType.INFORMATION_MESSAGE);
            }
        }
        catch (IOException exc) {
            this.log.error("Failed to build Python environment", exc);
        }
    }

    private void reportErr(String s) {
        this.report(s, this.log::error);
    }

    private void reportMsg(String s) {
        this.report(s, this.log::info);
    }

    private void report(String s, Consumer<String> reporter) {
        if (s.isEmpty()) {
            System.err.print(".");
            ++this.progressPrinted;
            if (this.progressPrinted >= 75) {
                System.err.println();
                this.progressPrinted = 0;
            }
        } else {
            if (this.progressPrinted > 0) {
                System.err.println();
                this.progressPrinted = 0;
            }
            while (s.endsWith("\n") || s.endsWith("\r")) {
                s = s.substring(0, s.length() - 1);
            }
            reporter.accept(s);
        }
    }
}

