/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.algorithm.kdtree.KDTreeNodeIterable;
import net.imglib2.algorithm.kdtree.SplitHyperPlaneKDTreeImpl;

public class SplitHyperPlaneKDTree<T> {
    private final SplitHyperPlaneKDTreeImpl impl;
    private final KDTreeNodeIterable<T> aboveNodes;
    private final KDTreeNodeIterable<T> belowNodes;

    public SplitHyperPlaneKDTree(KDTree<T> tree) {
        this.impl = new SplitHyperPlaneKDTreeImpl(tree.impl());
        this.aboveNodes = new KDTreeNodeIterable<T>(this.impl.getAboveNodes(), tree);
        this.belowNodes = new KDTreeNodeIterable<T>(this.impl.getBelowNodes(), tree);
    }

    public int numDimensions() {
        return this.impl.numDimensions();
    }

    public void split(HyperPlane plane) {
        this.impl.split(plane);
    }

    public void split(double[] plane) {
        this.impl.split(plane);
    }

    public Iterable<KDTreeNode<T>> getAboveNodes() {
        return this.aboveNodes;
    }

    public Iterable<KDTreeNode<T>> getBelowNodes() {
        return this.belowNodes;
    }
}

