/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apposed.appose.builder.Tool;
import org.apposed.appose.util.Downloads;
import org.apposed.appose.util.Environments;
import org.apposed.appose.util.Platforms;

class Pixi
extends Tool {
    private static final Path PIXI_RELATIVE_PATH = Platforms.isWindows() ? Paths.get(".pixi", "bin", "pixi.exe") : Paths.get(".pixi", "bin", "pixi");
    public static final String BASE_PATH = Environments.apposeEnvsDir();
    private static final String PIXI_VERSION = "v0.58.0";
    private static final String PIXI_BINARY = Pixi.pixiBinary();
    public static final String PIXI_URL = PIXI_BINARY == null ? null : "https://github.com/prefix-dev/pixi/releases/download/v0.58.0/" + PIXI_BINARY;

    private static String pixiBinary() {
        switch (Platforms.PLATFORM) {
            case "MACOS|ARM64": {
                return "pixi-aarch64-apple-darwin.tar.gz";
            }
            case "MACOS|X64": {
                return "pixi-x86_64-apple-darwin.tar.gz";
            }
            case "WINDOWS|ARM64": {
                return "pixi-aarch64-pc-windows-msvc.zip";
            }
            case "WINDOWS|X64": {
                return "pixi-x86_64-pc-windows-msvc.zip";
            }
            case "LINUX|ARM64": {
                return "pixi-aarch64-unknown-linux-musl.tar.gz";
            }
            case "LINUX|X64": {
                return "pixi-x86_64-unknown-linux-musl.tar.gz";
            }
        }
        return null;
    }

    public Pixi() {
        this(null);
    }

    public Pixi(String rootdir) {
        super("pixi", PIXI_URL, Paths.get(rootdir == null ? BASE_PATH : rootdir, new String[0]).resolve(PIXI_RELATIVE_PATH).toAbsolutePath().toString(), rootdir == null ? BASE_PATH : rootdir);
    }

    @Override
    protected void decompress(File archive) throws IOException, InterruptedException {
        boolean executableSet;
        File pixiBaseDir = new File(this.rootdir);
        if (!pixiBaseDir.isDirectory() && !pixiBaseDir.mkdirs()) {
            throw new IOException("Failed to create Pixi default directory " + pixiBaseDir.getParentFile().getAbsolutePath() + ". Please try installing it in another directory.");
        }
        File pixiBinDir = Paths.get(this.rootdir, new String[0]).resolve(".pixi").resolve("bin").toFile();
        if (!pixiBinDir.exists() && !pixiBinDir.mkdirs()) {
            throw new IOException("Failed to create Pixi bin directory: " + pixiBinDir);
        }
        Downloads.unpack(archive, pixiBinDir);
        File pixiFile = new File(this.command);
        if (!pixiFile.exists()) {
            throw new IOException("Expected pixi binary is missing: " + this.command);
        }
        if (!pixiFile.canExecute() && !(executableSet = pixiFile.setExecutable(true))) {
            throw new IOException("Cannot set file as executable due to missing permissions, please do it manually: " + this.command);
        }
    }

    public void init(File projectDir) throws IOException, InterruptedException {
        this.checkInstalled();
        this.exec("init", projectDir.getAbsolutePath());
    }

    public void addChannels(File projectDir, String ... channels) throws IOException, InterruptedException {
        this.checkInstalled();
        if (channels.length == 0) {
            return;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("project");
        cmd.add("channel");
        cmd.add("add");
        cmd.add("--manifest-path");
        cmd.add(new File(projectDir, "pixi.toml").getAbsolutePath());
        cmd.addAll(Arrays.asList(channels));
        this.exec(cmd.toArray(new String[0]));
    }

    public void addCondaPackages(File projectDir, String ... packages) throws IOException, InterruptedException {
        this.checkInstalled();
        if (packages.length == 0) {
            return;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("add");
        cmd.add("--manifest-path");
        cmd.add(new File(projectDir, "pixi.toml").getAbsolutePath());
        cmd.addAll(Arrays.asList(packages));
        this.exec(cmd.toArray(new String[0]));
    }

    public void addPypiPackages(File projectDir, String ... packages) throws IOException, InterruptedException {
        this.checkInstalled();
        if (packages.length == 0) {
            return;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("add");
        cmd.add("--pypi");
        cmd.add("--manifest-path");
        cmd.add(new File(projectDir, "pixi.toml").getAbsolutePath());
        cmd.addAll(Arrays.asList(packages));
        this.exec(cmd.toArray(new String[0]));
    }

    @Override
    public String version() throws IOException, InterruptedException {
        List<String> cmd = Platforms.baseCommand();
        cmd.add(this.command);
        cmd.add("--version");
        Process process = this.processBuilder(this.rootdir, false).command(cmd).start();
        if (process.waitFor() != 0) {
            throw new RuntimeException("Error getting Pixi version");
        }
        return new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
    }
}

