/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.sampler;

import java.util.List;
import net.imagej.sampler.PositionIterator;
import net.imagej.sampler.SamplingDefinition;

class SparsePositionIterator
implements PositionIterator {
    private final int[] maxIndexes;
    private final int[] indexes;
    private final List<List<Long>> actualValues;
    private final long[] currPos;

    SparsePositionIterator(SamplingDefinition def) {
        this.actualValues = def.getInputRanges();
        this.maxIndexes = this.calcMaxes(def);
        this.currPos = new long[this.maxIndexes.length];
        for (int i = 0; i < this.currPos.length; ++i) {
            this.currPos[i] = this.actualValues.get(i).get(0);
        }
        this.indexes = new int[this.maxIndexes.length];
        this.indexes[0] = -1;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.currPos.length; ++i) {
            if (this.indexes[i] >= this.maxIndexes[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public long[] next() {
        for (int i = 0; i < this.indexes.length; ++i) {
            int nextPos = this.indexes[i] + 1;
            if (nextPos <= this.maxIndexes[i]) {
                this.indexes[i] = nextPos;
                this.currPos[i] = this.actualValues.get(i).get(nextPos);
                return this.currPos;
            }
            this.indexes[i] = 0;
            this.currPos[i] = this.actualValues.get(i).get(0);
        }
        throw new IllegalArgumentException("Can't position iterator beyond end");
    }

    private int[] calcMaxes(SamplingDefinition def) {
        int[] mx = new int[this.actualValues.size()];
        for (int i = 0; i < mx.length; ++i) {
            mx[i] = this.actualValues.get(i).size() - 1;
        }
        return mx;
    }
}

