/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui;

import bdv.ui.splitpanel.SplitPanel;
import bdv.util.BdvHandle;
import bdv.util.BdvHandlePanel;
import bdv.util.BdvOptions;
import bdv.util.BdvSource;
import bdv.util.BdvStackSource;
import bdv.viewer.DisplayMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import sc.fiji.labkit.ui.ActionsAndBehaviours;
import sc.fiji.labkit.ui.bdv.BdvAutoContrast;
import sc.fiji.labkit.ui.bdv.BdvLayer;
import sc.fiji.labkit.ui.bdv.BdvLayerLink;
import sc.fiji.labkit.ui.brush.ChangeLabel;
import sc.fiji.labkit.ui.brush.FloodFillController;
import sc.fiji.labkit.ui.brush.LabelBrushController;
import sc.fiji.labkit.ui.brush.PlanarModeController;
import sc.fiji.labkit.ui.brush.SelectLabelController;
import sc.fiji.labkit.ui.labeling.LabelsLayer;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.panel.LabelToolsPanel;

public class BasicLabelingComponent
extends JPanel
implements AutoCloseable {
    private final Holder<BdvStackSource<?>> imageSource;
    private BdvHandle bdvHandle;
    private final JFrame dialogBoxOwner;
    private ActionsAndBehaviours actionsAndBehaviours;
    private ImageLabelingModel model;
    private JSlider zSlider;

    public BasicLabelingComponent(JFrame dialogBoxOwner, ImageLabelingModel model) {
        this.model = model;
        this.dialogBoxOwner = dialogBoxOwner;
        this.initBdv(model.spatialDimensions().numDimensions() < 3);
        this.actionsAndBehaviours = new ActionsAndBehaviours(this.bdvHandle);
        this.imageSource = this.initImageLayer();
        this.initLabelsLayer();
        this.initPanel();
        this.model.transformationModel().initialize(this.bdvHandle.getViewerPanel());
    }

    private void initBdv(boolean is2D) {
        BdvOptions options = BdvOptions.options();
        if (is2D) {
            options.is2D();
        }
        this.bdvHandle = new BdvHandlePanel((Frame)this.dialogBoxOwner, options);
        this.bdvHandle.getViewerPanel().setDisplayMode(DisplayMode.FUSED);
    }

    private void initPanel() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        this.zSlider = new JSlider(1);
        this.zSlider.setFocusable(false);
        this.add((Component)this.initToolsPanel(), "wrap, growx");
        JPanel bdvAndZSlider = new JPanel();
        bdvAndZSlider.setLayout(new BorderLayout());
        bdvAndZSlider.add((Component)this.bdvHandle.getSplitPanel());
        bdvAndZSlider.add((Component)this.zSlider, "After");
        this.add((Component)bdvAndZSlider, "grow");
    }

    private Holder<BdvStackSource<?>> initImageLayer() {
        return this.addBdvLayer(new BdvLayer.FinalLayer(this.model.showable(), "Image", this.model.imageVisibility()));
    }

    private void initLabelsLayer() {
        this.addBdvLayer(new LabelsLayer(this.model));
    }

    public Holder<BdvStackSource<?>> addBdvLayer(BdvLayer layer) {
        return new BdvLayerLink(layer, this.bdvHandle);
    }

    private JPanel initToolsPanel() {
        PlanarModeController planarModeController = new PlanarModeController(this.bdvHandle, this.model, this.zSlider);
        LabelBrushController brushController = new LabelBrushController(this.bdvHandle, this.model, this.actionsAndBehaviours);
        FloodFillController floodFillController = new FloodFillController(this.bdvHandle, this.model, this.actionsAndBehaviours);
        SelectLabelController selectLabelController = new SelectLabelController(this.bdvHandle, this.model, this.actionsAndBehaviours);
        LabelToolsPanel toolsPanel = new LabelToolsPanel(brushController, floodFillController, selectLabelController, planarModeController);
        this.actionsAndBehaviours.addAction(new ChangeLabel(this.model));
        return toolsPanel;
    }

    public void addShortcuts(Collection<? extends AbstractNamedAction> shortcuts) {
        shortcuts.forEach(this.actionsAndBehaviours::addAction);
    }

    @Override
    public void close() {
        this.bdvHandle.close();
    }

    public void autoContrast() {
        BdvAutoContrast.autoContrast((BdvSource)this.imageSource.get());
    }

    public void toggleContrastSettings() {
        SplitPanel splitPanel;
        splitPanel.setCollapsed(!(splitPanel = this.bdvHandle.getSplitPanel()).isCollapsed());
    }
}

