/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import org.janelia.saalfeldlab.n5.ByteArrayDataBlock;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DoubleArrayDataBlock;
import org.janelia.saalfeldlab.n5.FloatArrayDataBlock;
import org.janelia.saalfeldlab.n5.IntArrayDataBlock;
import org.janelia.saalfeldlab.n5.LongArrayDataBlock;
import org.janelia.saalfeldlab.n5.ShortArrayDataBlock;
import org.janelia.saalfeldlab.n5.zarr.Filter;
import org.janelia.saalfeldlab.n5.zarr.ZarrStringDataBlock;

public class DType {
    private static final EnumMap<DataType, String> typestrs = new EnumMap(DataType.class);
    protected String typestr;
    protected final ByteOrder order;
    protected final int nBytes;
    protected final int nBits;
    protected final ByteBlockFactory byteBlockFactory;
    protected final DataBlockFactory dataBlockFactory;
    protected final DataType dataType;

    public DType(String typestr, Collection<Filter> filters) {
        typestrs.put(DataType.INT8, "|i1");
        typestrs.put(DataType.UINT8, "|u1");
        typestrs.put(DataType.INT16, ">i2");
        typestrs.put(DataType.UINT16, ">u2");
        typestrs.put(DataType.INT32, ">i4");
        typestrs.put(DataType.UINT32, ">u4");
        typestrs.put(DataType.INT64, ">i8");
        typestrs.put(DataType.UINT64, ">u8");
        typestrs.put(DataType.FLOAT32, ">f4");
        typestrs.put(DataType.FLOAT64, ">f8");
        typestrs.put(DataType.STRING, "|O");
        typestrs.put(DataType.OBJECT, "|O");
        this.typestr = typestr;
        this.order = typestr.charAt(0) == '<' ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        Primitive primitive = Primitive.fromCode(typestr.charAt(1));
        int nB = primitive == Primitive.OBJECT ? 0 : Integer.parseInt(typestr.substring(2));
        switch (primitive) {
            case BIT: {
                this.nBytes = 0;
                this.nBits = nB;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[(numElements * this.nBits + 7) / 8]);
                this.byteBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[(numElements * this.nBits + 7) / 8]);
                break;
            }
            case UNSIGNED_INT: 
            case INT: {
                this.nBytes = nB;
                this.nBits = 0;
                switch (this.nBytes) {
                    case 1: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements]);
                        break;
                    }
                    case 2: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ShortArrayDataBlock(blockSize, gridPosition, new short[numElements]);
                        break;
                    }
                    case 4: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new IntArrayDataBlock(blockSize, gridPosition, new int[numElements]);
                        break;
                    }
                    case 8: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new LongArrayDataBlock(blockSize, gridPosition, new long[numElements]);
                        break;
                    }
                    default: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                    }
                }
                this.byteBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                break;
            }
            case FLOAT: {
                this.nBytes = nB;
                this.nBits = 0;
                switch (this.nBytes) {
                    case 4: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new FloatArrayDataBlock(blockSize, gridPosition, new float[numElements]);
                        break;
                    }
                    case 8: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new DoubleArrayDataBlock(blockSize, gridPosition, new double[numElements]);
                        break;
                    }
                    default: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                    }
                }
                this.byteBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                break;
            }
            case COMPLEX_FLOAT: {
                this.nBytes = nB;
                this.nBits = 0;
                switch (this.nBytes) {
                    case 8: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new FloatArrayDataBlock(blockSize, gridPosition, new float[numElements * 2]);
                        break;
                    }
                    case 16: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new DoubleArrayDataBlock(blockSize, gridPosition, new double[numElements * 2]);
                        break;
                    }
                    default: {
                        this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                    }
                }
                this.byteBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                break;
            }
            case OBJECT: {
                this.nBytes = 1;
                this.nBits = 0;
                if (filters.contains(Filter.VLEN_UTF8)) {
                    this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ZarrStringDataBlock(blockSize, gridPosition, new String[0]);
                    this.byteBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                    break;
                }
                this.dataBlockFactory = null;
                this.byteBlockFactory = null;
                break;
            }
            default: {
                this.nBytes = nB;
                this.nBits = 0;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
                this.byteBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
            }
        }
        this.dataType = DType.getDataType(primitive, this.nBytes, filters);
    }

    public DType(DataType dataType, int nPrimitives) {
        typestrs.put(DataType.INT8, "|i1");
        typestrs.put(DataType.UINT8, "|u1");
        typestrs.put(DataType.INT16, ">i2");
        typestrs.put(DataType.UINT16, ">u2");
        typestrs.put(DataType.INT32, ">i4");
        typestrs.put(DataType.UINT32, ">u4");
        typestrs.put(DataType.INT64, ">i8");
        typestrs.put(DataType.UINT64, ">u8");
        typestrs.put(DataType.FLOAT32, ">f4");
        typestrs.put(DataType.FLOAT64, ">f8");
        typestrs.put(DataType.STRING, "|O");
        typestrs.put(DataType.OBJECT, "|O");
        this.typestr = typestrs.get(dataType);
        this.order = ByteOrder.BIG_ENDIAN;
        this.nBits = 0;
        this.dataType = dataType;
        switch (dataType) {
            case INT16: 
            case UINT16: {
                this.nBytes = 2 * nPrimitives;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ShortArrayDataBlock(blockSize, gridPosition, new short[numElements * nPrimitives]);
                break;
            }
            case INT32: 
            case UINT32: {
                this.nBytes = 4 * nPrimitives;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new IntArrayDataBlock(blockSize, gridPosition, new int[numElements * nPrimitives]);
                break;
            }
            case INT64: 
            case UINT64: {
                this.nBytes = 8 * nPrimitives;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new LongArrayDataBlock(blockSize, gridPosition, new long[numElements * nPrimitives]);
                break;
            }
            case FLOAT32: {
                this.nBytes = 4 * nPrimitives;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new FloatArrayDataBlock(blockSize, gridPosition, new float[numElements * nPrimitives]);
                break;
            }
            case FLOAT64: {
                this.nBytes = 8 * nPrimitives;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new DoubleArrayDataBlock(blockSize, gridPosition, new double[numElements * nPrimitives]);
                break;
            }
            case STRING: {
                this.nBytes = 1;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ZarrStringDataBlock(blockSize, gridPosition, new String[0]);
                break;
            }
            default: {
                this.nBytes = nPrimitives;
                this.dataBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * nPrimitives]);
            }
        }
        this.byteBlockFactory = (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements * this.nBytes]);
    }

    public DType(DataType dataType) {
        this(dataType, 1);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    protected static final DataType getDataType(Primitive primitive, int nBytes, Collection<Filter> filters) {
        switch (primitive) {
            case INT: {
                switch (nBytes) {
                    case 2: {
                        return DataType.INT16;
                    }
                    case 4: {
                        return DataType.INT32;
                    }
                    case 8: {
                        return DataType.INT64;
                    }
                }
                return DataType.INT8;
            }
            case UNSIGNED_INT: {
                switch (nBytes) {
                    case 2: {
                        return DataType.UINT16;
                    }
                    case 4: {
                        return DataType.UINT32;
                    }
                    case 8: {
                        return DataType.UINT64;
                    }
                }
                return DataType.UINT8;
            }
            case FLOAT: {
                switch (nBytes) {
                    case 4: {
                        return DataType.FLOAT32;
                    }
                    case 8: {
                        return DataType.FLOAT64;
                    }
                }
                return DataType.UINT8;
            }
            case COMPLEX_FLOAT: {
                switch (nBytes) {
                    case 8: {
                        return DataType.FLOAT32;
                    }
                    case 16: {
                        return DataType.FLOAT64;
                    }
                }
                return DataType.UINT8;
            }
            case OBJECT: {
                if (filters.contains(Filter.VLEN_UTF8)) {
                    return DataType.STRING;
                }
                return DataType.OBJECT;
            }
        }
        return DataType.UINT8;
    }

    public String toString() {
        return this.typestr;
    }

    public Collection<Filter> getFilters() {
        if (this.dataType == DataType.STRING) {
            ArrayList<Filter> filterSet = new ArrayList<Filter>();
            filterSet.add(Filter.VLEN_UTF8);
            return filterSet;
        }
        return null;
    }

    public DataBlock<?> createDataBlock(int[] blockSize, long[] gridPosition, int numElements) {
        return this.dataBlockFactory.createDataBlock(blockSize, gridPosition, numElements);
    }

    public ByteArrayDataBlock createByteBlock(int[] blockSize, long[] gridPosition, int numElements) {
        return this.byteBlockFactory.createByteBlock(blockSize, gridPosition, numElements);
    }

    public DataBlock<?> createDataBlock(int[] blockSize, long[] gridPosition) {
        return this.dataBlockFactory.createDataBlock(blockSize, gridPosition, DataBlock.getNumElements((int[])blockSize));
    }

    public ByteArrayDataBlock createByteBlock(int[] blockSize, long[] gridPosition) {
        return this.byteBlockFactory.createByteBlock(blockSize, gridPosition, DataBlock.getNumElements((int[])blockSize));
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public int getNBytes() {
        return this.nBytes;
    }

    public int getNBits() {
        return this.nBits;
    }

    public byte[] createFillBytes(String fill_value) {
        byte[] fillBytes = new byte[this.nBytes];
        ByteBuffer fillBuffer = ByteBuffer.wrap(fillBytes);
        fillBuffer.order(this.order);
        if (fill_value == null) {
            return fillBytes;
        }
        if (fill_value.equals("NaN")) {
            if (this.nBytes == 8) {
                fillBuffer.putDouble(Double.NaN);
            } else if (this.nBytes == 4) {
                fillBuffer.putFloat(Float.NaN);
            }
        } else if (fill_value.equals("Infinity")) {
            if (this.nBytes == 8) {
                fillBuffer.putDouble(Double.POSITIVE_INFINITY);
            } else if (this.nBytes == 4) {
                fillBuffer.putFloat(Float.POSITIVE_INFINITY);
            }
        } else if (fill_value.equals("-Infinity")) {
            if (this.nBytes == 8) {
                fillBuffer.putDouble(Double.NEGATIVE_INFINITY);
            } else if (this.nBytes == 4) {
                fillBuffer.putFloat(Float.NEGATIVE_INFINITY);
            }
        } else {
            try {
                switch (this.dataType) {
                    case INT8: {
                        fillBytes[0] = Byte.parseByte(fill_value);
                        break;
                    }
                    case UINT8: {
                        fillBytes[0] = (byte)(0xFF & Integer.parseInt(fill_value));
                        break;
                    }
                    case INT16: {
                        fillBuffer.putShort(Short.parseShort(fill_value));
                        break;
                    }
                    case UINT16: {
                        fillBuffer.putShort((short)(0xFFFF & Integer.parseInt(fill_value)));
                        break;
                    }
                    case INT32: {
                        fillBuffer.putInt(Integer.parseInt(fill_value));
                        break;
                    }
                    case UINT32: {
                        fillBuffer.putInt(Integer.parseUnsignedInt(fill_value));
                        break;
                    }
                    case INT64: {
                        fillBuffer.putLong(Long.parseLong(fill_value));
                        break;
                    }
                    case UINT64: {
                        fillBuffer.putLong(Long.parseUnsignedLong(fill_value));
                        break;
                    }
                    case FLOAT32: {
                        fillBuffer.putFloat(Float.parseFloat(fill_value));
                        break;
                    }
                    case FLOAT64: {
                        fillBuffer.putDouble(Double.parseDouble(fill_value));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fillBytes;
    }

    private static interface ByteBlockFactory {
        public ByteArrayDataBlock createByteBlock(int[] var1, long[] var2, int var3);
    }

    private static interface DataBlockFactory {
        public DataBlock<?> createDataBlock(int[] var1, long[] var2, int var3);
    }

    public static enum Primitive {
        BIT('t'),
        BOOLEAN('b'),
        INT('i'),
        UNSIGNED_INT('u'),
        FLOAT('f'),
        COMPLEX_FLOAT('c'),
        TIMEDELTA('m'),
        DATETIME('M'),
        OBJECT('O'),
        STRING('S'),
        UNICODE('U'),
        OTHER('V');

        private final char code;

        private Primitive(char code) {
            this.code = code;
        }

        public char code() {
            return this.code;
        }

        public static Primitive fromCode(char code) {
            for (Primitive value : Primitive.values()) {
                if (value.code() != code) continue;
                return value;
            }
            return null;
        }
    }
}

