/*
 * Decompiled with CFR 0.152.
 */
package io.scif.media.imageio.plugins.tiff;

import io.scif.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import io.scif.media.imageio.plugins.tiff.TIFFField;
import io.scif.media.imageio.plugins.tiff.TIFFTag;
import io.scif.media.imageio.plugins.tiff.TIFFTagSet;
import io.scif.media.imageioimpl.plugins.tiff.TIFFIFD;
import io.scif.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;

public class TIFFDirectory
implements Cloneable {
    private static final int MAX_LOW_FIELD_TAG_NUM = 532;
    private List tagSets;
    private TIFFTag parentTag;
    private TIFFField[] lowFields = new TIFFField[533];
    private int numLowFields = 0;
    private Map highFields = new TreeMap();

    public static TIFFDirectory createFromMetadata(IIOMetadata tiffImageMetadata) throws IIOInvalidTreeException {
        TIFFImageMetadata tim;
        if (tiffImageMetadata == null) {
            throw new IllegalArgumentException("tiffImageMetadata == null");
        }
        if (tiffImageMetadata instanceof TIFFImageMetadata) {
            tim = (TIFFImageMetadata)tiffImageMetadata;
        } else {
            ArrayList<BaselineTIFFTagSet> l = new ArrayList<BaselineTIFFTagSet>(1);
            l.add(BaselineTIFFTagSet.getInstance());
            tim = new TIFFImageMetadata(l);
            String formatName = null;
            if ("com_sun_media_imageio_plugins_tiff_image_1.0".equals(tiffImageMetadata.getNativeMetadataFormatName())) {
                formatName = "com_sun_media_imageio_plugins_tiff_image_1.0";
            } else {
                String[] extraNames = tiffImageMetadata.getExtraMetadataFormatNames();
                if (extraNames != null) {
                    for (int i = 0; i < extraNames.length; ++i) {
                        if (!"com_sun_media_imageio_plugins_tiff_image_1.0".equals(extraNames[i])) continue;
                        formatName = extraNames[i];
                        break;
                    }
                }
                if (formatName == null) {
                    if (tiffImageMetadata.isStandardMetadataFormatSupported()) {
                        formatName = "javax_imageio_1.0";
                    } else {
                        throw new IllegalArgumentException("Parameter does not support required metadata format!");
                    }
                }
            }
            tim.setFromTree(formatName, tiffImageMetadata.getAsTree(formatName));
        }
        return tim.getRootIFD();
    }

    private static TIFFIFD getDirectoryAsIFD(TIFFDirectory dir) {
        if (dir instanceof TIFFIFD) {
            return (TIFFIFD)dir;
        }
        TIFFIFD ifd = new TIFFIFD(Arrays.asList(dir.getTagSets()), dir.getParentTag());
        for (TIFFField f : dir.getTIFFFields()) {
            TIFFTag tag = f.getTag();
            if (tag.isIFDPointer()) {
                TIFFIFD subIFD = TIFFDirectory.getDirectoryAsIFD((TIFFDirectory)f.getData());
                f = new TIFFField(tag, f.getType(), f.getCount(), subIFD);
            }
            ifd.addTIFFField(f);
        }
        return ifd;
    }

    public TIFFDirectory(TIFFTagSet[] tagSets, TIFFTag parentTag) {
        if (tagSets == null) {
            throw new IllegalArgumentException("tagSets == null!");
        }
        this.tagSets = new ArrayList(tagSets.length);
        int numTagSets = tagSets.length;
        for (int i = 0; i < numTagSets; ++i) {
            this.tagSets.add(tagSets[i]);
        }
        this.parentTag = parentTag;
    }

    public TIFFTagSet[] getTagSets() {
        return this.tagSets.toArray(new TIFFTagSet[this.tagSets.size()]);
    }

    public void addTagSet(TIFFTagSet tagSet) {
        if (tagSet == null) {
            throw new IllegalArgumentException("tagSet == null");
        }
        if (!this.tagSets.contains(tagSet)) {
            this.tagSets.add(tagSet);
        }
    }

    public void removeTagSet(TIFFTagSet tagSet) {
        if (tagSet == null) {
            throw new IllegalArgumentException("tagSet == null");
        }
        if (this.tagSets.contains(tagSet)) {
            this.tagSets.remove(tagSet);
        }
    }

    public TIFFTag getParentTag() {
        return this.parentTag;
    }

    public TIFFTag getTag(int tagNumber) {
        return TIFFIFD.getTag(tagNumber, this.tagSets);
    }

    public int getNumTIFFFields() {
        return this.numLowFields + this.highFields.size();
    }

    public boolean containsTIFFField(int tagNumber) {
        return tagNumber >= 0 && tagNumber <= 532 && this.lowFields[tagNumber] != null || this.highFields.containsKey(new Integer(tagNumber));
    }

    public void addTIFFField(TIFFField f) {
        if (f == null) {
            throw new IllegalArgumentException("f == null");
        }
        int tagNumber = f.getTagNumber();
        if (tagNumber >= 0 && tagNumber <= 532) {
            if (this.lowFields[tagNumber] == null) {
                ++this.numLowFields;
            }
            this.lowFields[tagNumber] = f;
        } else {
            this.highFields.put(new Integer(tagNumber), f);
        }
    }

    public TIFFField getTIFFField(int tagNumber) {
        TIFFField f = tagNumber >= 0 && tagNumber <= 532 ? this.lowFields[tagNumber] : (TIFFField)this.highFields.get(new Integer(tagNumber));
        return f;
    }

    public void removeTIFFField(int tagNumber) {
        if (tagNumber >= 0 && tagNumber <= 532) {
            if (this.lowFields[tagNumber] != null) {
                --this.numLowFields;
                this.lowFields[tagNumber] = null;
            }
        } else {
            this.highFields.remove(new Integer(tagNumber));
        }
    }

    public TIFFField[] getTIFFFields() {
        TIFFField[] fields = new TIFFField[this.numLowFields + this.highFields.size()];
        int nextIndex = 0;
        for (int i = 0; i <= 532; ++i) {
            if (this.lowFields[i] == null) continue;
            fields[nextIndex++] = this.lowFields[i];
            if (nextIndex == this.numLowFields) break;
        }
        if (!this.highFields.isEmpty()) {
            Iterator keys = this.highFields.keySet().iterator();
            while (keys.hasNext()) {
                fields[nextIndex++] = (TIFFField)this.highFields.get(keys.next());
            }
        }
        return fields;
    }

    public void removeTIFFFields() {
        Arrays.fill(this.lowFields, null);
        this.numLowFields = 0;
        this.highFields.clear();
    }

    public IIOMetadata getAsMetadata() {
        return new TIFFImageMetadata(TIFFDirectory.getDirectoryAsIFD(this));
    }

    public Object clone() {
        TIFFDirectory dir = new TIFFDirectory(this.getTagSets(), this.getParentTag());
        TIFFField[] fields = this.getTIFFFields();
        int numFields = fields.length;
        for (int i = 0; i < numFields; ++i) {
            dir.addTIFFField(fields[i]);
        }
        return dir;
    }
}

