/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJUserInterface;
import ij.IJ;

public class VJGradient {
    private float mag0;
    private float mag1;
    private float mag2;
    private float g0x;
    private float g0y;
    private float g0z;
    private float g1x;
    private float g1y;
    private float g1z;
    private float g2x;
    private float g2y;
    private float g2z;
    private int dimensions;
    private static final double defaultEpsilon = 1.0E-8;

    public VJGradient(double[] g) {
        this(g[0], g[1], g[2]);
        this.dimensions = 1;
    }

    public VJGradient(double gx, double gy, double gz) {
        this.g0x = (float)gx;
        this.g0y = (float)gy;
        this.g0z = (float)gz;
        this.mag0 = this.magnitude(this.g0x, this.g0y, this.g0z);
        this.mag1 = 0.0f;
        this.mag2 = 0.0f;
        this.dimensions = 1;
    }

    public VJGradient(float gx, float gy, float gz) {
        this.g0x = gx;
        this.g0y = gy;
        this.g0z = gz;
        this.mag0 = this.magnitude(this.g0x, this.g0y, this.g0z);
        this.mag1 = 0.0f;
        this.mag2 = 0.0f;
        this.dimensions = 1;
    }

    public VJGradient(double[][] g) {
        this.dimensions = g.length;
        if (this.dimensions > 3) {
            VJUserInterface.write("error: too many dimensions for gradient.");
            return;
        }
        this.g0x = (float)g[0][0];
        this.g0y = (float)g[0][1];
        this.g0z = (float)g[0][2];
        this.g1x = (float)g[1][0];
        this.g1y = (float)g[1][1];
        this.g1z = (float)g[1][2];
        this.mag0 = this.magnitude(this.g0x, this.g0y, this.g0z);
        this.mag1 = this.magnitude(this.g1x, this.g1y, this.g1z);
        if (this.dimensions == 3) {
            this.g2x = (float)g[2][0];
            this.g2y = (float)g[2][1];
            this.g2z = (float)g[2][2];
            this.mag2 = this.magnitude(this.g2x, this.g2y, this.g2z);
        }
    }

    public float getx() {
        return this.g0x;
    }

    public float gety() {
        return this.g0y;
    }

    public float getz() {
        return this.g0z;
    }

    public float getmag() {
        return this.mag0;
    }

    public float getx(int i) {
        switch (i) {
            case 0: {
                return this.g0x;
            }
            case 1: {
                return this.g1x;
            }
        }
        return this.g2x;
    }

    public float gety(int i) {
        switch (i) {
            case 0: {
                return this.g0y;
            }
            case 1: {
                return this.g1y;
            }
        }
        return this.g2y;
    }

    public float getz(int i) {
        switch (i) {
            case 0: {
                return this.g0z;
            }
            case 1: {
                return this.g1z;
            }
        }
        return this.g2z;
    }

    public float getmag(int i) {
        switch (i) {
            case 0: {
                return this.mag0;
            }
            case 1: {
                return this.mag1;
            }
        }
        return this.mag2;
    }

    public float getAverageMag() {
        if (this.dimensions == 3) {
            return (this.mag0 + this.mag1 + this.mag2) / 3.0f;
        }
        return this.mag0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void normalize() {
        if ((double)this.mag0 > 1.0E-8) {
            this.g0x /= this.mag0;
            this.g0y /= this.mag0;
            this.g0z /= this.mag0;
        } else {
            this.g0x = 0.0f;
            this.g0y = 0.0f;
            this.g0z = 0.0f;
        }
        if ((double)this.mag1 > 1.0E-8) {
            this.g1x /= this.mag1;
            this.g1y /= this.mag1;
            this.g1z /= this.mag1;
        }
        if ((double)this.mag2 > 1.0E-8) {
            this.g2x /= this.mag2;
            this.g2y /= this.mag2;
            this.g2z /= this.mag2;
        }
    }

    private float magnitude(double gx, double gy, double gz) {
        return (float)Math.sqrt(gx * gx + gy * gy + gz * gz);
    }

    public String toString() {
        return "" + IJ.d2s((double)this.mag0, (int)2) + ":" + IJ.d2s((double)this.g0x, (int)2) + "," + IJ.d2s((double)this.g0y, (int)2) + "," + IJ.d2s((double)this.g0z, (int)2);
    }
}

