/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import customnode.CustomTriangleMesh;
import fiji.geom.AreaCalculations;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij3d.Utils;
import ini.trakem2.Project;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.AreaWrapper;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Node;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Tree;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.imaging.Segmentation;
import ini.trakem2.utils.AreaUtils;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;
import mpicbg.models.CoordinateTransform;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;

public class AreaTree
extends Tree<Area>
implements AreaContainer {
    private boolean fill_paint = true;
    private AreaNode receiver = null;

    public AreaTree(Project project, String title) {
        super(project, title);
        this.addToDatabase();
    }

    public AreaTree(Project project, long id, HashMap<String, String> ht_attr, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attr, ht_links);
    }

    public AreaTree(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, id, title, width, height, alpha, visible, color, locked, at);
    }

    @Override
    public Tree<Area> newInstance() {
        return new AreaTree(this.project, this.project.getLoader().getNextId(), this.title, this.width, this.height, this.alpha, this.visible, this.color, this.locked, this.at);
    }

    @Override
    public Node<Area> newNode(float lx, float ly, Layer la, Node<?> modelNode) {
        return new AreaNode(lx, ly, la);
    }

    @Override
    public Node<Area> newNode(HashMap<String, String> ht_attr) {
        return new AreaNode(ht_attr);
    }

    @Override
    public AreaTree clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        AreaTree art = new AreaTree(pr, nid, this.title, this.width, this.height, this.alpha, this.visible, this.color, this.locked, this.at);
        art.root = null == this.root ? null : this.root.clone(pr);
        art.addToDatabase();
        if (null != art.root) {
            art.cacheSubtree(art.root.getSubtreeNodes());
        }
        return art;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Area> getAreas(Layer layer, Rectangle box) {
        Map map = this.node_layer_map;
        synchronized (map) {
            Set nodes = (Set)this.node_layer_map.get(layer);
            if (null == nodes) {
                return null;
            }
            ArrayList<Area> a = new ArrayList<Area>();
            for (AreaNode nd : nodes) {
                if (null == nd.aw || !nd.aw.getArea().createTransformedArea(this.at).getBounds().intersects(box)) continue;
                a.add(nd.aw.getArea());
            }
            return a;
        }
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        Tree.exportDTD(sb_header, hs, indent);
        String type = "t2_areatree";
        if (hs.contains("t2_areatree")) {
            return;
        }
        hs.add("t2_areatree");
        sb_header.append(indent).append("<!ELEMENT t2_areatree (t2_node*,").append(Displayable.commonDTDChildren()).append(")>\n");
        Displayable.exportDTD("t2_areatree", sb_header, hs, indent);
    }

    @Override
    protected boolean exportXMLNodeAttributes(StringBuilder indent, StringBuilder sb, Node<Area> node) {
        return true;
    }

    @Override
    protected boolean exportXMLNodeData(StringBuilder indent, StringBuilder sb, Node<Area> node) {
        AreaNode an = (AreaNode)node;
        if (null == an.aw || an.aw.getArea().isEmpty()) {
            return true;
        }
        sb.append((CharSequence)indent).append("<t2_area>\n");
        indent.append(' ');
        AreaList.exportArea(sb, indent.toString(), ((AreaNode)node).aw.getArea());
        indent.setLength(indent.length() - 1);
        sb.append((CharSequence)indent).append("</t2_area>\n");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean calculateBoundingBox(Layer la) {
        try {
            if (null == this.root) {
                this.at.setToIdentity();
                this.width = 0.0f;
                this.height = 0.0f;
                boolean bl = false;
                return bl;
            }
            Rectangle box = null;
            int countNodes = 0;
            Map map = this.node_layer_map;
            synchronized (map) {
                for (Object nodes : this.node_layer_map.values()) {
                    Rectangle b = this.getBounds((Collection<? extends Node<Area>>)nodes);
                    if (null == b) continue;
                    if (null == box) {
                        box = b;
                    } else {
                        box.add(b);
                    }
                    countNodes += nodes.size();
                }
            }
            if (null == box) {
                boolean bl = false;
                return bl;
            }
            this.width = box.width;
            this.height = box.height;
            if (0 == box.x && 0 == box.y) {
                boolean bl = false;
                return bl;
            }
            final AffineTransform aff = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -box.x, -box.y);
            Map map2 = this.node_layer_map;
            synchronized (map2) {
                if (this.node_layer_map.size() < 10 && countNodes < 100) {
                    for (Collection nodes : this.node_layer_map.values()) {
                        for (AreaNode nd : nodes) {
                            nd.translate(-box.x, -box.y);
                            if (null == nd.aw) continue;
                            nd.aw.getArea().transform(aff);
                        }
                    }
                } else {
                    ThreadPoolExecutor exe = ini.trakem2.utils.Utils.newFixedThreadPool("AreaTree-CBB");
                    ArrayList fus = new ArrayList();
                    final float dx = -box.x;
                    final float dy = -box.y;
                    for (final Collection nodes : this.node_layer_map.values()) {
                        fus.add(exe.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (AreaNode nd : nodes) {
                                    nd.translate(dx, dy);
                                    if (null == nd.aw) continue;
                                    nd.aw.getArea().transform(aff);
                                }
                            }
                        }));
                    }
                    ini.trakem2.utils.Utils.wait(fus);
                    exe.shutdown();
                }
            }
            this.at.translate(box.x, box.y);
            boolean bl = true;
            return bl;
        }
        finally {
            this.updateBucket(la);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AreaNode findEventReceiver(Collection<Node<Area>> nodes, int lx, int ly, Layer layer, double mag, InputEvent ie) {
        Area brush = null;
        try {
            brush = AreaWrapper.makeMouseBrush(ProjectToolbar.getBrushSize(), mag).createTransformedArea(this.at.createInverse());
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        Map map = this.node_layer_map;
        synchronized (map) {
            AreaNode closest = null;
            double min_dist = Double.MAX_VALUE;
            for (AreaNode areaNode : nodes) {
                if (brush.contains(areaNode.x, areaNode.y) || M.intersects(areaNode.getData(), brush)) {
                    return areaNode;
                }
                if (null == areaNode.aw) continue;
                Collection<Polygon> pols = M.getPolygons(areaNode.getData());
                for (Polygon pol : pols) {
                    if (!pol.contains(lx, ly)) continue;
                    return areaNode;
                }
                if (!ie.isAltDown()) continue;
                for (Polygon pol : pols) {
                    for (int i = 0; i < pol.npoints; ++i) {
                        double sqdist = Math.pow(lx - pol.xpoints[i], 2.0) + Math.pow(ly - pol.ypoints[i], 2.0);
                        if (!(sqdist < min_dist)) continue;
                        closest = areaNode;
                        min_dist = sqdist;
                    }
                }
            }
            if (null != closest) {
                return closest;
            }
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent me, final Layer la, int x_p, int y_p, double mag) {
        int tool = ProjectToolbar.getToolId();
        if (16 == tool) {
            super.mousePressed(me, la, x_p, y_p, mag);
            return;
        }
        if (null == this.root) {
            return;
        }
        Layer layer = Display.getFrontLayer();
        Collection nodes = (Collection)this.node_layer_map.get(layer);
        if (null == nodes || nodes.isEmpty()) {
            return;
        }
        if (tool == 15) {
            Area roi;
            try {
                roi = new Area(this.at.createInverse().createTransformedShape(Segmentation.fmp.getBounds(x_p, y_p)));
            }
            catch (NoninvertibleTransformException nite) {
                IJError.print(nite);
                return;
            }
            for (Node nd : nodes) {
                if (!nd.intersects(roi)) continue;
                this.receiver = (AreaNode)nd;
                break;
            }
        } else if (tool == 17) {
            int x_pl = x_p;
            int y_pl = y_p;
            if (!this.at.isIdentity()) {
                Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
                x_pl = (int)po.x;
                y_pl = (int)po.y;
            }
            this.receiver = this.findEventReceiver(nodes, x_pl, y_pl, layer, mag, me);
        }
        if (null != this.receiver) {
            this.receiver.getData();
            this.receiver.aw.setSource(this);
            this.receiver.aw.mousePressed(me, la, x_p, y_p, mag, Arrays.asList(new Runnable(){

                @Override
                public void run() {
                    AreaTree.this.calculateBoundingBox(la);
                }
            }));
            this.receiver.aw.setSource(null);
            this.setLastEdited(this.receiver);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        if (16 == ProjectToolbar.getToolId()) {
            super.mouseDragged(me, la, x_p, y_p, x_d, y_d, x_d_old, y_d_old);
            return;
        }
        if (null == this.receiver) {
            return;
        }
        this.receiver.aw.setSource(this);
        this.receiver.aw.mouseDragged(me, la, x_p, y_p, x_d, y_d, x_d_old, y_d_old);
        this.receiver.aw.setSource(null);
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        if (16 == ProjectToolbar.getToolId()) {
            super.mouseReleased(me, la, x_p, y_p, x_d, y_d, x_r, y_r);
            return;
        }
        if (null == this.receiver) {
            return;
        }
        this.receiver.aw.setSource(this);
        this.receiver.aw.mouseReleased(me, la, x_p, y_p, x_d, y_d, x_r, y_r);
        this.receiver.aw.setSource(null);
        this.updateViewData(this.receiver);
        this.receiver = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent ke) {
        int tool = ProjectToolbar.getToolId();
        try {
            if (17 == tool) {
                AreaNode nd;
                Object origin = ke.getSource();
                if (!(origin instanceof DisplayCanvas)) {
                    ke.consume();
                    return;
                }
                DisplayCanvas dc = (DisplayCanvas)origin;
                Layer layer = dc.getDisplay().getLayer();
                Collection nodes = (Collection)this.node_layer_map.get(layer);
                if (null == nodes || nodes.isEmpty()) {
                    return;
                }
                Point p = dc.getCursorLoc();
                int x = p.x;
                int y = p.y;
                if (!this.at.isIdentity()) {
                    Point2D.Double po = this.inverseTransformPoint(x, y);
                    x = (int)po.x;
                    y = (int)po.y;
                }
                if (null != (nd = this.findEventReceiver(nodes, x, y, layer, dc.getMagnification(), ke)) && null == nd.aw && ke.getKeyCode() == 86) {
                    nd.getData();
                }
                if (null != nd && null != nd.aw) {
                    nd.aw.setSource(this);
                    nd.aw.keyPressed(ke, dc, layer);
                    nd.aw.setSource(null);
                    if (ke.isConsumed()) {
                        this.updateViewData(nd);
                        return;
                    }
                }
            }
        }
        finally {
            if (!ke.isConsumed()) {
                super.keyPressed(ke);
            }
        }
    }

    @Override
    protected Rectangle getBounds(Collection<? extends Node<Area>> nodes) {
        Rectangle box = null;
        for (AreaNode areaNode : nodes) {
            Rectangle b;
            if (null == areaNode.aw || areaNode.aw.getArea().isEmpty()) {
                b = new Rectangle((int)areaNode.x, (int)areaNode.y, 1, 1);
            } else {
                b = areaNode.aw.getArea().getBounds();
                b.add(new Rectangle((int)areaNode.x, (int)areaNode.y, 1, 1));
            }
            if (null == box) {
                box = b;
                continue;
            }
            box.add(b);
        }
        return box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree.MeshData generateMesh(double scale, int resample) {
        HashMap<Layer, Area> areas = new HashMap<Layer, Area>();
        Map map = this.node_layer_map;
        synchronized (map) {
            for (Map.Entry e : this.node_layer_map.entrySet()) {
                Area a = new Area();
                for (AreaNode nd : (Collection)e.getValue()) {
                    if (null == nd.aw) continue;
                    a.add(nd.aw.getArea());
                }
                areas.put((Layer)e.getKey(), a);
            }
        }
        List<Point3f> ps = AreaUtils.generateTriangles(this, scale, resample, areas);
        ArrayList<Color3f> colors = new ArrayList<Color3f>();
        ini.trakem2.utils.Utils.log("WARNING: AreaTree multicolor 3D mesh is not yet implemented.");
        Color3f cf = Utils.toColor3f((Color)this.color);
        for (int i = 0; i < ps.size(); ++i) {
            colors.add(cf);
        }
        return new Tree.MeshData(ps, colors);
    }

    public void debug() {
        for (Map.Entry e : this.node_layer_map.entrySet()) {
            for (Node nd : (Set)e.getValue()) {
                Area a = ((AreaNode)nd).aw.getArea();
                ini.trakem2.utils.Utils.log2("area: " + a + "  " + (null != a ? a.getBounds() : null));
                ini.trakem2.utils.Utils.log2(" .. and has paths: " + M.getPolygons(a).size());
            }
        }
    }

    @Override
    protected boolean isAnyNear(Collection<Node<Area>> nodes, float lx, float ly, float radius) {
        for (Node<Area> nd : nodes) {
            AreaNode an = (AreaNode)nd;
            if (null == an.aw && an.isNear(lx, ly, radius)) {
                return true;
            }
            if (!an.getData().contains(lx, ly)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultsTable measureAreas(ResultsTable rt) {
        if (null == this.root) {
            return rt;
        }
        if (null == rt) {
            rt = ini.trakem2.utils.Utils.createResultsTable("Area results", new String[]{"id", "name-id", "layer index", "area"});
        }
        double nameId = this.getNameId();
        Calibration cal = this.layer_set.getCalibration();
        String units = cal.getUnit();
        TreeMap<Layer, ArrayList<Area>> sm = new TreeMap<Layer, ArrayList<Area>>(Layer.COMPARATOR);
        Map map = this.node_layer_map;
        synchronized (map) {
            for (Node nd : this.root.getSubtreeNodes()) {
                Area area = (Area)nd.getData();
                if (null == area || area.isEmpty()) continue;
                ArrayList<Area> col = (ArrayList<Area>)sm.get(nd.getLayer());
                if (null == col) {
                    col = new ArrayList<Area>();
                    sm.put(nd.getLayer(), col);
                }
                col.add(area);
            }
        }
        for (Map.Entry entry : sm.entrySet()) {
            int index = this.layer_set.indexOf((Layer)entry.getKey()) + 1;
            for (Area area : (Collection)entry.getValue()) {
                rt.incrementCounter();
                rt.addLabel("units", units);
                rt.addValue(0, (double)this.id);
                rt.addValue(1, nameId);
                rt.addValue(2, (double)index);
                double pixel_area = Math.abs(AreaCalculations.area((PathIterator)area.createTransformedArea(this.at).getPathIterator(null)));
                double surface = pixel_area * cal.pixelWidth * cal.pixelHeight;
                rt.addValue(3, surface);
            }
        }
        return rt;
    }

    public boolean interpolateTowardsParent(Node<Area> nd, boolean node_centric, boolean always_use_distance_map) throws Exception {
        if (null == nd || null == nd.parent) {
            return false;
        }
        Area first = nd.getData();
        if (null == first || first.isEmpty()) {
            return false;
        }
        LinkedList chain = new LinkedList();
        Node p = nd.parent;
        while (null != p && (null == p.getData() || ((Area)p.getData()).isEmpty())) {
            chain.add(p);
            p = p.parent;
        }
        if (p == nd.parent) {
            return false;
        }
        Area last = (Area)p.getData();
        int minx = 0;
        int miny = 0;
        if (node_centric) {
            first = first.createTransformedArea(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -nd.x, -nd.y));
            last = last.createTransformedArea(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -p.x, -p.y));
            Rectangle bfirst = first.getBounds();
            Rectangle blast = last.getBounds();
            minx = Math.min(bfirst.x, blast.x);
            miny = Math.min(bfirst.y, blast.y);
            AffineTransform rmtrans = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -minx, -miny);
            first = first.createTransformedArea(rmtrans);
            last = last.createTransformedArea(rmtrans);
        }
        Area[] as = !always_use_distance_map && first.isSingular() && last.isSingular() ? AreaUtils.singularInterpolation(first, last, chain.size()) : AreaUtils.manyToManyInterpolation(first, last, chain.size());
        for (Area interpolated : as) {
            Node target = (Node)chain.removeFirst();
            if (node_centric) {
                interpolated.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (float)minx + target.x, (float)miny + target.y));
            }
            target.setData(interpolated);
        }
        return true;
    }

    public boolean interpolateAllGaps(boolean node_centric, boolean always_use_distance_map) throws Exception {
        if (null == this.root) {
            return false;
        }
        HashMap<Node, Integer> m = new HashMap<Node, Integer>();
        Node.FilteredIterator<Area> it = new Node.FilteredIterator<Area>(this.root){

            @Override
            public boolean accept(Node<Area> node) {
                return null != node.getData() && !node.getData().isEmpty();
            }
        };
        while (((Node.NodeIterator)it).hasNext()) {
            Node node = (Node)it.next();
            if (null == node.parent) continue;
            LinkedList chain = new LinkedList();
            Node p = node.parent;
            while (null != p && (null == p.getData() || ((Area)p.getData()).isEmpty())) {
                chain.add(p);
                p = p.parent;
            }
            if (chain.isEmpty()) continue;
            m.put(node, chain.size());
        }
        ArrayList l = new ArrayList(m.entrySet());
        Collections.sort(l, new Comparator<Map.Entry<Node<Area>, Integer>>(){

            @Override
            public int compare(Map.Entry<Node<Area>, Integer> o1, Map.Entry<Node<Area>, Integer> o2) {
                return o1.getValue() - o2.getValue();
            }
        });
        boolean processed = false;
        for (Map.Entry e : l) {
            Node node = (Node)e.getKey();
            processed |= this.interpolateTowardsParent(node, node_centric, always_use_distance_map);
        }
        return processed;
    }

    public void addWorldAreaTo(Node<?> nd, Area a) {
        AreaNode an = (AreaNode)nd;
        if (null == an.aw) {
            an.getData();
        }
        an.aw.add(a, nd.la);
    }

    @Override
    protected Tree.MeasurementPair createMeasurementPair(Tree.NodePath np) {
        return new AreaMeasurementPair(np);
    }

    private class AreaMeasurementPair
    extends Tree.MeasurementPair {
        public AreaMeasurementPair(Tree.NodePath np) {
            super(AreaTree.this, np);
        }

        protected List<Area> calibratedData() {
            ArrayList<Area> data = new ArrayList<Area>();
            AffineTransform aff = new AffineTransform(AreaTree.this.at);
            Calibration cal = AreaTree.this.layer_set.getCalibration();
            aff.preConcatenate(new AffineTransform(cal.pixelWidth, 0.0, 0.0, cal.pixelHeight, 0.0, 0.0));
            for (Node nd : this.path) {
                Area a = (Area)nd.getData();
                if (null == a) {
                    data.add(null);
                }
                data.add(a.createTransformedArea(aff));
            }
            return data;
        }

        @Override
        public String getResultsTableTitle() {
            return "AreaTree tagged pairs";
        }

        @Override
        public ResultsTable toResultsTable(ResultsTable rt, int index, double scale, int resample) {
            if (null == rt) {
                String unit = AreaTree.this.layer_set.getCalibration().getUnit();
                rt = ini.trakem2.utils.Utils.createResultsTable(this.getResultsTableTitle(), new String[]{"id", "index", "length " + unit, "volume " + unit + "^3"});
            }
            rt.incrementCounter();
            rt.addValue(0, (double)AreaTree.this.id);
            rt.addValue(1, (double)index);
            rt.addValue(2, this.distance);
            CustomTriangleMesh mesh = new CustomTriangleMesh(this.createMesh((double)scale, (int)resample).verts);
            rt.addValue(3, (double)mesh.getVolume());
            return rt;
        }

        @Override
        public Tree.MeshData createMesh(double scale, int resample) {
            AreaTree sub = new AreaTree(AreaTree.this.project, -1L, "", AreaTree.this.width, AreaTree.this.height, AreaTree.this.alpha, true, AreaTree.this.color, false, new AffineTransform(AreaTree.this.at));
            sub.layer_set = AreaTree.this.layer_set;
            sub.root = (Node)this.path.get(0);
            sub.cacheSubtree(this.path);
            return sub.generateMesh(scale, resample);
        }
    }

    public static final class AreaNode
    extends Node<Area> {
        private AreaWrapper aw;

        public AreaNode(float lx, float ly, Layer la) {
            super(lx, ly, la);
        }

        public AreaNode(HashMap<String, String> attr) {
            super(attr);
        }

        @Override
        public final Node<Area> newInstance(float lx, float ly, Layer layer) {
            return new AreaNode(lx, ly, layer);
        }

        @Override
        public final synchronized boolean setData(Area area) {
            if (null == area) {
                if (null == this.aw) {
                    return true;
                }
                this.aw.getArea().reset();
            } else if (null != this.aw) {
                this.aw.putData(area);
            } else {
                this.aw = new AreaWrapper(area);
            }
            return true;
        }

        @Override
        public final synchronized Area getData() {
            if (null == this.aw) {
                this.aw = new AreaWrapper();
            }
            return this.aw.getArea();
        }

        @Override
        public final synchronized Area getDataCopy() {
            if (null == this.aw) {
                return null;
            }
            return new Area(this.aw.getArea());
        }

        @Override
        public final Area getArea() {
            if (null == this.aw) {
                return super.getArea();
            }
            Area a = this.aw.getArea();
            if (a.isEmpty()) {
                return super.getArea();
            }
            a.add(super.getArea());
            return a;
        }

        @Override
        public void paintData(Graphics2D g, Rectangle srcRect, Tree<Area> tree, AffineTransform to_screen, Color cc, Layer active_layer) {
            if (null == this.aw) {
                return;
            }
            if (!tree.layer_set.area_color_cues && active_layer != this.la) {
                return;
            }
            Composite oc = null;
            if (cc != tree.color) {
                oc = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, Math.min(tree.alpha, 0.25f)));
            }
            this.aw.paint(g, to_screen, ((AreaTree)tree).fill_paint, cc);
            if (null != oc) {
                g.setComposite(oc);
            }
        }

        @Override
        protected void paintHandle(Graphics2D g, Rectangle srcRect, double magnification, Tree<Area> t) {
            this.paintHandle(g, srcRect, magnification, t, true);
        }

        final boolean contains(float lx, float ly) {
            return null != this.aw && this.aw.getArea().contains(lx, ly);
        }

        @Override
        public boolean intersects(Area a) {
            if (null == this.aw) {
                return a.contains(this.x, this.y);
            }
            return M.intersects(a, this.aw.getArea());
        }

        @Override
        public boolean isRoughlyInside(Rectangle localbox) {
            if (null == this.aw) {
                return localbox.contains((int)this.x, (int)this.y);
            }
            if (this.aw.getArea().getBounds().intersects(localbox)) {
                return true;
            }
            return super.isRoughlyInside(localbox);
        }

        @Override
        public Collection<Displayable> findLinkTargets(AffineTransform aff) {
            if (null == this.aw) {
                return super.findLinkTargets(aff);
            }
            Area a = this.aw.getArea();
            if (!aff.isIdentity()) {
                a = a.createTransformedArea(aff);
            }
            return this.la.getDisplayables(Patch.class, a, true);
        }

        @Override
        public void apply(CoordinateTransform ct, Area roi) {
            super.apply(ct, roi);
            if (null == this.aw) {
                return;
            }
            M.apply(ct, roi, this.aw.getArea());
        }

        @Override
        public void apply(VectorDataTransform vlocal) {
            super.apply(vlocal);
            if (null == this.aw) {
                return;
            }
            M.apply(vlocal, this.aw.getArea());
        }

        @Override
        protected void transformData(AffineTransform aff) {
            if (null == this.aw) {
                return;
            }
            this.aw.getArea().transform(aff);
        }
    }
}

