/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mpicbg.models.CoordinateTransform;

public class Dissector
extends ZDisplayable
implements VectorData {
    private ArrayList<Item> al_items = new ArrayList();
    private Item item = null;
    private int index = -1;
    private Rectangle bbox = null;

    public Dissector(Project project, String title, double x, double y) {
        super(project, title, x, y);
    }

    public Dissector(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.visible = visible;
        this.alpha = alpha;
        this.color = color;
    }

    public Dissector(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id, ht, ht_links);
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        AffineTransform gt = null;
        Stroke stroke = null;
        AffineTransform aff = this.at;
        if (!"true".equals(this.getProject().getProperty("dissector_zoom"))) {
            gt = g.getTransform();
            g.setTransform(new AffineTransform());
            stroke = g.getStroke();
            g.setStroke(new BasicStroke(1.0f, 0, 0));
            aff = new AffineTransform(gt);
            aff.concatenate(this.at);
        }
        for (Item item : this.al_items) {
            item.paint(g, aff, active_layer);
        }
        if (null != gt) {
            g.setTransform(gt);
        }
        if (null != stroke) {
            g.setStroke(stroke);
        }
    }

    @Override
    public Layer getFirstLayer() {
        double min_z = Double.MAX_VALUE;
        Layer min_la = this.layer;
        for (Item item : this.al_items) {
            Layer la = item.getFirstLayer();
            if (null == la || !(la.getZ() < min_z)) continue;
            min_z = la.getZ();
            min_la = la;
        }
        return min_la;
    }

    @Override
    public boolean linkPatches() {
        if (0 == this.al_items.size()) {
            return false;
        }
        this.unlinkAll(Patch.class);
        boolean must_lock = false;
        for (Item item : this.al_items) {
            must_lock = item.linkPatches() || must_lock;
        }
        if (must_lock) {
            this.setLocked(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Layer layer, double x, double y) {
        long lid = layer.getId();
        Point2D.Double po = this.inverseTransformPoint(x, y);
        x = po.x;
        y = po.y;
        for (Item item : this.al_items) {
            if (-1 == item.find(lid, x, y, 1.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Displayable clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Dissector copy = new Dissector(pr, nid, this.title, this.width, this.height, this.alpha, this.visible, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()), this.locked, (AffineTransform)this.at.clone());
        for (Item item : this.al_items) {
            copy.al_items.add((Item)item.clone());
        }
        copy.addToDatabase();
        return copy;
    }

    @Override
    public boolean isDeletable() {
        return 0 == this.al_items.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent me, Layer la, int x_p, int y_p, double mag) {
        int tool = ProjectToolbar.getToolId();
        if (16 != tool) {
            return;
        }
        long lid = la.getId();
        if (!this.at.isIdentity()) {
            Iterator<Item> p = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)((Point2D.Double)((Object)p)).x;
            y_p = (int)((Point2D.Double)((Object)p)).y;
        }
        for (Item item : this.al_items) {
            this.index = item.find(lid, x_p, y_p, mag);
            if (-1 == this.index) continue;
            this.item = item;
            break;
        }
        if (me.isShiftDown() && Utils.isControlDown(me)) {
            if (-1 != this.index) {
                this.item.remove(this.index);
                if (0 == this.item.n_points) {
                    this.al_items.remove(this.item);
                }
                this.item = null;
                this.index = -1;
                Display.repaint(this.layer_set, (Displayable)this, 0);
            }
            return;
        }
        if (-1 != this.index) {
            return;
        }
        try {
            int n;
            for (Item item : this.al_items) {
                this.index = item.add(x_p, y_p, la);
                if (-1 == this.index) continue;
                this.item = item;
                return;
            }
            int max_tag = 0;
            for (Item tmp : this.al_items) {
                if (tmp.tag <= max_tag) continue;
                max_tag = tmp.tag;
            }
            int n2 = 8;
            if (this.al_items.size() > 0) {
                n = this.al_items.get((int)(this.al_items.size() - 1)).radius;
            }
            this.item = new Item(max_tag + 1, n, x_p, y_p, la);
            this.index = 0;
            this.al_items.add(this.item);
        }
        finally {
            if (null != this.item) {
                this.bbox = this.at.createTransformedShape(this.item.getBoundingBox()).getBounds();
                Display.repaint(this.layer_set, this.bbox);
            } else {
                Display.repaint(this.layer_set, (Displayable)this, 0);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        int tool = ProjectToolbar.getToolId();
        if (16 != tool) {
            return;
        }
        if (!this.at.isIdentity()) {
            Point2D.Double pd = this.inverseTransformPoint(x_d, y_d);
            x_d = (int)pd.x;
            y_d = (int)pd.y;
            Point2D.Double pdo = this.inverseTransformPoint(x_d_old, y_d_old);
            x_d_old = (int)pdo.x;
            y_d_old = (int)pdo.y;
        }
        if (-1 != this.index) {
            if (me.isShiftDown()) {
                this.item.radius = (int)Math.ceil(Math.sqrt(((double)x_d - this.item.p[0][this.index]) * ((double)x_d - this.item.p[0][this.index]) + ((double)y_d - this.item.p[1][this.index]) * ((double)y_d - this.item.p[1][this.index])));
                if (this.item.radius < 1) {
                    this.item.radius = 1;
                }
            } else {
                this.item.translate(this.index, x_d - x_d_old, y_d - y_d_old);
            }
            Rectangle repaint_bbox = this.bbox;
            Rectangle current_bbox = this.at.createTransformedShape(this.item.getBoundingBox()).getBounds();
            if (null == this.bbox) {
                repaint_bbox = current_bbox;
            } else {
                repaint_bbox = (Rectangle)this.bbox.clone();
                repaint_bbox.add(current_bbox);
            }
            this.bbox = current_bbox;
            Display.repaint(this.layer_set, repaint_bbox);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        this.item = null;
        this.index = -1;
        this.calculateBoundingBox(la, this.bbox);
    }

    @Override
    protected boolean calculateBoundingBox(Layer la) {
        return this.calculateBoundingBox(la, null);
    }

    private boolean calculateBoundingBox(Layer la, Rectangle box) {
        for (Item item : this.al_items) {
            if (null == box) {
                box = item.getBoundingBox();
                continue;
            }
            box.add(item.getBoundingBox());
        }
        if (null == box) {
            this.height = 0.0f;
            this.width = 0.0f;
            this.updateBucket(la);
            return true;
        }
        this.translate(box.x, box.y, false);
        this.width = box.width;
        this.height = box.height;
        if (0 != box.x || 0 != box.y) {
            for (Item item : this.al_items) {
                item.translateAll(-box.x, -box.y);
            }
        }
        this.updateBucket(la);
        return true;
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_dissector";
        if (hs.contains("t2_dissector")) {
            return;
        }
        hs.add("t2_dissector");
        sb_header.append(indent).append("<!ELEMENT t2_dissector (").append(Displayable.commonDTDChildren()).append(",t2_dd_item)>\n");
        Displayable.exportDTD("t2_dissector", sb_header, hs, indent);
        sb_header.append(indent).append("<!ELEMENT t2_dd_item EMPTY>\n").append(indent).append("<!ATTLIST t2_dd_item radius NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_dd_item tag NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_dd_item points NMTOKEN #REQUIRED>\n");
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        sb_body.append(indent).append("<t2_dissector\n");
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;\"\n");
        sb_body.append(indent).append(">\n");
        for (Item item : this.al_items) {
            item.exportXML(sb_body, in);
        }
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_dissector>\n");
    }

    public void addItem(int tag, int radius, String data) {
        this.al_items.add(new Item(tag, radius, data));
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder("title: ").append(this.title).append("\nitems: ").append(this.al_items.size()).append('\n').append("tag\tradius\tx\ty\tz\n");
        for (Item item : this.al_items) {
            item.putData(sb);
        }
        return sb.toString();
    }

    @Override
    public void paintSnapshot(Graphics2D g, Layer layer, List<Layer> layers, Rectangle srcRect, double mag) {
        this.paintAsBox(g);
    }

    @Override
    public boolean intersects(Area area, double z_first, double z_last) {
        Area ai;
        try {
            ai = area.createTransformedArea(this.at.createInverse());
        }
        catch (NoninvertibleTransformException nite) {
            nite.printStackTrace();
            return false;
        }
        for (Item item : this.al_items) {
            if (!item.intersects(ai, z_first, z_last)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (0 == this.al_items.size()) {
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Dissector results", new String[]{"id", "tag", "x", "y", "z", "radius", "nameid"});
        }
        for (Item item : this.al_items) {
            item.addResults(rt, this.layer_set.getCalibration(), this.getNameId());
        }
        return rt;
    }

    @Override
    Class<?> getInternalDataPackageClass() {
        return DPDissector.class;
    }

    @Override
    Object getDataPackage() {
        return new DPDissector(this);
    }

    @Override
    public synchronized boolean crop(List<Layer> range) {
        HashSet<Long> lids = new HashSet<Long>();
        for (Layer l : range) {
            lids.add(l.getId());
        }
        for (Item item : this.al_items) {
            for (int i = 0; i < item.n_points; ++i) {
                if (lids.contains(item.p_layer[i])) continue;
                item.remove(i);
                --i;
            }
        }
        this.calculateBoundingBox(null);
        return true;
    }

    @Override
    protected boolean layerRemoved(Layer la) {
        super.layerRemoved(la);
        for (Item item : this.al_items) {
            item.layerRemoved(la.getId());
        }
        return true;
    }

    @Override
    public boolean apply(Layer la, Area roi, CoordinateTransform ict) throws Exception {
        double[] fp = null;
        CoordinateTransform chain = null;
        Area localroi = null;
        AffineTransform inverse = null;
        for (Item item : this.al_items) {
            long[] p_layer = item.p_layer;
            double[][] p = item.p;
            for (int i = 0; i < item.n_points; ++i) {
                if (p_layer[i] != la.getId()) continue;
                if (null == localroi) {
                    inverse = this.at.createInverse();
                    localroi = roi.createTransformedArea(inverse);
                }
                if (!localroi.contains(p[0][i], p[1][i])) continue;
                if (null == chain) {
                    chain = M.wrap(this.at, ict, inverse);
                    fp = new double[2];
                }
                M.apply(chain, p, i, fp);
            }
        }
        if (null != chain) {
            this.calculateBoundingBox(la);
        }
        return true;
    }

    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        double[] fp = new double[2];
        VectorDataTransform vlocal = vdt.makeLocalTo(this);
        for (Item item : this.al_items) {
            block1: for (int i = 0; i < item.n_points; ++i) {
                if (vdt.layer.getId() != item.p_layer[i]) continue;
                for (VectorDataTransform.ROITransform rt : vlocal.transforms) {
                    if (!rt.roi.contains(item.p[0][i], item.p[1][i])) continue;
                    M.apply(rt.ct, item.p, i, fp);
                    continue block1;
                }
            }
        }
        this.calculateBoundingBox(vlocal.layer);
        return true;
    }

    @Override
    public synchronized Collection<Long> getLayerIds() {
        HashSet<Long> lids = new HashSet<Long>();
        for (Item item : this.al_items) {
            lids.addAll(Utils.asList(item.p_layer, 0, item.n_points));
        }
        return lids;
    }

    @Override
    public synchronized Area getAreaAt(Layer layer) {
        Area a = new Area();
        for (Item item : this.al_items) {
            for (int i = 0; i < item.n_points; ++i) {
                if (item.p_layer[i] != layer.getId()) continue;
                a.add(new Area(new Rectangle2D.Float((float)(item.p[0][i] - (double)item.radius), (float)(item.p[1][i] - (double)item.radius), item.radius, item.radius)));
            }
        }
        a.transform(this.at);
        return a;
    }

    private static final class DPDissector
    extends Displayable.DataPackage {
        final ArrayList<Item> items = new ArrayList();

        DPDissector(Dissector dissector) {
            super(dissector);
            for (Item item : dissector.al_items) {
                this.items.add((Item)item.clone());
            }
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            Dissector dissector = (Dissector)d;
            ArrayList<Item> m = new ArrayList<Item>();
            for (Item item : this.items) {
                m.add((Item)item.clone());
            }
            dissector.al_items = m;
            return true;
        }
    }

    private class Item {
        long[] p_layer;
        double[][] p;
        int n_points = 0;
        int tag;
        int radius;

        public Object clone() {
            Item copy = new Item();
            copy.tag = this.tag;
            copy.radius = this.radius;
            copy.n_points = this.n_points;
            copy.p = new double[2][this.p[0].length];
            System.arraycopy(this.p[0], 0, copy.p[0], 0, this.p[0].length);
            System.arraycopy(this.p[1], 0, copy.p[1], 0, this.p[1].length);
            copy.p_layer = new long[this.p_layer.length];
            System.arraycopy(this.p_layer, 0, copy.p_layer, 0, this.p_layer.length);
            return copy;
        }

        boolean intersects(Area area, double z_first, double z_last) {
            for (int i = 0; i < this.n_points; ++i) {
                Layer la = Dissector.this.layer_set.getLayer(this.p_layer[i]);
                if (!(la.getZ() >= z_first) || !(la.getZ() <= z_last)) continue;
                for (int k = 0; k < this.n_points; ++k) {
                    if (!area.contains(this.p[0][k], this.p[1][k])) continue;
                    return true;
                }
            }
            return false;
        }

        private Item() {
        }

        private Item(int tag, int radius) {
            this.tag = tag;
            this.radius = radius;
            this.p = new double[2][2];
            this.p_layer = new long[2];
        }

        Item(int tag, int radius, double x, double y, Layer layer) {
            this(tag, radius);
            this.add(x, y, layer);
        }

        Item(int tag, int radius, String data) {
            this(tag, radius);
            data = data.trim().replace('\n', ' ');
            data = data.substring(1, data.length() - 1);
            String[] si = data.split("] *\\[");
            for (int i = 0; i < si.length; ++i) {
                if (this.n_points == this.p[0].length) {
                    this.enlargeArrays();
                }
                int isp1 = si[i].indexOf(32);
                int isp2 = si[i].lastIndexOf(32);
                this.p[0][this.n_points] = Double.parseDouble(si[i].substring(0, isp1));
                this.p[1][this.n_points] = Double.parseDouble(si[i].substring(isp1 + 1, isp2));
                this.p_layer[this.n_points] = Long.parseLong(si[i].substring(isp2 + 1).trim());
                ++this.n_points;
            }
        }

        final int add(double x, double y, Layer layer) {
            long lid = layer.getId();
            if (0 == this.n_points) {
                this.p[0][0] = x;
                this.p[1][0] = y;
                this.p_layer[0] = lid;
                this.n_points = 1;
                return 0;
            }
            for (int i = 0; i < this.n_points; ++i) {
                if (lid != this.p_layer[i]) continue;
                return -1;
            }
            int il = Dissector.this.layer_set.indexOf(layer);
            if (Dissector.this.layer_set.indexOf(Dissector.this.layer_set.getLayer(this.p_layer[this.n_points - 1])) == il - 1) {
                if (!(this.p[0][this.n_points - 1] + (double)this.radius >= x && this.p[0][this.n_points - 1] - (double)this.radius <= x && this.p[1][this.n_points - 1] + (double)this.radius >= y && this.p[1][this.n_points - 1] - (double)this.radius <= y)) {
                    return -1;
                }
                if (this.n_points >= this.p[0].length) {
                    this.enlargeArrays();
                }
                this.p[0][this.n_points] = x;
                this.p[1][this.n_points] = y;
                this.p_layer[this.n_points] = lid;
                ++this.n_points;
                return this.n_points - 1;
            }
            if (Dissector.this.layer_set.indexOf(Dissector.this.layer_set.getLayer(this.p_layer[0])) == il + 1) {
                if (!(this.p[0][0] + (double)this.radius >= x && this.p[0][0] - (double)this.radius <= x && this.p[1][0] + (double)this.radius >= y && this.p[1][0] - (double)this.radius <= y)) {
                    return -1;
                }
                if (this.n_points >= this.p[0].length) {
                    this.enlargeArrays();
                }
                for (int i = this.n_points - 1; i > -1; --i) {
                    this.p[0][i + 1] = this.p[0][i];
                    this.p[1][i + 1] = this.p[1][i];
                    this.p_layer[i + 1] = this.p_layer[i];
                }
                this.p[0][0] = x;
                this.p[1][0] = y;
                this.p_layer[0] = lid;
                ++this.n_points;
                return 0;
            }
            return -1;
        }

        private final void enlargeArrays() {
            double[][] p2 = new double[2][this.n_points + 5];
            long[] l2 = new long[this.n_points + 5];
            System.arraycopy(this.p[0], 0, p2[0], 0, this.n_points);
            System.arraycopy(this.p[1], 0, p2[1], 0, this.n_points);
            System.arraycopy(this.p_layer, 0, l2, 0, this.n_points);
            this.p = p2;
            this.p_layer = l2;
        }

        final void paint(Graphics2D g, AffineTransform aff, Layer layer) {
            int i_current = Dissector.this.layer_set.indexOf(layer);
            int M_radius = this.radius;
            int EXTRA = 2;
            int paint_i = -1;
            for (int i = 0; i < this.n_points; ++i) {
                int ii = Dissector.this.layer_set.getLayerIndex(this.p_layer[i]);
                if (ii == i_current - 1) {
                    g.setColor(Color.red);
                } else {
                    if (ii == i_current) {
                        paint_i = i;
                        continue;
                    }
                    if (ii != i_current + 1) continue;
                    g.setColor(Color.blue);
                }
                Point2D.Double po = M.transform(aff, this.p[0][i], this.p[1][i]);
                int px = (int)po.x;
                int py = (int)po.y;
                g.drawOval(px - M_radius, py - M_radius, M_radius + M_radius, M_radius + M_radius);
                g.drawString(Integer.toString(this.tag), px + M_radius + 2, py + M_radius);
            }
            if (-1 != paint_i) {
                g.setColor(Dissector.this.color);
                Point2D.Double po = M.transform(aff, this.p[0][paint_i], this.p[1][paint_i]);
                int px = (int)po.x;
                int py = (int)po.y;
                g.drawRect(px - M_radius, py - M_radius, M_radius + M_radius, M_radius + M_radius);
                g.drawString(Integer.toString(this.tag), px + M_radius + 2, py + M_radius);
            }
        }

        final void addResults(ResultsTable rt, Calibration cal, double nameid) {
            for (int i = 0; i < this.n_points; ++i) {
                Layer la = Dissector.this.layer_set.getLayer(this.p_layer[i]);
                if (null == Dissector.this.layer) {
                    Utils.log("Dissector.addResults: could not find layer with id " + this.p_layer[i]);
                    continue;
                }
                Point2D.Double po = M.transform(Dissector.this.at, this.p[0][i], this.p[1][i]);
                rt.incrementCounter();
                rt.addLabel("units", cal.getUnit());
                rt.addValue(0, (double)Dissector.this.id);
                rt.addValue(1, (double)this.tag);
                rt.addValue(2, po.x * cal.pixelWidth);
                rt.addValue(3, po.y * cal.pixelHeight);
                rt.addValue(4, la.getZ() * cal.pixelWidth);
                rt.addValue(5, (double)this.radius * cal.pixelWidth);
                rt.addValue(6, nameid);
            }
        }

        final Layer getFirstLayer() {
            if (0 == this.n_points) {
                return null;
            }
            return Dissector.this.layer_set.getLayer(this.p_layer[0]);
        }

        final boolean linkPatches() {
            Rectangle r = new Rectangle();
            double[][] po = Dissector.this.transformPoints(this.p);
            boolean must_lock = false;
            for (int i = 0; i < this.n_points; ++i) {
                Layer la = Dissector.this.layer_set.getLayer(this.p_layer[0]);
                for (Displayable d : la.getDisplayables(Patch.class)) {
                    d.getBoundingBox(r);
                    if (!r.contains((int)po[0][i], (int)po[1][i])) continue;
                    Dissector.this.link(d, true);
                    must_lock = true;
                }
            }
            return must_lock;
        }

        final int find(long lid, double x, double y, double mag) {
            int radius = (int)((double)this.radius / mag);
            for (int i = 0; i < this.n_points; ++i) {
                if (lid != this.p_layer[i] || !(this.p[0][i] + (double)radius > x) || !(this.p[0][i] - (double)radius < x) || !(this.p[1][i] + (double)radius > y) || !(this.p[1][i] - (double)radius < y)) continue;
                return i;
            }
            return -1;
        }

        final void translate(int index, int dx, int dy) {
            double[] dArray = this.p[0];
            int n = index;
            dArray[n] = dArray[n] + (double)dx;
            double[] dArray2 = this.p[1];
            int n2 = index;
            dArray2[n2] = dArray2[n2] + (double)dy;
        }

        final void remove(int index) {
            for (int i = index; i < this.n_points - 1; ++i) {
                this.p[0][i] = this.p[0][i + 1];
                this.p[1][i] = this.p[1][i + 1];
                this.p_layer[i] = this.p_layer[i + 1];
            }
            --this.n_points;
        }

        final void layerRemoved(long lid) {
            for (int i = 0; i < this.n_points; ++i) {
                if (lid != this.p_layer[i]) continue;
                this.remove(i);
                --i;
            }
        }

        final Rectangle getBoundingBox() {
            int x1;
            int y1 = x1 = Integer.MAX_VALUE;
            int x2 = -x1;
            int y2 = -x1;
            for (int i = 0; i < this.n_points; ++i) {
                if (this.p[0][i] < (double)x1) {
                    x1 = (int)this.p[0][i];
                }
                if (this.p[1][i] < (double)y1) {
                    y1 = (int)this.p[1][i];
                }
                if (this.p[0][i] > (double)x2) {
                    x2 = (int)Math.ceil(this.p[0][i]);
                }
                if (!(this.p[1][i] > (double)y2)) continue;
                y2 = (int)Math.ceil(this.p[1][i]);
            }
            return new Rectangle(x1 - this.radius, y1 - this.radius, x2 - x1 + this.radius + this.radius, y2 - y1 + this.radius + this.radius);
        }

        final void translateAll(int dx, int dy) {
            int i = 0;
            while (i < this.n_points) {
                double[] dArray = this.p[0];
                int n = i;
                dArray[n] = dArray[n] + (double)dx;
                double[] dArray2 = this.p[1];
                int n2 = i++;
                dArray2[n2] = dArray2[n2] + (double)dy;
            }
        }

        final void exportXML(StringBuilder sb_body, String indent) {
            sb_body.append(indent).append("<t2_dd_item tag=\"").append(this.tag).append("\" radius=\"").append(this.radius).append("\" points=\"");
            for (int i = 0; i < this.n_points; ++i) {
                sb_body.append('[').append(this.p[0][i]).append(' ').append(this.p[1][i]).append(' ').append(this.p_layer[i]).append(']');
                if (this.n_points - 1 == i) continue;
                sb_body.append(' ');
            }
            sb_body.append("\" />\n");
        }

        final void putData(StringBuilder sb) {
            for (int i = 0; i < this.n_points; ++i) {
                sb.append(this.tag).append('\t').append(this.radius).append('\t').append(this.p[0][i]).append('\t').append(this.p[1][i]).append('\t').append(Dissector.this.layer_set.getLayer(this.p_layer[i]).getZ()).append('\n');
            }
        }
    }
}

