/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;

public class IntervalBoundingBox {
    public static <P extends RealLocalizable> RealInterval getBoundingBox(List<P> points) {
        assert (!points.isEmpty());
        RealLocalizable p0 = (RealLocalizable)points.get(0);
        int n = p0.numDimensions();
        double[] min = new double[n];
        p0.localize(min);
        double[] max = (double[])min.clone();
        for (RealLocalizable point : points) {
            for (int d = 0; d < n; ++d) {
                double p = point.getDoublePosition(d);
                if (p < min[d]) {
                    min[d] = p;
                    continue;
                }
                if (!(p > max[d])) continue;
                max[d] = p;
            }
        }
        return new FinalRealInterval(min, max);
    }

    public static List<RealLocalizable> getCorners(RealInterval interval) {
        ArrayList<RealLocalizable> corners = new ArrayList<RealLocalizable>();
        int n = interval.numDimensions();
        int[] tmp = new int[n];
        Arrays.fill(tmp, 2);
        LocalizingZeroMinIntervalIterator i = new LocalizingZeroMinIntervalIterator(tmp);
        while (i.hasNext()) {
            i.fwd();
            RealPoint p = new RealPoint(n);
            for (int d = 0; d < n; ++d) {
                p.setPosition(i.getIntPosition(d) == 0 ? interval.realMin(d) : interval.realMax(d), d);
            }
            corners.add(p);
        }
        return corners;
    }
}

