/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.plugin;

import bdv.export.ProgressWriter;
import java.io.IOException;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.in.JPEGReader;
import loci.formats.in.ZeissCZIReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.DiskCachedCellImgFactory;
import net.imglib2.cache.img.DiskCachedCellImgOptions;
import net.imglib2.cache.img.optional.CacheOptions;
import net.imglib2.img.Img;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.parallel.Parallelization;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.Intervals;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.PositiveInteger;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.inputimage.DatasetInputImage;
import sc.fiji.labkit.ui.plugin.ResolutionPyramidSource;
import sc.fiji.labkit.ui.plugin.ui.ImageSelectionDialog;
import sc.fiji.labkit.ui.utils.ParallelUtils;

public class CziOpener {
    private ProgressWriter progressWriter;

    public CziOpener(ProgressWriter progressWriter) {
        this.progressWriter = progressWriter;
    }

    public DatasetInputImage openWithDialog(String filename) {
        ImageSelectionDialog dialog = ImageSelectionDialog.show(CziOpener.initReader(filename));
        List<Integer> selectedSectionIndices = dialog.getSelectedSectionIndices();
        String labelingFilename = dialog.getLabelingFilename();
        OptionalInt series = CziOpener.selectSectionResolution(filename, selectedSectionIndices);
        if (series.isPresent()) {
            return this.openInputImage(filename, labelingFilename, selectedSectionIndices.get(0), series.getAsInt());
        }
        return CziOpener.openResolutionPyramid(filename, labelingFilename, selectedSectionIndices);
    }

    private static DatasetInputImage openResolutionPyramid(String filename, String labelingFilename, List<Integer> selectedSectionIndices) {
        int fullres = selectedSectionIndices.get(0);
        List pyramid = selectedSectionIndices.stream().map(series -> CziOpener.openCachedImage(filename, fullres, series)).collect(Collectors.toList());
        ResolutionPyramidSource<ARGBType> source = new ResolutionPyramidSource<ARGBType>(pyramid, new ARGBType(), "source");
        BdvShowable showable = BdvShowable.wrap(source);
        ImgPlus imageForSegmentation = (ImgPlus)pyramid.get(2);
        imageForSegmentation.setSource(filename);
        DatasetInputImage result = new DatasetInputImage(imageForSegmentation, showable);
        result.setDefaultLabelingFilename(labelingFilename);
        return result;
    }

    private DatasetInputImage openInputImage(String filename, String labelingFilename, int fullres, int series) {
        ImgPlus image = (ImgPlus)Parallelization.runMultiThreaded(() -> this.openImage(filename, fullres, series));
        DatasetInputImage result = new DatasetInputImage(image);
        result.setDefaultLabelingFilename(labelingFilename);
        return result;
    }

    private ImgPlus<ARGBType> openImage(String filename, int fullres, int series) {
        MyReader reader = new MyReader(filename);
        long[] dimensions = reader.getImgDimensions(series);
        int[] cellDimensions = reader.getCellDimensions(series);
        CellImg out = new CellImgFactory((NativeType)new ARGBType(), cellDimensions).create(dimensions);
        Consumer operation = cell -> reader.readToInterval(series, (RandomAccessibleInterval<ARGBType>)cell);
        ProgressWriter progressWriter = this.progressWriter;
        ParallelUtils.applyOperationOnCells(out, cellDimensions, operation, progressWriter);
        return CziOpener.imgPlus(filename, (Img<ARGBType>)out, reader.getCalibratedAxes(fullres, series));
    }

    public static ImgPlus<ARGBType> openCachedImage(String filename, int fullres, int series) {
        MyReader reader = new MyReader(filename);
        long[] dimensions = reader.getImgDimensions(series);
        int[] cellDimensions = reader.getCellDimensions(series);
        Img<ARGBType> image = CziOpener.setupCachedImage(cell -> reader.readToInterval(series, (RandomAccessibleInterval<ARGBType>)((RandomAccessibleInterval)cell)), new CellGrid(dimensions, cellDimensions), new ARGBType());
        return CziOpener.imgPlus(filename, image, reader.getCalibratedAxes(fullres, series));
    }

    private static <T extends NativeType<T>> Img<T> setupCachedImage(CellLoader<T> loader, CellGrid grid, T type) {
        DiskCachedCellImgOptions optional = (DiskCachedCellImgOptions)((DiskCachedCellImgOptions)DiskCachedCellImgOptions.options().cellDimensions(CziOpener.getCellDimensions(grid))).cacheType(CacheOptions.CacheType.SOFTREF);
        DiskCachedCellImgFactory factory = new DiskCachedCellImgFactory(type, optional);
        return factory.create(grid.getImgDimensions(), loader);
    }

    private static int[] getCellDimensions(CellGrid grid) {
        int[] cellDimensions = new int[grid.numDimensions()];
        grid.cellDimensions(cellDimensions);
        return cellDimensions;
    }

    private static ImgPlus<ARGBType> imgPlus(String filename, Img<ARGBType> out, CalibratedAxis[] axis) {
        ImgPlus imgPlus = new ImgPlus(out, filename, axis);
        imgPlus.setSource(filename);
        return imgPlus;
    }

    private static OptionalInt selectSectionResolution(String filename, List<Integer> sectionIds) {
        List<String> list = CziOpener.listResolutions(filename, sectionIds);
        String pyramid = "Resolution Pyramid";
        Object[] options = Stream.concat(Stream.of(pyramid), list.stream()).toArray();
        Object result = JOptionPane.showInputDialog(null, "Select Image Resolution", "Labkit - Import Image", -1, null, options, list.get(0));
        if (result == null) {
            throw new CancellationException();
        }
        if (result.equals(pyramid)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(sectionIds.get(list.indexOf(result)));
    }

    private static List<String> listResolutions(String filename, List<Integer> sectionIds) {
        ImageReader reader = CziOpener.initReader(filename);
        return sectionIds.stream().map(series -> {
            reader.setSeries(series.intValue());
            return reader.getSizeX() + " x " + reader.getSizeY();
        }).collect(Collectors.toList());
    }

    private static ImageReader initReader(String filename) {
        ImageReader reader = CziOpener.initReader();
        CziOpener.readerSetFile(reader, filename);
        return reader;
    }

    private static ValuePair<ImageReader, IMetadata> initReaderAndMetaData(String filename) {
        ImageReader reader = CziOpener.initReader();
        IMetadata metadata = MetadataTools.createOMEXMLMetadata();
        reader.setMetadataStore((MetadataStore)metadata);
        CziOpener.readerSetFile(reader, filename);
        return new ValuePair((Object)reader, (Object)metadata);
    }

    private static void readerSetFile(ImageReader reader, String filename) {
        try {
            reader.setId(filename);
        }
        catch (IOException | FormatException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImageReader initReader() {
        ClassList cl = new ClassList(IFormatReader.class);
        cl.addClass(JPEGReader.class);
        cl.addClass(ZeissCZIReader.class);
        return new ImageReader(cl);
    }

    private static class MyReader {
        private final ImageReader reader;
        private final IMetadata metadata;

        public MyReader(String filename) {
            ValuePair readerAndMetaData = CziOpener.initReaderAndMetaData(filename);
            this.reader = (ImageReader)readerAndMetaData.getA();
            this.metadata = (IMetadata)readerAndMetaData.getB();
        }

        private ImageReader getReader(int series) {
            ImageReader reader = this.reader;
            reader.setSeries(series);
            return reader;
        }

        private long[] getImgDimensions(int series) {
            ImageReader reader = this.getReader(series);
            return new long[]{reader.getSizeX(), reader.getSizeY()};
        }

        private int[] getCellDimensions(int series) {
            ImageReader reader = this.getReader(series);
            return new int[]{reader.getOptimalTileWidth(), reader.getOptimalTileHeight()};
        }

        private void readToInterval(int series, RandomAccessibleInterval<ARGBType> interval) {
            try {
                int[] min = Intervals.minAsIntArray(interval);
                int[] size = Intervals.dimensionsAsIntArray(interval);
                ImageReader reader = this.getReader(series);
                byte[] bytes = reader.openBytes(0, min[0], min[1], size[0], size[1]);
                Cursor cursor = Views.flatIterable(interval).cursor();
                int index = 0;
                while (cursor.hasNext()) {
                    int color = ARGBType.rgba((int)bytes[index], (int)bytes[index + 1], (int)bytes[index + 2], (int)255);
                    ((ARGBType)cursor.next()).set(color);
                    index += 3;
                }
            }
            catch (IOException | FormatException e) {
                throw new RuntimeException(e);
            }
        }

        private CalibratedAxis[] getCalibratedAxes(int fullres, int series) {
            CalibratedAxis[] calibratedAxisArray = new CalibratedAxis[2];
            calibratedAxisArray[0] = MyReader.initAxis(Axes.X, fullres, series, arg_0 -> ((IMetadata)this.metadata).getPixelsPhysicalSizeX(arg_0), arg_0 -> ((IMetadata)this.metadata).getPixelsSizeX(arg_0));
            calibratedAxisArray[1] = MyReader.initAxis(Axes.Y, fullres, series, arg_0 -> ((IMetadata)this.metadata).getPixelsPhysicalSizeY(arg_0), arg_0 -> ((IMetadata)this.metadata).getPixelsSizeY(arg_0));
            return calibratedAxisArray;
        }

        private static DefaultLinearAxis initAxis(AxisType axisType, int fullres, int series, IntFunction<Length> pixelSize, IntFunction<PositiveInteger> imageSize) {
            double fullResolutionPixelSize = pixelSize.apply(fullres).value(UNITS.MICROMETER).doubleValue();
            int fullResolutionImageSize = (Integer)imageSize.apply(fullres).getValue();
            int lowResolutionImageSize = (Integer)imageSize.apply(series).getValue();
            double lowResolutionPixelSize = fullResolutionPixelSize * MyReader.getScale(fullResolutionImageSize, lowResolutionImageSize);
            return new DefaultLinearAxis(axisType, "microm", lowResolutionPixelSize);
        }

        private static double getScale(int fullSize, int downscaledSize) {
            long integerScale = fullSize / downscaledSize;
            if ((long)fullSize / integerScale == (long)downscaledSize) {
                return integerScale;
            }
            return (double)fullSize / (double)downscaledSize;
        }
    }
}

