/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.io.InputStream;
import java.net.URL;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.MediaContainerRetained;
import org.jogamp.java3d.NodeComponent;

public class MediaContainer
extends NodeComponent {
    public static final int ALLOW_CACHE_READ = 0;
    public static final int ALLOW_CACHE_WRITE = 1;
    public static final int ALLOW_URL_READ = 2;
    public static final int ALLOW_URL_WRITE = 3;
    private static final int[] readCapabilities = new int[]{0, 2};

    public MediaContainer() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public MediaContainer(String path) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((MediaContainerRetained)this.retained).setURLString(path);
    }

    public MediaContainer(URL url) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((MediaContainerRetained)this.retained).setURLObject(url);
    }

    public MediaContainer(InputStream stream) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((MediaContainerRetained)this.retained).setInputStream(stream);
    }

    @Override
    void createRetained() {
        this.retained = new MediaContainerRetained();
        this.retained.setSource(this);
    }

    public void setCacheEnable(boolean flag) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer1"));
        }
        ((MediaContainerRetained)this.retained).setCacheEnable(flag);
    }

    public boolean getCacheEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer2"));
        }
        return ((MediaContainerRetained)this.retained).getCacheEnable();
    }

    public void setURL(String path) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer3"));
        }
        ((MediaContainerRetained)this.retained).setURLString(path);
    }

    public void setURL(URL url) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer3"));
        }
        ((MediaContainerRetained)this.retained).setURLObject(url);
    }

    public void setURLString(String path) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer3"));
        }
        ((MediaContainerRetained)this.retained).setURLString(path);
    }

    public void setURLObject(URL url) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer3"));
        }
        ((MediaContainerRetained)this.retained).setURLObject(url);
    }

    public void setInputStream(InputStream stream) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer3"));
        }
        ((MediaContainerRetained)this.retained).setInputStream(stream);
    }

    public String getURL() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer4"));
        }
        return ((MediaContainerRetained)this.retained).getURLString();
    }

    public String getURLString() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer4"));
        }
        return ((MediaContainerRetained)this.retained).getURLString();
    }

    public URL getURLObject() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer4"));
        }
        return ((MediaContainerRetained)this.retained).getURLObject();
    }

    public InputStream getInputStream() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("MediaContainer4"));
        }
        return ((MediaContainerRetained)this.retained).getInputStream();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        MediaContainer mc = new MediaContainer();
        mc.duplicateNodeComponent(this);
        return mc;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        MediaContainerRetained mc = (MediaContainerRetained)originalNodeComponent.retained;
        MediaContainerRetained rt = (MediaContainerRetained)this.retained;
        rt.setCacheEnable(mc.getCacheEnable());
        rt.setURLString(mc.getURLString(), false);
        rt.setURLObject(mc.getURLObject(), false);
        rt.setInputStream(mc.getInputStream(), false);
    }
}

