/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocPXMinusY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.DifferenceEntropy.class, label="Haralick: Difference Entropy")
public class DefaultDifferenceEntropy<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.DifferenceEntropy {
    private static final double EPSILON = Double.MIN_NORMAL;
    private UnaryFunctionOp<double[][], double[]> coocPXMinusYFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocPXMinusYFunc = Functions.unary(this.ops(), CoocPXMinusY.class, double[].class, double[][].class, new Object[0]);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double[] pxminusy = this.coocPXMinusYFunc.calculate(matrix);
        int nrGrayLevels = matrix.length;
        double res = 0.0;
        for (int k = 0; k < nrGrayLevels; ++k) {
            res += pxminusy[k] * Math.log(pxminusy[k] + Double.MIN_NORMAL);
        }
        output.set(-res);
    }
}

