/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d.mesh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imagej.ops.geom.geom3d.mesh.Facet;
import net.imagej.ops.geom.geom3d.mesh.UpdateablePointSet;
import net.imagej.ops.geom.geom3d.mesh.Vertex;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class TriangularFacet
extends UpdateablePointSet<TriangularFacet>
implements Facet {
    private Vector3D centroid = null;
    private Vector3D normal = null;
    private double area = -1.0;
    private List<Vertex> verticesInFront;

    public TriangularFacet() {
        this.vertices = new ArrayList();
        this.verticesInFront = new ArrayList<Vertex>();
    }

    public TriangularFacet(Vertex v0, Vertex v1, Vertex v2) {
        this.vertices = new ArrayList();
        this.vertices.add(v0);
        this.vertices.add(v1);
        this.vertices.add(v2);
        this.verticesInFront = new ArrayList<Vertex>();
        this.neighbors = new ArrayList();
    }

    public double getArea() {
        if (this.area == -1.0) {
            this.computeArea();
        }
        return this.area;
    }

    private void computeArea() {
        Vector3D cross = ((Vertex)((Object)this.vertices.get(0))).subtract((Vector)this.vertices.get(1)).crossProduct((Vector)((Vertex)((Object)this.vertices.get(2))).subtract((Vector)this.vertices.get(0)));
        this.area = cross.getNorm() * 0.5;
    }

    public Vector3D getCentroid() {
        if (this.centroid == null) {
            this.computeCentroid();
        }
        return this.centroid;
    }

    private void computeCentroid() {
        this.centroid = Vector3D.ZERO;
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            this.centroid = this.centroid.add((Vector)it.next());
        }
        this.centroid = this.centroid.scalarMultiply(1.0 / (double)this.vertices.size());
    }

    public Vector3D getNormal() {
        if (this.normal == null) {
            this.computeNormal();
        }
        return this.normal;
    }

    private void computeNormal() {
        Vector3D v0 = (Vector3D)this.vertices.get(0);
        Vector3D v1 = (Vector3D)this.vertices.get(1);
        Vector3D v2 = (Vector3D)this.vertices.get(2);
        this.normal = v1.subtract((Vector)v0).crossProduct((Vector)v2.subtract((Vector)v0));
    }

    public double getPlaneOffset() {
        return this.getNormal().normalize().dotProduct((Vector)this.getCentroid());
    }

    public double distanceToPlane(Vector3D p) {
        return this.getNormal().normalize().dotProduct((Vector)p) - this.getPlaneOffset();
    }

    public void setVertexInFront(Vertex v, double distanceToPlane) {
        if (this.verticesInFront.isEmpty()) {
            v.setDistanceToFaceInFront(distanceToPlane);
            this.verticesInFront.add(v);
        } else if (this.verticesInFront.get(0).getDistanceToFaceInFront() < distanceToPlane) {
            v.setDistanceToFaceInFront(distanceToPlane);
            this.verticesInFront.add(0, v);
        } else {
            this.verticesInFront.add(v);
        }
    }

    public List<Vertex> getVerticesInFront() {
        return this.verticesInFront;
    }

    public Vertex getMaximumDistanceVertex() {
        return this.verticesInFront.remove(0);
    }

    public Vertex getP0() {
        return (Vertex)((Object)this.vertices.get(0));
    }

    public Vertex getP1() {
        return (Vertex)((Object)this.vertices.get(1));
    }

    public Vertex getP2() {
        return (Vertex)((Object)this.vertices.get(2));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.area);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.centroid == null ? 0 : this.centroid.hashCode());
        result = 31 * result + (this.neighbors == null ? 0 : this.neighbors.hashCode());
        result = 31 * result + (this.normal == null ? 0 : this.normal.hashCode());
        result = 31 * result + (this.verticesInFront == null ? 0 : this.verticesInFront.hashCode());
        result = 31 * result + (this.vertices == null ? 0 : this.vertices.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriangularFacet other = (TriangularFacet)obj;
        if (Double.doubleToLongBits(this.area) != Double.doubleToLongBits(other.area)) {
            return false;
        }
        if (this.centroid == null ? other.centroid != null : !this.centroid.equals((Object)other.centroid)) {
            return false;
        }
        if (this.neighbors == null ? other.neighbors != null : !this.neighbors.equals(other.neighbors)) {
            return false;
        }
        if (this.normal == null ? other.normal != null : !this.normal.equals((Object)other.normal)) {
            return false;
        }
        if (this.verticesInFront == null ? other.verticesInFront != null : !this.verticesInFront.equals(other.verticesInFront)) {
            return false;
        }
        return !(this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices));
    }
}

