/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;
import sc.fiji.labkit.pixel_classification.gson.GsonUtils;
import sc.fiji.labkit.pixel_classification.gui.FiltersPanel;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.GroupedFeatures;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.SingleFeatures;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.ChannelSetting;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSettings;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class FeatureSettingsUI
extends JPanel {
    private GlobalsPanel globalsPanel;
    private FiltersPanel filtersPanel;

    public FeatureSettingsUI(Context context, FeatureSettings featureSettings) {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.globalsPanel = new GlobalsPanel(featureSettings.globals());
        this.add((Component)this.globalsPanel, "wrap");
        this.filtersPanel = new FiltersPanel(context, featureSettings);
        this.add((Component)new JScrollPane(this.filtersPanel, 22, 30), "split 2, grow");
    }

    public FeatureSettings get() {
        return new FeatureSettings(this.globalsPanel.get(), this.filtersPanel.getSelectedFeatureSettings());
    }

    public static Optional<FeatureSettings> show(Context context, FeatureSettings featureSettings) {
        FeatureSettingsUI ui = new FeatureSettingsUI(context, featureSettings);
        boolean ok = FeatureSettingsUI.showResizeableOkCancelDialog("Select Pixel Features", ui);
        if (ok) {
            FeatureSettings features = ui.get();
            return Optional.of(features);
        }
        return Optional.empty();
    }

    private static boolean showResizeableOkCancelDialog(String title, JPanel content) {
        JDialog dialog = new JDialog((Frame)null, title, true);
        JOptionPane optionPane = new JOptionPane(content, -1, 2);
        dialog.setContentPane(optionPane);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setPreferredSize(new Dimension(800, 650));
        optionPane.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();
            if (dialog.isVisible() && e.getSource() == optionPane && "value".equals(prop)) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        return optionPane.getValue().equals(0);
    }

    public static void main(String ... args) {
        FeatureSettings featureSettings = new FeatureSettings(GlobalSettings.default2d().build(), SingleFeatures.identity(), SingleFeatures.differenceOfGaussians(3.0, 4.5), GroupedFeatures.hessian());
        Optional<FeatureSettings> result = FeatureSettingsUI.show(new Context(), featureSettings);
        System.out.println(result.map(f -> GsonUtils.toString(f.toJson())));
    }

    private static class ListOfDoubleFormatter
    extends JFormattedTextField.AbstractFormatter {
        private ListOfDoubleFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return Stream.of(text.split(";")).map(Double::new).collect(Collectors.toList());
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return "";
            }
            List list = (List)value;
            StringJoiner joiner = new StringJoiner("; ");
            list.stream().map(Object::toString).forEach(joiner::add);
            return joiner.toString();
        }
    }

    public class GlobalsPanel
    extends JPanel {
        private final ChannelSetting channelSetting;
        private final JComboBox<String> dimensionsField;
        private final JFormattedTextField sigmasField;

        public GlobalsPanel(GlobalSettings globalSettings) {
            this.channelSetting = globalSettings.channelSetting();
            this.setLayout((LayoutManager)new MigLayout("insets 0", "[]20pt[200pt]", "[][][]"));
            this.add(new JLabel("Dimensions:"));
            this.dimensionsField = new JComboBox<String>(new String[]{"2D", "3D"});
            this.dimensionsField.setSelectedItem(globalSettings.numDimensions() + "D");
            this.dimensionsField.addActionListener(this::dimensionsChanged);
            this.add(this.dimensionsField, "wrap");
            this.add(new JLabel("List of sigmas:"));
            this.sigmasField = new JFormattedTextField(new ListOfDoubleFormatter());
            this.sigmasField.setColumns(50);
            this.sigmasField.setValue(globalSettings.sigmas());
            this.add((Component)this.sigmasField, "grow, wrap");
        }

        GlobalSettings get() {
            return ((GlobalSettings.Builder)((GlobalSettings.Builder)((GlobalSettings.Builder)GlobalSettings.default2d().channels(this.channelSetting)).dimensions(this.dimensionsField.getSelectedIndex() + 2)).sigmas((List)this.sigmasField.getValue())).build();
        }

        private void dimensionsChanged(ActionEvent e) {
            FeatureSettingsUI.this.filtersPanel.setGlobalSetting(this.get());
        }
    }
}

