/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.DimensionSwapperMetadata;
import io.scif.filters.Filter;
import io.scif.filters.MetadataWrapper;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Filter.class)
public class DimensionSwapper
extends AbstractReaderFilter {
    private List<AxisType> inputOrder;

    public DimensionSwapper() {
        super((Class<? extends MetadataWrapper>)DimensionSwapperMetadata.class);
    }

    public void swapDimensions(int imageIndex, AxisType ... newOrder) {
        if (newOrder == null) {
            throw new IllegalArgumentException("order is null");
        }
        List<AxisType> oldOrder = this.getDimensionOrder(imageIndex);
        if (newOrder.length != oldOrder.size()) {
            throw new IllegalArgumentException("newOrder is unexpected length: " + newOrder.length + "; expected: " + oldOrder.size());
        }
        for (AxisType axisType : newOrder) {
            if (oldOrder.contains(axisType)) continue;
            throw new IllegalArgumentException("newOrder specifies different axes");
        }
        if (this.metaCheck() && ((DimensionSwapperMetadata)this.getMetadata()).getOutputOrder() != null) {
            ((DimensionSwapperMetadata)this.getMetadata()).getOutputOrder()[imageIndex] = this.getInputOrder(imageIndex);
        }
        this.getMetadata().get(imageIndex).setAxisTypes(newOrder);
    }

    public void setOutputOrder(int imageIndex, List<AxisType> outputOrder) {
        if (this.metaCheck() && ((DimensionSwapperMetadata)this.getMetadata()).getOutputOrder() != null) {
            ((DimensionSwapperMetadata)this.getMetadata()).getOutputOrder()[imageIndex] = outputOrder;
        }
    }

    public List<AxisType> getInputOrder(int imageIndex) {
        if (this.inputOrder == null) {
            this.inputOrder = new ArrayList<AxisType>();
        }
        List<CalibratedAxis> axes = this.getMetadata().get(imageIndex).getAxes();
        for (int i = 0; i < axes.size(); ++i) {
            this.inputOrder.set(i, axes.get(i).type());
        }
        return this.inputOrder;
    }

    public List<AxisType> getDimensionOrder(int imageIndex) {
        List<AxisType> outOrder = null;
        if (this.metaCheck()) {
            outOrder = ((DimensionSwapperMetadata)this.getMetadata()).getOutputOrder()[imageIndex];
        }
        if (outOrder != null) {
            return outOrder;
        }
        return this.getInputOrder(imageIndex);
    }

    @Override
    protected void setSourceHelper(Location source, SCIFIOConfig config) {
        Location oldFile = this.getCurrentLocation();
        if (!source.equals(oldFile) || this.metaCheck() && (((DimensionSwapperMetadata)this.getMetadata()).getOutputOrder() == null || ((DimensionSwapperMetadata)this.getMetadata()).getOutputOrder().length != this.getImageCount())) {
            ArrayList[] axisTypeList = new ArrayList[this.getImageCount()];
            ((DimensionSwapperMetadata)this.getMetadata()).setOutputOrder(axisTypeList);
            if (this.metaCheck()) {
                ((DimensionSwapperMetadata)this.getMetadata()).wrap(((Reader)this.getParent()).getMetadata());
            }
        }
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        return super.openPlane(imageIndex, this.reorder(imageIndex, planeIndex), config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        return super.openPlane(imageIndex, this.reorder(imageIndex, planeIndex), bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        return super.openPlane(imageIndex, this.reorder(imageIndex, planeIndex), plane, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        return super.openPlane(imageIndex, this.reorder(imageIndex, planeIndex), plane, bounds, config);
    }

    @Override
    public Metadata getMetadata() {
        return super.getMetadata();
    }

    public double getPriority() {
        return 4.0;
    }

    private long reorder(int imageIndex, long planeIndex) {
        if (!this.metaCheck()) {
            return planeIndex;
        }
        long[] originalPosition = FormatTools.rasterToPosition(this.getMetadata().get(imageIndex).getAxesLengthsNonPlanar(), planeIndex);
        List<AxisType> swappedOrder = this.getDimensionOrder(imageIndex);
        long[] swappedPosition = new long[originalPosition.length];
        long[] lengths = new long[originalPosition.length];
        for (int i = 0; i < originalPosition.length; ++i) {
            int offset = this.getMetadata().get(imageIndex).getPlanarAxisCount();
            AxisType type = swappedOrder.get(i + offset);
            lengths[i] = this.getMetadata().get(imageIndex).getAxisLength(type);
            swappedPosition[i] = originalPosition[this.getMetadata().get(imageIndex).getAxisIndex(type) - offset];
        }
        return (int)FormatTools.positionToRaster(lengths, swappedPosition);
    }
}

