/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.RotPosScalePathInterpolator;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.PathInterpolatorState;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Quat4f;

public class RotPosScalePathInterpolatorState
extends PathInterpolatorState {
    private Point3f[] positions;
    private Quat4f[] quats;
    private float[] scales;

    public RotPosScalePathInterpolatorState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        int i;
        super.writeConstructorParams(out);
        this.positions = new Point3f[this.knots.length];
        this.quats = new Quat4f[this.knots.length];
        this.scales = new float[this.knots.length];
        for (i = 0; i < this.positions.length; ++i) {
            this.positions[i] = new Point3f();
            this.quats[i] = new Quat4f();
        }
        ((RotPosScalePathInterpolator)this.node).getPositions(this.positions);
        ((RotPosScalePathInterpolator)this.node).getQuats(this.quats);
        ((RotPosScalePathInterpolator)this.node).getScales(this.scales);
        for (i = 0; i < this.positions.length; ++i) {
            this.control.writePoint3f(out, this.positions[i]);
            this.control.writeQuat4f(out, this.quats[i]);
            out.writeFloat(this.scales[i]);
        }
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.positions = new Point3f[this.knots.length];
        this.quats = new Quat4f[this.knots.length];
        this.scales = new float[this.knots.length];
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = this.control.readPoint3f(in);
            this.quats[i] = this.control.readQuat4f(in);
            this.scales[i] = in.readFloat();
        }
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Alpha.class, TransformGroup.class, Transform3D.class, this.knots.getClass(), this.quats.getClass(), this.positions.getClass(), this.scales.getClass()}, new Object[]{null, null, new Transform3D(), this.knots, this.quats, this.positions, this.scales});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new RotPosScalePathInterpolator(null, null, new Transform3D(), this.knots, this.quats, this.positions, this.scales);
    }
}

