/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.QuaternionFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.QuaternionAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.Scalar;

public class QuaternionArray
extends ScalarArray<Quaternion> {
    public static final DenseArray.Factory<Quaternion> FACTORY = new DenseArray.Factory<Quaternion>(){

        @Override
        public AggregatorSet<Quaternion> aggregator() {
            return QuaternionAggregator.getSet();
        }

        @Override
        public FunctionSet<Quaternion> function() {
            return QuaternionFunction.getSet();
        }

        @Override
        public Scalar.Factory<Quaternion> scalar() {
            return Quaternion.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<Quaternion> make(long size) {
            return QuaternionArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(Quaternion.class);

    public static final QuaternionArray make(int size) {
        return new QuaternionArray(size);
    }

    public static final QuaternionArray wrap(Quaternion ... data) {
        return new QuaternionArray(data);
    }

    protected QuaternionArray(int size) {
        super(FACTORY, size);
    }

    protected QuaternionArray(Quaternion[] data) {
        super(FACTORY, (Number[])data);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof QuaternionArray) {
            return Arrays.equals(this.data, ((QuaternionArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

