/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.util.List;
import java.util.function.Supplier;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Factory2D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.algebra.Operation;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public interface BasicMatrix
extends Access2D<Number>,
Access2D.Elements,
Access2D.Aggregatable<Number>,
Structure2D.ReducibleTo1D<BasicMatrix>,
NormedVectorSpace<BasicMatrix, Number>,
Operation.Subtraction<BasicMatrix>,
Operation.Multiplication<BasicMatrix>,
ScalarOperation.Addition<BasicMatrix, Number>,
ScalarOperation.Division<BasicMatrix, Number>,
ScalarOperation.Subtraction<BasicMatrix, Number> {
    public static double calculateFrobeniusNorm(BasicMatrix matrix) {
        return matrix.norm();
    }

    public static double calculateInfinityNorm(BasicMatrix matrix) {
        double retVal = PrimitiveMath.ZERO;
        long tmpLimit = matrix.countRows();
        for (long i = 0L; i < tmpLimit; ++i) {
            retVal = PrimitiveFunction.MAX.invoke(retVal, ((Number)matrix.aggregateRow(i, Aggregator.NORM1)).doubleValue());
        }
        return retVal;
    }

    public static double calculateOneNorm(BasicMatrix matrix) {
        double retVal = PrimitiveMath.ZERO;
        long tmpLimit = matrix.countColumns();
        for (long j = 0L; j < tmpLimit; ++j) {
            retVal = PrimitiveFunction.MAX.invoke(retVal, ((Number)matrix.aggregateColumn(j, Aggregator.NORM1)).doubleValue());
        }
        return retVal;
    }

    public BasicMatrix add(int var1, int var2, Access2D<?> var3);

    public Builder<? extends BasicMatrix> copy();

    public BasicMatrix divideElements(Access2D<?> var1);

    public BasicMatrix enforce(NumberContext var1);

    public boolean equals(Access2D<?> var1, NumberContext var2);

    public void flushCache();

    public BasicMatrix getColumnsRange(int var1, int var2);

    @Deprecated
    public Scalar<?> getCondition();

    public Scalar<?> getDeterminant();

    @Deprecated
    public List<ComplexNumber> getEigenvalues();

    @Deprecated
    public int getRank();

    public BasicMatrix getRowsRange(int var1, int var2);

    @Deprecated
    public List<? extends Number> getSingularValues();

    public Scalar<?> getTrace();

    public BasicMatrix invert();

    @Deprecated
    public boolean isFullRank();

    public boolean isHermitian();

    public boolean isSymmetric();

    public BasicMatrix mergeColumns(Access2D<?> var1);

    public BasicMatrix mergeRows(Access2D<?> var1);

    @Deprecated
    public BasicMatrix modify(UnaryFunction<? extends Number> var1);

    public BasicMatrix multiplyElements(Access2D<?> var1);

    public BasicMatrix selectColumns(int ... var1);

    public BasicMatrix selectRows(int ... var1);

    public BasicMatrix solve(Access2D<?> var1);

    public Scalar<?> toScalar(long var1, long var3);

    @Deprecated
    default public String toString(int row, int col) {
        return this.toScalar(row, col).toString();
    }

    public BasicMatrix transpose();

    public static interface Factory<I extends BasicMatrix>
    extends Factory2D<I> {
        public Builder<I> getBuilder(int var1);

        public Builder<I> getBuilder(int var1, int var2);
    }

    public static interface Builder<I extends BasicMatrix>
    extends Mutate2D,
    Supplier<I> {
        default public I build() {
            return (I)((BasicMatrix)this.get());
        }
    }
}

