/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.queryXML;

import ij.ImageJ;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.queryXML.GenericLoadParseQueryXML;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.XmlIoSpimData2;

public class LoadParseQueryXML
extends GenericLoadParseQueryXML<SpimData2, SequenceDescription, ViewSetup, ViewDescription, ImgLoader, XmlIoSpimData2> {
    public LoadParseQueryXML() {
        super(new XmlIoSpimData2(""));
    }

    public boolean queryXML(String additionalTitle, boolean askForAngles, boolean askForChannels, boolean askForIllum, boolean askForTimepoints) {
        return this.queryXML(additionalTitle, "Process", askForAngles, askForChannels, askForIllum, askForTimepoints);
    }

    public boolean queryXML(boolean askForAngles, boolean askForChannels, boolean askForIllum, boolean askForTimepoints) {
        return this.queryXML("", "Process", askForAngles, askForChannels, askForIllum, askForTimepoints);
    }

    public boolean queryXML(String additionalTitle, String query, boolean askForAngles, boolean askForChannels, boolean askForIllum, boolean askForTimepoints) {
        ArrayList<String> specifyAttributes = new ArrayList<String>();
        if (askForTimepoints) {
            specifyAttributes.add("Timepoint");
        }
        if (askForChannels) {
            specifyAttributes.add("channel");
        }
        if (askForAngles) {
            specifyAttributes.add("angle");
        }
        if (askForIllum) {
            specifyAttributes.add("illumination");
        }
        return this.queryXML(additionalTitle, query, specifyAttributes);
    }

    @Override
    public boolean queryXML(String additionalTitle, String query, List<String> specifyAttributes) {
        boolean success = super.queryXML(additionalTitle, query, specifyAttributes);
        if (success) {
            ((XmlIoSpimData2)((Object)this.getIO())).setClusterExt(this.getClusterExtension());
        }
        return success;
    }

    public List<Angle> getAnglesToProcess() {
        return (List)this.attributeInstancesToProcess.get("angle");
    }

    public List<Channel> getChannelsToProcess() {
        return (List)this.attributeInstancesToProcess.get("channel");
    }

    public List<Illumination> getIlluminationsToProcess() {
        return (List)this.attributeInstancesToProcess.get("illumination");
    }

    public static void main(String[] args) {
        new ImageJ();
        IOFunctions.printIJLog = true;
        LoadParseQueryXML lpq = new LoadParseQueryXML();
        ArrayList<String> queryFor = new ArrayList<String>();
        queryFor.add("Timepoint");
        queryFor.add("channel");
        queryFor.add("angle");
        queryFor.add("illumination");
        lpq.queryXML(true, true, true, true);
        for (TimePoint i : lpq.getTimePointsToProcess()) {
            System.out.println(i.getId());
        }
        for (ViewSetup v : lpq.getViewSetupsToProcess()) {
            System.out.println(v.getId() + " " + v.getAngle().getName() + " " + v.getChannel().getName() + " " + v.getIllumination().getName());
        }
    }
}

