/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointdetection;

import java.util.ArrayList;
import java.util.Date;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.segmentation.SimplePeak;
import spim.Threads;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointValue;

public class Localization {
    public static ArrayList<InterestPoint> noLocalization(ArrayList<SimplePeak> peaks, boolean findMin, boolean findMax, boolean keepIntensity) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): NO subpixel localization");
        int n = peaks.get((int)0).location.length;
        ArrayList<InterestPoint> peaks2 = new ArrayList<InterestPoint>();
        int id = 0;
        for (SimplePeak peak : peaks) {
            if ((!peak.isMax || !findMax) && (!peak.isMin || !findMin)) continue;
            double[] pos = new double[n];
            for (int d = 0; d < n; ++d) {
                pos[d] = peak.location[d];
            }
            if (keepIntensity) {
                peaks2.add(new InterestPointValue(id++, pos, peak.intensity));
                continue;
            }
            peaks2.add(new InterestPoint(id++, pos));
        }
        return peaks2;
    }

    public static ArrayList<InterestPoint> computeQuadraticLocalization(ArrayList<SimplePeak> peaks, Image<FloatType> domImg, boolean findMin, boolean findMax, float threshold, boolean keepIntensity) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Subpixel localization using quadratic n-dimensional fit");
        ArrayList<DifferenceOfGaussianPeak> peakList = new ArrayList<DifferenceOfGaussianPeak>();
        for (SimplePeak peak : peaks) {
            if ((!peak.isMax || !findMax) && (!peak.isMin || !findMin)) continue;
            peakList.add(new DifferenceOfGaussianPeak(peak.location, (NumericType)new FloatType(peak.intensity), DifferenceOfGaussian.SpecialPoint.MAX));
        }
        SubpixelLocalization spl = new SubpixelLocalization(domImg, peakList);
        spl.setAllowMaximaTolerance(true);
        spl.setMaxNumMoves(10);
        spl.setNumThreads(Threads.numThreads());
        if (!spl.checkInput() || !spl.process()) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Warning! Failed to compute subpixel localization " + spl.getErrorMessage());
        }
        int n = domImg.getNumDimensions();
        ArrayList<InterestPoint> peaks2 = new ArrayList<InterestPoint>();
        int id = 0;
        for (DifferenceOfGaussianPeak detection : peakList) {
            if (!(Math.abs(((FloatType)detection.getValue()).get()) > threshold)) continue;
            double[] tmp = new double[n];
            for (int d = 0; d < n; ++d) {
                tmp[d] = detection.getSubPixelPosition(d);
            }
            if (keepIntensity) {
                peaks2.add(new InterestPointValue(id++, tmp, ((FloatType)detection.getValue()).get()));
                continue;
            }
            peaks2.add(new InterestPoint(id++, tmp));
        }
        return peaks2;
    }

    public static ArrayList<InterestPoint> computeGaussLocalization(ArrayList<SimplePeak> peaks, Image<FloatType> domImg, double sigma, boolean findMin, boolean findMax, float threshold, boolean keepIntensity) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Subpixel localization using Gaussian Mask Localization");
        throw new RuntimeException("Gauss fit not implemented yet");
    }
}

