/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.detection;

import java.util.stream.Collectors;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import org.scijava.plugin.AbstractRichPlugin;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.model.Filaments;

public abstract class AbstractFilamentDetector
extends AbstractRichPlugin
implements FilamentDetector {
    private String name;
    private boolean simplifyFilaments = true;
    private double simplifyToleranceDistance = 2.0;
    private boolean detectOnlyCurrentFrame = false;
    private ImageDisplay imageDisplay;
    private Dataset dataset;
    private Filaments filaments;

    @Override
    public void simplifyFilaments() {
        if (this.isSimplifyFilaments()) {
            Filaments filaments = this.getFilaments();
            filaments = filaments.simplify(this.getSimplifyToleranceDistance());
            filaments = filaments.stream().filter(filament -> filament.getSize() > 1).collect(Collectors.toCollection(Filaments::new));
            this.setFilaments(filaments);
        }
    }

    @Override
    public void setDetectOnlyCurrentFrame(boolean detectOnlyCurrentFrame) {
        this.detectOnlyCurrentFrame = detectOnlyCurrentFrame;
    }

    @Override
    public boolean isSimplifyFilaments() {
        return this.simplifyFilaments;
    }

    @Override
    public void setSimplifyFilaments(boolean simplifyFilaments) {
        this.simplifyFilaments = simplifyFilaments;
    }

    @Override
    public double getSimplifyToleranceDistance() {
        return this.simplifyToleranceDistance;
    }

    @Override
    public void setSimplifyToleranceDistance(double simplifyToleranceDistance) {
        this.simplifyToleranceDistance = simplifyToleranceDistance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public void setFilaments(Filaments filaments) {
        this.filaments = filaments;
    }

    @Override
    public Filaments getFilaments() {
        return this.filaments;
    }

    @Override
    public ImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    @Override
    public void setImageDisplay(ImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isDetectOnlyCurrentFrame() {
        return this.detectOnlyCurrentFrame;
    }
}

