/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller.analyzer;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import net.imagej.Dataset;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.analyzer.LengthOverTimeAnalyzer;
import sc.fiji.filamentdetector.gui.controller.analyzer.AbstractAnalyzerController;
import sc.fiji.filamentdetector.gui.controller.analyzer.AnalyzerController;
import sc.fiji.filamentdetector.model.TrackedFilament;

public class LengthOverTimeAnalyzerController
extends AbstractAnalyzerController
implements AnalyzerController {
    private static String FXML_VIEW_FILE = "/sc/fiji/filamentdetector/gui/view/analyzer/LengthOverTimeAnalyzerView.fxml";
    @Parameter
    private StatusService status;
    @FXML
    private CheckBox saveResultsCheckbox;
    @FXML
    private CheckBox showPlotsCheckbox;
    @FXML
    private CheckBox savePlotsCheckbox;
    private LengthOverTimeAnalyzer analyzer;
    private boolean showPlots = true;
    private boolean savePlots = false;

    public LengthOverTimeAnalyzerController(Context context, LengthOverTimeAnalyzer analyzer) {
        super(context);
        this.setFXMLPath(FXML_VIEW_FILE);
        this.analyzer = analyzer;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.saveResultsCheckbox.setSelected(this.analyzer.isSaveResults());
        this.showPlotsCheckbox.setSelected(this.showPlots);
        this.savePlotsCheckbox.setSelected(this.savePlots);
        this.updateParameters(null);
    }

    @FXML
    void updateParameters(ActionEvent event) {
        this.analyzer.setSaveResults(this.saveResultsCheckbox.isSelected());
        this.showPlots = this.showPlotsCheckbox.isSelected();
        this.savePlots = this.savePlotsCheckbox.isSelected();
        if (this.savePlotsCheckbox.isSelected()) {
            this.showPlotsCheckbox.setSelected(true);
            this.showPlotsCheckbox.setDisable(true);
        } else {
            this.showPlotsCheckbox.setDisable(false);
        }
    }

    @Override
    public void runPostAnalysisAction() {
        if (this.showPlots || this.savePlots) {
            Object results = this.analyzer.getResults();
            List ids = (List)results.get("ids");
            List lengths = (List)results.get("lengths");
            List times = (List)results.get("times");
            TabPane tabPane = new TabPane();
            ArrayList<LineChart> lineCharts = new ArrayList<LineChart>();
            for (final TrackedFilament trackedFilament : this.analyzer.getFilamentWorkflow().getTrackedFilaments()) {
                NumberAxis xAxis = new NumberAxis();
                NumberAxis yAxis = new NumberAxis();
                xAxis.setLabel("Time (s)");
                yAxis.setLabel("Length (um)");
                final LineChart lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
                lineChart.setTitle("Length vs Time Curve for Filament " + trackedFilament.getId());
                XYChart.Series series = new XYChart.Series();
                for (int i = 0; i < lengths.size(); ++i) {
                    if (((Integer)ids.get(i)).intValue() != trackedFilament.getId()) continue;
                    XYChart.Data data = new XYChart.Data();
                    data.setXValue((Object)((Double)times.get(i)));
                    data.setYValue((Object)((Double)lengths.get(i)));
                    series.getData().add((Object)data);
                }
                lineChart.getData().add((Object)series);
                lineCharts.add(lineChart);
                Tab tab = new Tab("Filament " + trackedFilament.getId());
                tab.setClosable(false);
                VBox vbox = new VBox();
                vbox.getChildren().add((Object)lineChart);
                vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                vbox.setSpacing(10.0);
                Button saveButton = new Button("Save this plot");
                vbox.getChildren().add((Object)saveButton);
                saveButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        LengthOverTimeAnalyzerController.this.savePlot(trackedFilament, (LineChart<Number, Number>)lineChart);
                    }
                });
                tab.setContent((Node)vbox);
                tabPane.getTabs().add((Object)tab);
            }
            Stage stage = new Stage();
            stage.initModality(Modality.WINDOW_MODAL);
            stage.setAlwaysOnTop(true);
            stage.setTitle("Length vs Time Curve");
            stage.setScene(new Scene((Parent)tabPane));
            stage.show();
            if (this.savePlots) {
                for (int i = 0; i < this.analyzer.getFilamentWorkflow().getTrackedFilaments().size(); ++i) {
                    this.savePlot((TrackedFilament)this.analyzer.getFilamentWorkflow().getTrackedFilaments().get(i), (LineChart<Number, Number>)((LineChart)lineCharts.get(i)));
                }
            }
        }
    }

    private void savePlot(TrackedFilament trackedFilament, LineChart<Number, Number> lineChart) {
        Dataset dataset = (Dataset)this.analyzer.getFilamentWorkflow().getImageDisplay().getActiveView().getData();
        if (dataset.getSource() != null) {
            String filePath = FilenameUtils.removeExtension((String)dataset.getSource());
            filePath = filePath + "-LengthOverTime-Filament-" + trackedFilament.getId() + ".png";
            File file = new File(filePath);
            WritableImage image = lineChart.snapshot(new SnapshotParameters(), null);
            try {
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", file);
            }
            catch (IOException e) {
                this.status.showStatus("Can't save the plot");
                this.status.showStatus(e.getLocalizedMessage());
            }
        } else {
            this.status.showStatus("Can't save the plot");
        }
    }
}

