/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.convolve;

import java.util.function.Function;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.ClampType;
import net.imglib2.algorithm.blocks.ComputationType;
import net.imglib2.algorithm.blocks.DefaultUnaryBlockOperator;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.algorithm.blocks.convolve.ConvolveProcessors;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class Convolve {
    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> gauss(double ... sigma) {
        return Convolve.gauss(ComputationType.AUTO, sigma);
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> gauss(ComputationType computationType, double ... sigma) {
        return s -> {
            NativeType type = (NativeType)s.getType();
            int n = s.numDimensions();
            return Convolve.createOperator(type, computationType, ClampType.NONE, Convolve.gaussKernels(Util.expandArray(sigma, n)));
        };
    }

    static Kernel1D[] gaussKernels(double[] sigma) {
        Kernel1D[] kernels = new Kernel1D[sigma.length];
        for (int d = 0; d < sigma.length; ++d) {
            if (!(sigma[d] > 0.0)) continue;
            kernels[d] = Kernel1D.symmetric(Gauss3.halfkernel(sigma[d]));
        }
        return kernels;
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> createOperator(T type, ComputationType computationType, ClampType clampType, Kernel1D[] kernels) {
        boolean processAsFloat;
        switch (computationType) {
            case FLOAT: {
                processAsFloat = true;
                break;
            }
            case DOUBLE: {
                processAsFloat = false;
                break;
            }
            default: {
                PrimitiveType pt = type.getNativeTypeFactory().getPrimitiveType();
                processAsFloat = pt.equals((Object)PrimitiveType.FLOAT) || pt.getByteCount() < PrimitiveType.FLOAT.getByteCount();
            }
        }
        UnaryBlockOperator<AbstractRealType, AbstractRealType> op = processAsFloat ? Convolve.convolveFloat(kernels) : Convolve.convolveDouble(kernels);
        return op.adaptSourceType(type, ClampType.NONE).adaptTargetType(type, clampType);
    }

    private static UnaryBlockOperator<FloatType, FloatType> convolveFloat(Kernel1D[] kernels) {
        FloatType type = new FloatType();
        int n = kernels.length;
        return new DefaultUnaryBlockOperator<FloatType, FloatType>(type, type, n, n, new ConvolveProcessors.ConvolveFloat(kernels));
    }

    private static UnaryBlockOperator<DoubleType, DoubleType> convolveDouble(Kernel1D[] kernels) {
        DoubleType type = new DoubleType();
        int n = kernels.length;
        return new DefaultUnaryBlockOperator<DoubleType, DoubleType>(type, type, n, n, new ConvolveProcessors.ConvolveDouble(kernels));
    }
}

