/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.metrics.segmentation;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.metrics.segmentation.SEGMetrics;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.Labelings;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;

public class LazySEGMetrics {
    private AtomicInteger nGT = new AtomicInteger(0);
    private AtomicLong sumScores = new AtomicLong(0L);

    public <T, I extends IntegerType<I>, U, J extends IntegerType<J>> void addTimePoint(ImgLabeling<T, I> groundTruth, ImgLabeling<U, J> prediction) {
        if (Labelings.hasIntersectingLabels(groundTruth) || Labelings.hasIntersectingLabels(prediction)) {
            throw new UnsupportedOperationException("ImgLabeling with intersecting labels are not supported.");
        }
        this.addTimePoint(groundTruth.getIndexImg(), prediction.getIndexImg());
    }

    public <I extends IntegerType<I>, J extends IntegerType<J>> void addTimePoint(RandomAccessibleInterval<I> groundTruth, RandomAccessibleInterval<J> prediction) {
        if (!Intervals.equalDimensions(groundTruth, prediction)) {
            throw new IllegalArgumentException("Image dimensions must match.");
        }
        Pair<Integer, Double> result = SEGMetrics.runSingle(groundTruth, prediction);
        if (Double.compare(result.getB(), Double.NaN) != 0) {
            this.nGT.addAndGet(result.getA());
            this.addToAtomicLong(this.sumScores, result.getB());
        }
    }

    public double computeScore() {
        return this.nGT.get() > 0 ? this.atomicLongToDouble(this.sumScores) / (double)this.nGT.get() : Double.NaN;
    }

    private void addToAtomicLong(AtomicLong a, double b) {
        a.set(Double.doubleToRawLongBits(Double.longBitsToDouble(a.get()) + b));
    }

    private double atomicLongToDouble(AtomicLong a) {
        return Double.longBitsToDouble(a.get());
    }
}

