/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import java.util.Set;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.nio.BufferAccess;
import net.imglib2.img.basictypeaccess.nio.ByteBufferAccess;
import net.imglib2.img.basictypeaccess.nio.CharBufferAccess;
import net.imglib2.img.basictypeaccess.nio.DoubleBufferAccess;
import net.imglib2.img.basictypeaccess.nio.FloatBufferAccess;
import net.imglib2.img.basictypeaccess.nio.IntBufferAccess;
import net.imglib2.img.basictypeaccess.nio.LongBufferAccess;
import net.imglib2.img.basictypeaccess.nio.ShortBufferAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.PrimitiveType;

public class BufferDataAccessFactory {
    public static <T extends NativeType<T>, A extends BufferAccess<A>> A get(T type) {
        return BufferDataAccessFactory.get(type, AccessFlags.setOf());
    }

    public static <T extends NativeType<T>, A extends BufferAccess<A>> A get(T type, Set<AccessFlags> flags) {
        return BufferDataAccessFactory.get(type.getNativeTypeFactory().getPrimitiveType(), flags);
    }

    public static <A extends BufferAccess<A>> A get(NativeTypeFactory<?, ?> typeFactory) {
        return BufferDataAccessFactory.get(typeFactory.getPrimitiveType(), AccessFlags.setOf());
    }

    public static <A extends BufferAccess<A>> A get(NativeTypeFactory<?, ?> typeFactory, Set<AccessFlags> flags) {
        return BufferDataAccessFactory.get(typeFactory.getPrimitiveType(), flags);
    }

    public static <A extends BufferAccess<A>> A get(PrimitiveType primitiveType, Set<AccessFlags> flags) {
        boolean dirty = flags.contains((Object)AccessFlags.DIRTY);
        if (dirty) {
            throw new UnsupportedOperationException("TODO: implement DirtyByteBufferAccess etc.");
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(8);
        switch (primitiveType) {
            case BOOLEAN: {
                throw new UnsupportedOperationException("TODO: so far, no Boolean BufferAccess exists.");
            }
            case BYTE: {
                return (A)ByteBufferAccess.fromByteBuffer(buf, true);
            }
            case CHAR: {
                return (A)CharBufferAccess.fromByteBuffer(buf, true);
            }
            case DOUBLE: {
                return (A)DoubleBufferAccess.fromByteBuffer(buf, true);
            }
            case FLOAT: {
                return (A)FloatBufferAccess.fromByteBuffer(buf, true);
            }
            case INT: {
                return (A)IntBufferAccess.fromByteBuffer(buf, true);
            }
            case LONG: {
                return (A)LongBufferAccess.fromByteBuffer(buf, true);
            }
            case SHORT: {
                return (A)ShortBufferAccess.fromByteBuffer(buf, true);
            }
        }
        throw new IllegalArgumentException();
    }
}

