/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import net.imglib2.IterableRealInterval;
import net.imglib2.RealCursor;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.neighborsearch.KNearestNeighborSearch;

public class KNearestNeighborSearchOnIterableRealInterval<T>
implements KNearestNeighborSearch<T> {
    protected final IterableRealInterval<T> iterable;
    protected final int k;
    protected final int n;
    protected final RealCursor<T>[] elements;
    protected final double[] squareDistances;
    protected final double[] referenceLocation;

    protected final double squareDistance(RealLocalizable query) {
        double squareSum = 0.0;
        for (int d = 0; d < this.n; ++d) {
            double distance = query.getDoublePosition(d) - this.referenceLocation[d];
            squareSum += distance * distance;
        }
        return squareSum;
    }

    public KNearestNeighborSearchOnIterableRealInterval(IterableRealInterval<T> iterable, int k) {
        this.iterable = iterable;
        this.k = k;
        this.n = iterable.numDimensions();
        this.elements = new RealCursor[k];
        this.squareDistances = new double[k];
        this.referenceLocation = new double[this.n];
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public void search(RealLocalizable reference) {
        for (int i = 0; i < this.k; ++i) {
            this.squareDistances[i] = Double.MAX_VALUE;
        }
        reference.localize(this.referenceLocation);
        RealCursor<T> cursor = this.iterable.localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            int i = this.k - 1;
            double squareDistance = this.squareDistance(cursor);
            if (!(this.squareDistances[i] > squareDistance)) continue;
            Sampler candidate = cursor.copy();
            int j = i - 1;
            while (i > 0 && this.squareDistances[j] > squareDistance) {
                this.squareDistances[i] = this.squareDistances[j];
                this.elements[i] = this.elements[j];
                --i;
                --j;
            }
            this.squareDistances[i] = squareDistance;
            this.elements[i] = candidate;
        }
    }

    @Override
    public RealLocalizable getPosition(int i) {
        return this.elements[i];
    }

    @Override
    public RealCursor<T> getSampler(int i) {
        return this.elements[i];
    }

    @Override
    public double getSquareDistance(int i) {
        return this.squareDistances[i];
    }

    @Override
    public double getDistance(int i) {
        return Math.sqrt(this.squareDistances[i]);
    }

    @Override
    public RealLocalizable getPosition() {
        return this.getPosition(0);
    }

    @Override
    public Sampler<T> getSampler() {
        return this.getSampler(0);
    }

    @Override
    public double getSquareDistance() {
        return this.getSquareDistance(0);
    }

    @Override
    public double getDistance() {
        return this.getDistance(0);
    }

    @Override
    public KNearestNeighborSearchOnIterableRealInterval<T> copy() {
        KNearestNeighborSearchOnIterableRealInterval<T> copy = new KNearestNeighborSearchOnIterableRealInterval<T>(this.iterable, this.k);
        System.arraycopy(this.referenceLocation, 0, copy.referenceLocation, 0, this.referenceLocation.length);
        for (int i = 0; i < this.k; ++i) {
            copy.elements[i] = this.elements[i];
            copy.squareDistances[i] = this.squareDistances[i];
        }
        return copy;
    }
}

