/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.test;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.RealInterval;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.operators.ValueEquals;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class ImgLib2Assert {
    private ImgLib2Assert() {
    }

    public static <A extends ValueEquals<B>, B> void assertImageEquals(RandomAccessibleInterval<? extends A> expected, RandomAccessibleInterval<? extends B> actual) {
        ImgLib2Assert.assertImageEquals(expected, actual, ValueEquals::valueEquals);
    }

    public static void assertImageEqualsRealType(RandomAccessibleInterval<? extends RealType<?>> expected, RandomAccessibleInterval<? extends RealType<?>> actual, double tolerance) {
        ImgLib2Assert.assertImageEquals(expected, actual, (a, e) -> Math.abs(a.getRealDouble() - e.getRealDouble()) <= tolerance);
    }

    public static void assertImageEqualsIntegerType(RandomAccessibleInterval<? extends IntegerType<?>> expected, RandomAccessibleInterval<? extends IntegerType<?>> actual) {
        ImgLib2Assert.assertImageEquals(expected, actual, (a, e) -> a.getIntegerLong() == e.getIntegerLong());
    }

    public static <A, B> void assertImageEquals(RandomAccessibleInterval<? extends A> expected, RandomAccessibleInterval<? extends B> actual, BiPredicate<A, B> equals) {
        ImgLib2Assert.assertIntervalEquals(expected, actual);
        IntervalView<Pair<A, B>> pairs = Views.interval(Views.pair(expected, actual), actual);
        RealCursor cursor = pairs.cursor();
        while (cursor.hasNext()) {
            Pair p = (Pair)cursor.next();
            if (equals.test(p.getA(), p.getB())) continue;
            ImgLib2Assert.fail("Pixel values differ on coordinate " + ImgLib2Assert.positionToString((Localizable)((Object)cursor)) + ", expected: " + p.getA() + " actual: " + p.getB());
        }
    }

    public static void assertIntervalEquals(Interval expected, Interval actual) {
        if (!Intervals.equals(expected, actual)) {
            ImgLib2Assert.fail("Intervals are different, expected: " + ImgLib2Assert.intervalToString(expected) + ", actual: " + ImgLib2Assert.intervalToString(actual));
        }
    }

    public static void assertIntervalEquals(RealInterval expected, RealInterval actual, double tolerance) {
        if (!Intervals.equals(expected, actual, tolerance)) {
            ImgLib2Assert.fail("Intervals are different, expected: " + ImgLib2Assert.intervalToString(expected) + ", actual: " + ImgLib2Assert.intervalToString(actual));
        }
    }

    private static String positionToString(Localizable localizable) {
        StringJoiner joiner = new StringJoiner(", ");
        int n = localizable.numDimensions();
        for (int i = 0; i < n; ++i) {
            joiner.add(String.valueOf(localizable.getIntPosition(i)));
        }
        return "(" + joiner + ")";
    }

    static String intervalToString(Interval interval) {
        return "{min=" + Arrays.toString(Intervals.minAsLongArray(interval)) + ", max=" + Arrays.toString(Intervals.maxAsLongArray(interval)) + "}";
    }

    private static String intervalToString(RealInterval interval) {
        return "{min=" + Arrays.toString(Intervals.minAsDoubleArray(interval)) + ", max=" + Arrays.toString(Intervals.maxAsDoubleArray(interval)) + "}";
    }

    private static void fail(String message) {
        throw new AssertionError((Object)message);
    }
}

