/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import mpicbg.imglib.algorithm.gauss.GaussianConvolution;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class GaussianConvolutionReal<T extends RealType<T>>
extends GaussianConvolution<T> {
    public GaussianConvolutionReal(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory, double[] sigma) {
        super(image, outOfBoundsFactory, sigma);
    }

    public GaussianConvolutionReal(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory, double sigma) {
        this(image, outOfBoundsFactory, GaussianConvolutionReal.createArray(image, sigma));
    }

    @Override
    protected void convolve(LocalizableByDimCursor<T> inputIterator, LocalizableCursor<T> outputIterator, int dim, double[] kernel, long startPos, long loopSize) {
        outputIterator.fwd(startPos);
        int filterSize = kernel.length;
        int filterSizeMinus1 = filterSize - 1;
        int filterSizeHalf = filterSize / 2;
        int filterSizeHalfMinus1 = filterSizeHalf - 1;
        int numDimensions = inputIterator.getImage().getNumDimensions();
        int iteratorPosition = filterSizeHalf;
        double lastKernelEntry = kernel[filterSizeMinus1];
        int[] to = new int[numDimensions];
        for (long j = 0L; j < loopSize; ++j) {
            outputIterator.fwd();
            double sum = 0.0;
            outputIterator.getPosition(to);
            int n = dim;
            to[n] = to[n] - iteratorPosition;
            inputIterator.setPosition(to);
            for (int f = -filterSizeHalf; f <= filterSizeHalfMinus1; ++f) {
                sum += ((RealType)inputIterator.getType()).getRealDouble() * kernel[f + filterSizeHalf];
                inputIterator.fwd(dim);
            }
            ((RealType)outputIterator.getType()).setReal(sum += ((RealType)inputIterator.getType()).getRealDouble() * lastKernelEntry);
        }
    }
}

