/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.io;

import ij.ImagePlus;
import ij.io.Opener;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.Unsigned12BitType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.real.FloatType;

public class LOCI {
    public static <T extends RealType<T>> Image<T> open(String fileName) {
        return LOCI.openLOCI("", fileName, new ArrayContainerFactory());
    }

    public static <T extends RealType<T>> Image<T> openLOCI(String fileName, ContainerFactory containerFactory) {
        return LOCI.openLOCI("", fileName, containerFactory);
    }

    public static <T extends RealType<T>> Image<T> openLOCI(String path, String fileName, ContainerFactory containerFactory) {
        return LOCI.openLOCI(path, fileName, containerFactory, -1, -1);
    }

    public static <T extends RealType<T>> Image<T> openLOCI(String path, String fileName, ContainerFactory containerFactory, int from, int to) {
        path = LOCI.checkPath(path);
        String id = path + fileName;
        ChannelSeparator r = new ChannelSeparator();
        try {
            r.setId(id);
            int pixelType = r.getPixelType();
            int channels = r.getSizeC();
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (pixelType != 1 && pixelType != 3 && pixelType != 5 && pixelType != 6) {
                System.out.println("LOCI.openLOCI(): PixelType " + pixelTypeString + " not supported yet, returning. ");
                return null;
            }
            if (channels > 1 && channels <= 3 && pixelType == 1) {
                return LOCI.openLOCIRGBALegacyType(path, fileName, new ImageFactory<RGBALegacyType>(new RGBALegacyType(), containerFactory), from, to);
            }
            if (pixelType == 6 || pixelType == 5) {
                return LOCI.openLOCIFloatType(path, fileName, new ImageFactory<FloatType>(new FloatType(), containerFactory), from, to);
            }
            if (pixelType == 3) {
                return LOCI.openLOCIShortType(path, fileName, new ImageFactory<ShortType>(new ShortType(), containerFactory), from, to);
            }
            if (pixelType == 1) {
                return LOCI.openLOCIUnsignedByteType(path, fileName, new ImageFactory<UnsignedByteType>(new UnsignedByteType(), containerFactory), from, to);
            }
            return null;
        }
        catch (IOException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
        catch (FormatException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String fileName, ContainerFactory factory) {
        return LOCI.openLOCIUnsigned12BitType(fileName, new ImageFactory<Unsigned12BitType>(new Unsigned12BitType(), factory));
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String fileName, ImageFactory<Unsigned12BitType> factory) {
        return LOCI.openLOCIUnsigned12BitType("", fileName, factory);
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String path, String fileName, ContainerFactory factory) {
        return LOCI.openLOCIUnsigned12BitType(path, fileName, new ImageFactory<Unsigned12BitType>(new Unsigned12BitType(), factory));
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String path, String fileName, ImageFactory<Unsigned12BitType> factory) {
        return LOCI.openLOCIUnsigned12BitType(path, fileName, factory, -1, -1);
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String path, String fileName, ContainerFactory factory, int from, int to) {
        return LOCI.openLOCIUnsigned12BitType(path, fileName, new ImageFactory<Unsigned12BitType>(new Unsigned12BitType(), factory), from, to);
    }

    private static boolean createOMEXMLMetadata(IFormatReader r) {
        try {
            ServiceFactory serviceFactory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)serviceFactory.getInstance(OMEXMLService.class);
            OMEXMLMetadata omexmlMeta = service.createOMEXMLMetadata();
            r.setMetadataStore((MetadataStore)omexmlMeta);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (DependencyException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String path, String fileName, ImageFactory<Unsigned12BitType> factory, int from, int to) {
        path = LOCI.checkPath(path);
        ChannelSeparator r = new ChannelSeparator();
        if (!LOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        String id = path + fileName;
        try {
            int end;
            int start;
            r.setId(id);
            boolean isLittleEndian = r.isLittleEndian();
            int width = r.getSizeX();
            int height = r.getSizeY();
            int depth = r.getSizeZ();
            int timepoints = r.getSizeT();
            int channels = r.getSizeC();
            int pixelType = r.getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (timepoints > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                timepoints = 1;
            }
            if (channels > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<ShortType> supports only 1 channel right now, returning the first channel.");
                channels = 1;
            }
            if (pixelType != 1 && pixelType != 3) {
                System.out.println("LOCI.openLOCI(): PixelType " + pixelTypeString + " not supported by ShortType, returning. ");
                return null;
            }
            if (from < 0 || to < 0 || to < from) {
                start = 0;
                end = depth;
            } else {
                start = from;
                end = to > depth ? depth : to;
            }
            Image<Unsigned12BitType> img = end - start == 1 ? factory.createImage(new int[]{width, height}, fileName) : factory.createImage(new int[]{width, height, end - start}, fileName);
            if (img == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + fileName + "' [" + width + "x" + height + "x" + depth + " type=" + pixelTypeString + " image=Image<ShortType>]");
            img.setName(fileName);
            try {
                LOCI.applyMetaData(img, (IFormatReader)r);
            }
            catch (Exception e) {
                System.out.println("Cannot read metadata: " + e);
            }
            boolean t = false;
            byte[][] b = new byte[channels][width * height * bytesPerPixel];
            int[] planePos = new int[3];
            boolean planeX = false;
            boolean planeY = true;
            LocalizablePlaneCursor<Unsigned12BitType> it = img.createLocalizablePlaneCursor();
            for (int z = start; z < end; ++z) {
                planePos[2] = z - start;
                it.reset(0, 1, planePos);
                for (int c = 0; c < channels; ++c) {
                    int index = r.getIndex(z, c, 0);
                    r.openBytes(index, b[c]);
                }
                if (channels != 1) continue;
                if (pixelType == 1) {
                    while (it.hasNext()) {
                        it.fwd();
                        ((Unsigned12BitType)it.getType()).set((short)(b[0][it.getPosition(0) + it.getPosition(1) * width] & 0xFF));
                    }
                    continue;
                }
                while (it.hasNext()) {
                    it.fwd();
                    ((Unsigned12BitType)it.getType()).set(LOCI.getShortValue(b[0], (it.getPosition(0) + it.getPosition(1) * width) * 2, isLittleEndian));
                }
            }
            it.close();
            return img;
        }
        catch (IOException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
        catch (FormatException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
    }

    public static Image<ShortType> openLOCIShortType(String fileName, ContainerFactory factory) {
        return LOCI.openLOCIShortType(fileName, new ImageFactory<ShortType>(new ShortType(), factory));
    }

    public static Image<ShortType> openLOCIShortType(String fileName, ImageFactory<ShortType> factory) {
        return LOCI.openLOCIShortType("", fileName, factory);
    }

    public static Image<ShortType> openLOCIShortType(String path, String fileName, ContainerFactory factory) {
        return LOCI.openLOCIShortType(path, fileName, new ImageFactory<ShortType>(new ShortType(), factory));
    }

    public static Image<ShortType> openLOCIShortType(String path, String fileName, ImageFactory<ShortType> factory) {
        return LOCI.openLOCIShortType(path, fileName, factory, -1, -1);
    }

    public static Image<ShortType> openLOCIShortType(String path, String fileName, ContainerFactory factory, int from, int to) {
        return LOCI.openLOCIShortType(path, fileName, new ImageFactory<ShortType>(new ShortType(), factory), from, to);
    }

    public static Image<ShortType> openLOCIShortType(String path, String fileName, ImageFactory<ShortType> factory, int from, int to) {
        path = LOCI.checkPath(path);
        ChannelSeparator r = new ChannelSeparator();
        if (!LOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        String id = path + fileName;
        File dir = new File(path + fileName);
        if (dir.isDirectory()) {
            String[] files = dir.list();
            int depth = dir.list().length;
            Opener io = new Opener();
            ImagePlus imp2d = io.openImage(dir.getAbsolutePath() + File.separator + files[0]);
            System.out.println("Opening '" + fileName + "' [" + imp2d.getWidth() + "x" + imp2d.getHeight() + "x" + depth + " type=" + imp2d.getProcessor().getClass().getSimpleName() + " image=Image<ShortType>]");
            Image<ShortType> output = factory.createImage(new int[]{imp2d.getWidth(), imp2d.getHeight(), depth}, fileName);
            for (int i = 0; i < depth; ++i) {
                imp2d = io.openImage(dir.getAbsolutePath() + File.separator + files[i]);
                ShortProcessor ip = (ShortProcessor)imp2d.getProcessor();
                LocalizablePlaneCursor<ShortType> cursorOut = output.createLocalizablePlaneCursor();
                cursorOut.reset(0, 1, new int[]{0, 0, i});
                while (cursorOut.hasNext()) {
                    cursorOut.fwd();
                    ((ShortType)cursorOut.getType()).set((short)ip.get(cursorOut.getPosition(0), cursorOut.getPosition(1)));
                }
            }
            return output;
        }
        try {
            int end;
            int start;
            r.setId(id);
            boolean isLittleEndian = r.isLittleEndian();
            int width = r.getSizeX();
            int height = r.getSizeY();
            int depth = r.getSizeZ();
            int timepoints = r.getSizeT();
            int channels = r.getSizeC();
            int pixelType = r.getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (timepoints > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                timepoints = 1;
            }
            if (channels > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<ShortType> supports only 1 channel right now, returning the first channel.");
                channels = 1;
            }
            if (pixelType != 1 && pixelType != 3) {
                System.out.println("LOCI.openLOCI(): PixelType " + pixelTypeString + " not supported by ShortType, returning. ");
                return null;
            }
            if (from < 0 || to < 0 || to < from) {
                start = 0;
                end = depth;
            } else {
                start = from;
                end = to > depth ? depth : to;
            }
            Image<ShortType> img = end - start == 1 ? factory.createImage(new int[]{width, height}, fileName) : factory.createImage(new int[]{width, height, end - start}, fileName);
            if (img == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + fileName + "' [" + width + "x" + height + "x" + depth + " type=" + pixelTypeString + " image=Image<ShortType>]");
            img.setName(fileName);
            try {
                LOCI.applyMetaData(img, (IFormatReader)r);
            }
            catch (Exception e) {
                System.out.println("Cannot read metadata: " + e);
            }
            boolean t = false;
            byte[][] b = new byte[channels][width * height * bytesPerPixel];
            int[] planePos = new int[3];
            boolean planeX = false;
            boolean planeY = true;
            LocalizablePlaneCursor<ShortType> it = img.createLocalizablePlaneCursor();
            for (int z = start; z < end; ++z) {
                planePos[2] = z - start;
                it.reset(0, 1, planePos);
                for (int c = 0; c < channels; ++c) {
                    int index = r.getIndex(z, c, 0);
                    r.openBytes(index, b[c]);
                }
                if (channels != 1) continue;
                if (pixelType == 1) {
                    while (it.hasNext()) {
                        it.fwd();
                        ((ShortType)it.getType()).set((short)(b[0][it.getPosition(0) + it.getPosition(1) * width] & 0xFF));
                    }
                    continue;
                }
                while (it.hasNext()) {
                    it.fwd();
                    ((ShortType)it.getType()).set(LOCI.getShortValue(b[0], (it.getPosition(0) + it.getPosition(1) * width) * 2, isLittleEndian));
                }
            }
            it.close();
            return img;
        }
        catch (IOException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
        catch (FormatException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
    }

    protected static void applyMetaData(Image<?> img, IFormatReader reader) {
        for (int d = 0; d < img.getNumDimensions(); ++d) {
            img.setCalibration(1.0f, d);
        }
        try {
            MetadataRetrieve retrieve = (MetadataRetrieve)reader.getMetadataStore();
            float cal = retrieve.getPixelsPhysicalSizeX(0).value().floatValue();
            if (cal == 0.0f) {
                cal = 1.0f;
                System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 0 seems corrupted, setting to 1.");
            }
            img.setCalibration(cal, 0);
            if (img.getNumDimensions() >= 2) {
                cal = retrieve.getPixelsPhysicalSizeY(0).value().floatValue();
                if (cal == 0.0f) {
                    cal = 1.0f;
                    System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 1 seems corrupted, setting to 1.");
                }
                img.setCalibration(cal, 1);
            }
            if (img.getNumDimensions() >= 3) {
                cal = retrieve.getPixelsPhysicalSizeZ(0).value().floatValue();
                if (cal == 0.0f) {
                    cal = 1.0f;
                    System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 2 seems corrupted, setting to 1.");
                }
                img.setCalibration(cal, 2);
            }
            if (img.getNumDimensions() >= 4) {
                cal = retrieve.getPixelsTimeIncrement(0).value().floatValue();
                if (cal == 0.0f) {
                    cal = 1.0f;
                    System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 3 seems corrupted, setting to 1.");
                }
                img.setCalibration(cal, 3);
            }
        }
        catch (Exception e) {
            System.out.println("LOCI.openLOCI(): Cannot read metadata, setting calibration to 1");
            return;
        }
    }

    public static Image<FloatType> openLOCIFloatType(String fileName, ContainerFactory factory) {
        return LOCI.openLOCIFloatType(fileName, new ImageFactory<FloatType>(new FloatType(), factory));
    }

    public static Image<FloatType> openLOCIFloatType(String fileName, ImageFactory<FloatType> factory) {
        return LOCI.openLOCIFloatType("", fileName, factory);
    }

    public static Image<FloatType> openLOCIFloatType(String path, String fileName, ContainerFactory factory) {
        return LOCI.openLOCIFloatType(path, fileName, new ImageFactory<FloatType>(new FloatType(), factory));
    }

    public static Image<FloatType> openLOCIFloatType(String path, String fileName, ImageFactory<FloatType> factory) {
        return LOCI.openLOCIFloatType(path, fileName, factory, -1, -1);
    }

    public static Image<FloatType> openLOCIFloatType(String path, String fileName, ContainerFactory factory, int from, int to) {
        return LOCI.openLOCIFloatType(path, fileName, new ImageFactory<FloatType>(new FloatType(), factory), from, to);
    }

    public static Image<FloatType> openLOCIFloatType(String path, String fileName, ImageFactory<FloatType> factory, int from, int to) {
        File dir = new File((path = LOCI.checkPath(path)) + fileName);
        if (dir.isDirectory()) {
            Object[] files = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File newFile = new File(dir, name);
                    return !newFile.isHidden() && !newFile.isDirectory();
                }
            });
            Arrays.sort(files);
            int depth = files.length;
            Opener io = new Opener();
            ImagePlus imp2d = io.openImage(dir.getAbsolutePath() + File.separator + (String)files[0]);
            System.out.println("Opening '" + fileName + "' [" + imp2d.getWidth() + "x" + imp2d.getHeight() + "x" + depth + " type=" + imp2d.getProcessor().getClass().getSimpleName() + " image=Image<FloatType>]");
            Image<FloatType> output = factory.createImage(new int[]{imp2d.getWidth(), imp2d.getHeight(), depth}, fileName);
            for (int i = 0; i < depth; ++i) {
                imp2d = io.openImage(dir.getAbsolutePath() + File.separator + (String)files[i]);
                ImageProcessor ip = imp2d.getProcessor();
                LocalizablePlaneCursor<FloatType> cursorOut = output.createLocalizablePlaneCursor();
                cursorOut.reset(0, 1, new int[]{0, 0, i});
                while (cursorOut.hasNext()) {
                    cursorOut.fwd();
                    ((FloatType)cursorOut.getType()).set(ip.getPixelValue(cursorOut.getPosition(0), cursorOut.getPosition(1)));
                }
            }
            return output;
        }
        ChannelSeparator r = new ChannelSeparator();
        if (!LOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        String id = path + fileName;
        try {
            int end;
            int start;
            r.setId(id);
            boolean isLittleEndian = r.isLittleEndian();
            int width = r.getSizeX();
            int height = r.getSizeY();
            int depth = r.getSizeZ();
            int timepoints = r.getSizeT();
            int channels = r.getSizeC();
            int pixelType = r.getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (timepoints > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                timepoints = 1;
            }
            if (channels > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<FloatType> supports only 1 channel right now, returning the first channel.");
                channels = 1;
            }
            if (pixelType != 1 && pixelType != 3 && pixelType != 5 && pixelType != 6) {
                System.out.println("LOCI.openLOCI(): PixelType " + pixelTypeString + " not supported by FloatType, returning. ");
                return null;
            }
            if (from < 0 || to < 0 || to < from) {
                start = 0;
                end = depth;
            } else {
                start = from;
                end = to > depth ? depth : to;
            }
            Image<FloatType> img = end - start == 1 ? factory.createImage(new int[]{width, height}, fileName) : factory.createImage(new int[]{width, height, end - start}, fileName);
            if (img == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + fileName + "' [" + width + "x" + height + "x" + depth + " type=" + pixelTypeString + " image=Image<FloatType>]");
            img.setName(fileName);
            try {
                LOCI.applyMetaData(img, (IFormatReader)r);
            }
            catch (Exception e) {
                System.out.println("Cannot read metadata: " + e);
            }
            boolean t = false;
            byte[][] b = new byte[channels][width * height * bytesPerPixel];
            int[] planePos = new int[3];
            boolean planeX = false;
            boolean planeY = true;
            LocalizablePlaneCursor<FloatType> it = img.createLocalizablePlaneCursor();
            for (int z = start; z < end; ++z) {
                planePos[2] = z - start;
                it.reset(0, 1, planePos);
                for (int c = 0; c < channels; ++c) {
                    int index = r.getIndex(z, c, 0);
                    r.openBytes(index, b[c]);
                }
                if (channels != 1) continue;
                if (pixelType == 1) {
                    while (it.hasNext()) {
                        it.fwd();
                        ((FloatType)it.getType()).set(b[0][it.getPosition(0) + it.getPosition(1) * width] & 0xFF);
                    }
                    continue;
                }
                if (pixelType == 3) {
                    while (it.hasNext()) {
                        it.fwd();
                        ((FloatType)it.getType()).set(LOCI.getShortValueInt(b[0], (it.getPosition(0) + it.getPosition(1) * width) * 2, isLittleEndian));
                    }
                    continue;
                }
                if (pixelType == 5) {
                    while (it.hasNext()) {
                        it.fwd();
                        ((FloatType)it.getType()).set(LOCI.getIntValue(b[0], (it.getPosition(0) + it.getPosition(1) * width) * 4, isLittleEndian));
                    }
                    continue;
                }
                if (pixelType != 6) continue;
                while (it.hasNext()) {
                    it.fwd();
                    ((FloatType)it.getType()).set(LOCI.getFloatValue(b[0], (it.getPosition(0) + it.getPosition(1) * width) * 4, isLittleEndian));
                }
            }
            it.close();
            return img;
        }
        catch (IOException exc) {
            exc.printStackTrace();
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
        catch (FormatException exc) {
            exc.printStackTrace();
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
    }

    public static Image<ByteType> openLOCIByteType(String fileName, ContainerFactory factory) {
        return LOCI.openLOCIByteType("", fileName, new ImageFactory<ByteType>(new ByteType(), factory));
    }

    public static Image<ByteType> openLOCIByteType(String fileName, ImageFactory<ByteType> factory) {
        return LOCI.openLOCIByteType("", fileName, factory);
    }

    public static Image<ByteType> openLOCIByteType(String path, String fileName, ContainerFactory factory) {
        return LOCI.openLOCIByteType(path, fileName, new ImageFactory<ByteType>(new ByteType(), factory));
    }

    public static Image<ByteType> openLOCIByteType(String path, String fileName, ImageFactory<ByteType> factory) {
        return LOCI.openLOCIByteType(path, fileName, factory, -1, -1);
    }

    public static Image<ByteType> openLOCIByteType(String path, String fileName, ImageFactory<ByteType> factory, int from, int to) {
        path = LOCI.checkPath(path);
        ChannelSeparator r = new ChannelSeparator();
        if (!LOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        String id = path + fileName;
        try {
            int end;
            int start;
            r.setId(id);
            int width = r.getSizeX();
            int height = r.getSizeY();
            int depth = r.getSizeZ();
            int timepoints = r.getSizeT();
            int channels = r.getSizeC();
            int pixelType = r.getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (timepoints > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                timepoints = 1;
            }
            if (channels > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<ByteType> supports only 1 channel right now, returning the first channel.");
                channels = 1;
            }
            if (pixelType != 1) {
                System.out.println("LOCI.openLOCI(): PixelType " + pixelTypeString + " not supported by ByteType, returning. ");
                return null;
            }
            if (from < 0 || to < 0 || to < from) {
                start = 0;
                end = depth;
            } else {
                start = from;
                end = to > depth ? depth : to;
            }
            Image<ByteType> img = end - start == 1 ? factory.createImage(new int[]{width, height}, fileName) : factory.createImage(new int[]{width, height, end - start}, fileName);
            if (img == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + fileName + "' [" + width + "x" + height + "x" + depth + " type=" + pixelTypeString + " image=Image<ByteType>]");
            img.setName(fileName);
            try {
                LOCI.applyMetaData(img, (IFormatReader)r);
            }
            catch (Exception e) {
                System.out.println("Cannot read metadata: " + e);
            }
            boolean t = false;
            byte[][] b = new byte[channels][width * height * bytesPerPixel];
            int[] planePos = new int[3];
            boolean planeX = false;
            boolean planeY = true;
            LocalizablePlaneCursor<ByteType> it = img.createLocalizablePlaneCursor();
            ByteType type = (ByteType)it.getType();
            for (int z = start; z < end; ++z) {
                planePos[2] = z - start;
                it.reset(0, 1, planePos);
                for (int c = 0; c < channels; ++c) {
                    int index = r.getIndex(z, c, 0);
                    r.openBytes(index, b[c]);
                }
                if (channels != 1) continue;
                while (it.hasNext()) {
                    it.fwd();
                    type.set(b[0][it.getPosition(0) + it.getPosition(1) * width]);
                }
            }
            it.close();
            return img;
        }
        catch (IOException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
        catch (FormatException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String fileName, ContainerFactory factory) {
        return LOCI.openLOCIUnsignedByteType("", fileName, new ImageFactory<UnsignedByteType>(new UnsignedByteType(), factory));
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String fileName, ImageFactory<UnsignedByteType> factory) {
        return LOCI.openLOCIUnsignedByteType("", fileName, factory);
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String path, String fileName, ContainerFactory factory) {
        return LOCI.openLOCIUnsignedByteType(path, fileName, new ImageFactory<UnsignedByteType>(new UnsignedByteType(), factory));
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String path, String fileName, ImageFactory<UnsignedByteType> factory) {
        return LOCI.openLOCIUnsignedByteType(path, fileName, factory, -1, -1);
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String path, String fileName, ImageFactory<UnsignedByteType> factory, int from, int to) {
        path = LOCI.checkPath(path);
        ChannelSeparator r = new ChannelSeparator();
        if (!LOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        String id = path + fileName;
        try {
            int end;
            int start;
            r.setId(id);
            int width = r.getSizeX();
            int height = r.getSizeY();
            int depth = r.getSizeZ();
            int timepoints = r.getSizeT();
            int channels = r.getSizeC();
            int pixelType = r.getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (timepoints > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                timepoints = 1;
            }
            if (channels > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<UnsignedByteType> supports only 1 channel right now, returning the first channel.");
                channels = 1;
            }
            if (pixelType != 1) {
                System.out.println("LOCI.openLOCI(): PixelType " + pixelTypeString + " not supported by UnsignedByteType, returning. ");
                return null;
            }
            if (from < 0 || to < 0 || to < from) {
                start = 0;
                end = depth;
            } else {
                start = from;
                end = to > depth ? depth : to;
            }
            Image<UnsignedByteType> img = end - start == 1 ? factory.createImage(new int[]{width, height}, fileName) : factory.createImage(new int[]{width, height, end - start}, fileName);
            if (img == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + fileName + "' [" + width + "x" + height + "x" + depth + " type=" + pixelTypeString + " image=Image<ByteType>]");
            img.setName(fileName);
            try {
                LOCI.applyMetaData(img, (IFormatReader)r);
            }
            catch (Exception e) {
                System.out.println("Cannot read metadata: " + e);
            }
            boolean t = false;
            byte[][] b = new byte[channels][width * height * bytesPerPixel];
            int[] planePos = new int[3];
            boolean planeX = false;
            boolean planeY = true;
            LocalizablePlaneCursor<UnsignedByteType> it = img.createLocalizablePlaneCursor();
            UnsignedByteType type = (UnsignedByteType)it.getType();
            for (int z = start; z < end; ++z) {
                planePos[2] = z - start;
                it.reset(0, 1, planePos);
                for (int c = 0; c < channels; ++c) {
                    int index = r.getIndex(z, c, 0);
                    r.openBytes(index, b[c]);
                }
                if (channels != 1) continue;
                while (it.hasNext()) {
                    it.fwd();
                    type.set(UnsignedByteType.getUnsignedByte(b[0][it.getPosition(0) + it.getPosition(1) * width]));
                }
            }
            it.close();
            return img;
        }
        catch (IOException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
        catch (FormatException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
    }

    public static Image<RGBALegacyType> openLOCIRGBALegacyType(String path, String fileName, ImageFactory<RGBALegacyType> factory) {
        return LOCI.openLOCIRGBALegacyType(path, fileName, factory, -1, -1);
    }

    public static Image<RGBALegacyType> openLOCIRGBALegacyType(String path, String fileName, ImageFactory<RGBALegacyType> factory, int from, int to) {
        path = LOCI.checkPath(path);
        ChannelSeparator r = new ChannelSeparator();
        if (!LOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        String id = path + fileName;
        try {
            int end;
            int start;
            r.setId(id);
            int width = r.getSizeX();
            int height = r.getSizeY();
            int depth = r.getSizeZ();
            int timepoints = r.getSizeT();
            int channels = r.getSizeC();
            int pixelType = r.getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (timepoints > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                timepoints = 1;
            }
            if (channels > 3) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<RGBALegacyType> supports only 3 channels right now, returning the first 3 channels.");
                channels = 3;
            }
            if (pixelType != 1) {
                System.out.println("LOCI.openLOCI(): PixelType " + pixelTypeString + " not supported by RGBALegacyType, returning. ");
                return null;
            }
            if (from < 0 || to < 0 || to < from) {
                start = 0;
                end = depth;
            } else {
                start = from;
                end = to > depth ? depth : to;
            }
            Image<RGBALegacyType> img = end - start == 1 ? factory.createImage(new int[]{width, height}, fileName) : factory.createImage(new int[]{width, height, end - start}, fileName);
            if (img == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + fileName + "' [" + width + "x" + height + "x" + depth + " channels=" + channels + " type=" + pixelTypeString + " image=RGBALegacyTypeImage]");
            img.setName(fileName);
            try {
                LOCI.applyMetaData(img, (IFormatReader)r);
            }
            catch (Exception e) {
                System.out.println("Cannot read metadata: " + e);
            }
            boolean t = false;
            byte[][] b = new byte[channels][width * height * bytesPerPixel];
            int[] planePos = new int[3];
            boolean planeX = false;
            boolean planeY = true;
            LocalizablePlaneCursor<RGBALegacyType> it = img.createLocalizablePlaneCursor();
            for (int z = start; z < end; ++z) {
                planePos[2] = z - start;
                it.reset(0, 1, planePos);
                for (int c = 0; c < channels; ++c) {
                    int index = r.getIndex(z, c, 0);
                    r.openBytes(index, b[c]);
                }
                byte[] col = new byte[3];
                while (it.hasNext()) {
                    it.fwd();
                    for (int channel = 0; channel < channels; ++channel) {
                        col[channels - channel - 1] = b[channel][it.getPosition(0) + it.getPosition(1) * width];
                    }
                    ((RGBALegacyType)it.getType()).set(RGBALegacyType.rgba(col[0], col[1], col[2], 0));
                }
            }
            it.close();
            return img;
        }
        catch (IOException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
        catch (FormatException exc) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + exc.getMessage());
            return null;
        }
    }

    protected static String checkPath(String path) {
        if (path.length() > 1 && !(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private static final float getFloatValue(byte[] b, int i, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Float.intBitsToFloat(((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF));
        }
        return Float.intBitsToFloat(((b[i] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + (b[i + 3] & 0xFF));
    }

    private static final int getIntValue(byte[] b, int i, boolean isLittleEndian) {
        if (isLittleEndian) {
            return ((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF);
        }
        return ((b[i] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + (b[i + 3] & 0xFF);
    }

    private static final short getShortValue(byte[] b, int i, boolean isLittleEndian) {
        return (short)LOCI.getShortValueInt(b, i, isLittleEndian);
    }

    private static final int getShortValueInt(byte[] b, int i, boolean isLittleEndian) {
        if (isLittleEndian) {
            return ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF);
        }
        return ((b[i] & 0xFF) << 8) + (b[i + 1] & 0xFF);
    }
}

