/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.AbstractWritableSuperEllipsoid;
import net.imglib2.roi.geom.real.WritableEllipsoid;

public abstract class AbstractWritableEllipsoid
extends AbstractWritableSuperEllipsoid
implements WritableEllipsoid {
    public AbstractWritableEllipsoid(double[] center, double[] semiAxisLengths) {
        super(center, semiAxisLengths, 2.0);
    }

    @Override
    public void setExponent(double exponent) {
        throw new UnsupportedOperationException("setExponent: can only have an exponent of 2");
    }

    @Override
    protected double distancePowered(RealLocalizable l) {
        assert (l.numDimensions() >= this.n) : "l must have no less than " + this.n + " dimensions";
        double distancePowered = 0.0;
        for (int d = 0; d < this.n; ++d) {
            distancePowered += (l.getDoublePosition(d) - this.center[d]) / this.semiAxisLengths[d] * ((l.getDoublePosition(d) - this.center[d]) / this.semiAxisLengths[d]);
        }
        return distancePowered;
    }
}

